/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.client.model;

import com.google.common.collect.ImmutableSet;
import net.minecraft.client.renderer.entity.model.AgeableModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import quek.undergarden.entity.GloomperEntity;

@OnlyIn(value=Dist.CLIENT)
public class GloomperModel<T extends GloomperEntity>
extends AgeableModel<T> {
    private final ModelRenderer gloomper;
    private final ModelRenderer body;
    private final ModelRenderer head;
    private final ModelRenderer jaw;
    private final ModelRenderer arms;
    private final ModelRenderer left;
    private final ModelRenderer right;
    private final ModelRenderer feet;
    private float jumpRotation;

    public GloomperModel() {
        this.field_78090_t = 64;
        this.field_78089_u = 64;
        this.gloomper = new ModelRenderer((Model)this);
        this.gloomper.func_78793_a(0.0f, 24.0f, 0.0f);
        this.body = new ModelRenderer((Model)this);
        this.body.func_78793_a(0.0f, -10.0f, 3.0f);
        this.gloomper.func_78792_a(this.body);
        this.setRotationAngle(this.body, -0.3491f, 0.0f, 0.0f);
        this.body.func_78784_a(0, 0).func_228303_a_(-8.0f, -5.0f, -8.0f, 16.0f, 13.0f, 16.0f, 0.0f, false);
        this.head = new ModelRenderer((Model)this);
        this.head.func_78793_a(0.0f, -10.5f, -5.0f);
        this.gloomper.func_78792_a(this.head);
        this.head.func_78784_a(0, 31).func_228303_a_(-5.0f, -4.5f, -2.0f, 10.0f, 8.0f, 4.0f, 0.0f, false);
        this.jaw = new ModelRenderer((Model)this);
        this.jaw.func_78793_a(0.0f, 3.5f, -2.0f);
        this.head.func_78792_a(this.jaw);
        this.jaw.func_78784_a(0, 43).func_228303_a_(-5.0f, -4.0f, -1.0f, 10.0f, 4.0f, 1.0f, 0.0f, false);
        this.arms = new ModelRenderer((Model)this);
        this.arms.func_78793_a(0.5f, -4.5f, -3.5f);
        this.gloomper.func_78792_a(this.arms);
        this.left = new ModelRenderer((Model)this);
        this.left.func_78793_a(6.0f, -0.5f, -1.0f);
        this.arms.func_78792_a(this.left);
        this.setRotationAngle(this.left, -0.5672f, -0.4363f, 0.0f);
        this.left.func_78784_a(22, 43).func_228303_a_(-1.5f, 0.0f, -1.5f, 3.0f, 6.0f, 3.0f, 0.0f, true);
        this.right = new ModelRenderer((Model)this);
        this.right.func_78793_a(-7.0f, -0.5f, -1.0f);
        this.arms.func_78792_a(this.right);
        this.setRotationAngle(this.right, -0.5672f, 0.4363f, 0.0f);
        this.right.func_78784_a(22, 43).func_228303_a_(-1.5f, 0.0f, -1.5f, 3.0f, 6.0f, 3.0f, 0.0f, false);
        this.feet = new ModelRenderer((Model)this);
        this.feet.func_78793_a(0.0f, -2.0f, 8.0f);
        this.gloomper.func_78792_a(this.feet);
        this.feet.func_78784_a(28, 32).func_228303_a_(7.0f, 0.0f, -7.0f, 4.0f, 2.0f, 7.0f, 0.0f, true);
        this.feet.func_78784_a(28, 32).func_228303_a_(-11.0f, 0.0f, -7.0f, 4.0f, 2.0f, 7.0f, 0.0f, false);
        this.feet.func_78784_a(0, 56).func_228303_a_(-11.0f, -5.0f, -3.0f, 4.0f, 5.0f, 3.0f, 0.0f, false);
        this.feet.func_78784_a(0, 56).func_228303_a_(7.0f, -5.0f, -3.0f, 4.0f, 5.0f, 3.0f, 0.0f, true);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float age = ageInTicks - (float)((GloomperEntity)((Object)entity)).field_70173_aa;
        this.jumpRotation = MathHelper.func_76126_a((float)(((GloomperEntity)((Object)entity)).getJumpCompletion(age) * (float)Math.PI));
        this.arms.field_78795_f = (this.jumpRotation * -40.0f - 11.0f) * ((float)Math.PI / 180);
        this.feet.field_78795_f = this.jumpRotation * 50.0f * ((float)Math.PI / 180);
    }

    public void prepareMobModel(T entityIn, float limbSwing, float limbSwingAmount, float partialTick) {
        super.func_212843_a_(entityIn, limbSwing, limbSwingAmount, partialTick);
        this.jumpRotation = MathHelper.func_76126_a((float)(((GloomperEntity)((Object)entityIn)).getJumpCompletion(partialTick) * (float)Math.PI));
    }

    protected Iterable<ModelRenderer> func_225602_a_() {
        return ImmutableSet.of();
    }

    protected Iterable<ModelRenderer> func_225600_b_() {
        return ImmutableSet.of((Object)this.gloomper);
    }

    public void setRotationAngle(ModelRenderer modelRenderer, float x, float y, float z) {
        modelRenderer.field_78795_f = x;
        modelRenderer.field_78796_g = y;
        modelRenderer.field_78808_h = z;
    }
}

