/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.client.model;

import com.google.common.collect.ImmutableSet;
import net.minecraft.client.renderer.entity.model.SegmentedModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import quek.undergarden.entity.rotspawn.RotwalkerEntity;

@OnlyIn(value=Dist.CLIENT)
public class RotwalkerModel<T extends RotwalkerEntity>
extends SegmentedModel<T> {
    private final ModelRenderer head;
    private final ModelRenderer torso;
    private final ModelRenderer leftArm;
    private final ModelRenderer rightArm;
    private final ModelRenderer leftLeg;
    private final ModelRenderer rightLeg;

    public RotwalkerModel() {
        this.field_78090_t = 64;
        this.field_78089_u = 64;
        this.head = new ModelRenderer((Model)this);
        this.head.func_78793_a(0.0f, -8.0f, -1.0f);
        this.setRotationAngle(this.head, 0.1309f, 0.0f, 0.0f);
        this.head.func_78784_a(0, 0).func_228303_a_(-4.0f, -8.0f, -6.0f, 8.0f, 8.0f, 8.0f, 0.0f, false);
        this.torso = new ModelRenderer((Model)this);
        this.torso.func_78793_a(0.0f, 1.0f, -1.0f);
        this.setRotationAngle(this.torso, 0.1745f, 0.0f, 0.0f);
        this.torso.func_78784_a(0, 16).func_228303_a_(-5.0f, -9.0f, -2.0f, 10.0f, 8.0f, 5.0f, 0.0f, false);
        this.torso.func_78784_a(0, 29).func_228303_a_(-4.0f, -1.0f, -1.0f, 8.0f, 9.0f, 3.0f, 0.0f, false);
        this.leftArm = new ModelRenderer((Model)this);
        this.leftArm.func_78793_a(5.0f, -6.0f, -2.0f);
        this.leftArm.func_78784_a(32, 0).func_228303_a_(0.0f, -1.0f, -1.0f, 2.0f, 16.0f, 3.0f, 0.0f, true);
        this.rightArm = new ModelRenderer((Model)this);
        this.rightArm.func_78793_a(-5.0f, -6.0f, -2.0f);
        this.rightArm.func_78784_a(32, 0).func_228303_a_(-2.0f, -1.0f, -1.0f, 2.0f, 16.0f, 3.0f, 0.0f, false);
        this.leftLeg = new ModelRenderer((Model)this);
        this.leftLeg.func_78793_a(-2.0f, 8.0f, 1.0f);
        this.leftLeg.func_78784_a(32, 0).func_228303_a_(-2.1f, 0.0f, -2.0f, 2.0f, 16.0f, 3.0f, 0.0f, false);
        this.rightLeg = new ModelRenderer((Model)this);
        this.rightLeg.func_78793_a(2.0f, 8.0f, 1.0f);
        this.rightLeg.func_78784_a(32, 0).func_228303_a_(0.1f, 0.0f, -2.0f, 2.0f, 16.0f, 3.0f, 0.0f, true);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.field_78796_g = netHeadYaw * ((float)Math.PI / 180);
        this.head.field_78795_f = 0.1309f + headPitch * ((float)Math.PI / 180);
        this.leftArm.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.rightArm.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.leftLeg.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.rightLeg.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
    }

    public Iterable<ModelRenderer> func_225601_a_() {
        return ImmutableSet.of((Object)this.head, (Object)this.torso, (Object)this.leftArm, (Object)this.rightArm, (Object)this.leftLeg, (Object)this.rightLeg, (Object[])new ModelRenderer[0]);
    }

    public void setRotationAngle(ModelRenderer modelRenderer, float x, float y, float z) {
        modelRenderer.field_78795_f = x;
        modelRenderer.field_78796_g = y;
        modelRenderer.field_78808_h = z;
    }
}

