/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.client.model;

import com.google.common.collect.ImmutableList;
import net.minecraft.client.renderer.entity.model.AgeableModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import quek.undergarden.entity.ScintlingEntity;

@OnlyIn(value=Dist.CLIENT)
public class ScintlingModel<T extends ScintlingEntity>
extends AgeableModel<T> {
    private final ModelRenderer scintling;
    private final ModelRenderer head;
    private final ModelRenderer leftStalk;
    private final ModelRenderer rightStalk;
    private final ModelRenderer torso;
    private final ModelRenderer tail;

    public ScintlingModel() {
        this.field_78090_t = 64;
        this.field_78089_u = 64;
        this.scintling = new ModelRenderer((Model)this);
        this.scintling.func_78793_a(0.0f, 24.0f, 0.0f);
        this.head = new ModelRenderer((Model)this);
        this.head.func_78793_a(0.0f, -2.0f, -7.0f);
        this.scintling.func_78792_a(this.head);
        this.head.func_78784_a(26, 18).func_228303_a_(-3.0f, -2.0f, -6.0f, 6.0f, 4.0f, 6.0f, 0.0f, false);
        this.leftStalk = new ModelRenderer((Model)this);
        this.leftStalk.func_78793_a(2.0f, -2.0f, -5.0f);
        this.head.func_78792_a(this.leftStalk);
        this.setRotationAngle(this.leftStalk, 0.3491f, 0.0f, 0.1745f);
        this.leftStalk.func_78784_a(20, 28).func_228303_a_(0.0f, -7.0f, -1.0f, 1.0f, 7.0f, 1.0f, 0.0f, false);
        this.rightStalk = new ModelRenderer((Model)this);
        this.rightStalk.func_78793_a(-2.0f, -2.0f, -5.0f);
        this.head.func_78792_a(this.rightStalk);
        this.setRotationAngle(this.rightStalk, 0.3491f, 0.0f, -0.1745f);
        this.rightStalk.func_78784_a(20, 28).func_228303_a_(-1.0f, -7.0f, -1.0f, 1.0f, 7.0f, 1.0f, 0.0f, true);
        this.torso = new ModelRenderer((Model)this);
        this.torso.func_78793_a(0.0f, 0.0f, 0.0f);
        this.scintling.func_78792_a(this.torso);
        this.torso.func_78784_a(0, 0).func_228303_a_(-4.0f, -5.0f, -7.0f, 8.0f, 5.0f, 13.0f, 0.0f, false);
        this.tail = new ModelRenderer((Model)this);
        this.tail.func_78793_a(0.0f, -2.0f, 6.0f);
        this.scintling.func_78792_a(this.tail);
        this.tail.func_78784_a(0, 18).func_228303_a_(-4.0f, -2.0f, 0.0f, 8.0f, 4.0f, 5.0f, 0.0f, false);
        this.tail.func_78784_a(0, 28).func_228303_a_(-3.0f, -1.0f, 5.0f, 6.0f, 3.0f, 4.0f, 0.0f, false);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float wiggle;
        this.head.field_78796_g = netHeadYaw * ((float)Math.PI / 180);
        this.head.field_78795_f = headPitch * ((float)Math.PI / 180);
        this.torso.field_78796_g = MathHelper.func_76134_b((float)(limbSwing * 0.5f + (float)Math.PI)) * 0.5f * limbSwingAmount;
        this.tail.field_78796_g = MathHelper.func_76134_b((float)(limbSwing * 0.5f)) * 0.5f * limbSwingAmount;
        this.leftStalk.field_78795_f = wiggle = MathHelper.func_76126_a((float)((float)((ScintlingEntity)((Object)entity)).field_70173_aa * 0.3f)) * 0.3f;
        this.rightStalk.field_78795_f = -wiggle;
    }

    protected Iterable<ModelRenderer> func_225602_a_() {
        return ImmutableList.of();
    }

    protected Iterable<ModelRenderer> func_225600_b_() {
        return ImmutableList.of((Object)this.scintling);
    }

    public void setRotationAngle(ModelRenderer modelRenderer, float x, float y, float z) {
        modelRenderer.field_78795_f = x;
        modelRenderer.field_78796_g = y;
        modelRenderer.field_78808_h = z;
    }
}

