/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.entity;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.AreaEffectCloudEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.JumpController;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.particles.IParticleData;
import net.minecraft.pathfinding.Path;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import quek.undergarden.entity.rotspawn.AbstractRotspawnEntity;
import quek.undergarden.registry.UGBlocks;
import quek.undergarden.registry.UGEntityTypes;
import quek.undergarden.registry.UGItems;
import quek.undergarden.registry.UGParticleTypes;
import quek.undergarden.registry.UGSoundEvents;

public class GloomperEntity
extends AnimalEntity {
    private int jumpTicks;
    private int jumpDuration;
    private boolean wasOnGround;
    private int currentMoveTypeDuration;

    public GloomperEntity(EntityType<? extends AnimalEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70767_i = new JumpHelperController(this);
        this.field_70765_h = new MoveHelperController(this);
        this.setMovementSpeed(0.0);
        this.field_70138_W = 1.0f;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new PanicGoal((CreatureEntity)this, 2.5));
        this.field_70714_bg.func_75776_a(2, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(2, (Goal)new AvoidEntityGoal((CreatureEntity)this, AbstractRotspawnEntity.class, 12.0f, 2.0, 2.5));
        this.field_70714_bg.func_75776_a(3, (Goal)new TemptGoal((CreatureEntity)this, 1.25, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)UGBlocks.GLOOMGOURD.get()}), false));
        this.field_70714_bg.func_75776_a(4, (Goal)new FollowParentGoal((AnimalEntity)this, 1.25));
        this.field_70714_bg.func_75776_a(4, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return AnimalEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 20.0).func_233815_a_(Attributes.field_233821_d_, 0.3);
    }

    public static boolean canGloomperSpawn(EntityType<? extends AnimalEntity> animal, IWorld worldIn, SpawnReason reason, BlockPos pos, Random random) {
        return worldIn.func_180495_p(pos.func_177977_b()).func_203425_a((Block)UGBlocks.DEEPTURF_BLOCK.get());
    }

    protected SoundEvent func_184639_G() {
        return (SoundEvent)UGSoundEvents.GLOOMPER_LIVING.get();
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return (SoundEvent)UGSoundEvents.GLOOMPER_HURT.get();
    }

    protected SoundEvent func_184615_bR() {
        return (SoundEvent)UGSoundEvents.GLOOMPER_DEATH.get();
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld serverWorld, AgeableEntity ageableEntity) {
        return (AgeableEntity)((EntityType)UGEntityTypes.GLOOMPER.get()).func_200721_a(this.field_70170_p);
    }

    public boolean func_70648_aU() {
        return true;
    }

    public boolean func_70877_b(ItemStack stack) {
        return Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)UGBlocks.GLOOMGOURD.get()}).test(stack);
    }

    protected float func_175134_bD() {
        if (!(this.field_70123_F || this.field_70765_h.func_75640_a() && this.field_70765_h.func_179919_e() > this.func_226278_cu_() + 0.5)) {
            Path path = this.field_70699_by.func_75505_d();
            if (path != null && !path.func_75879_b()) {
                Vector3d vector3d = path.func_75878_a((Entity)this);
                if (vector3d.field_72448_b > this.func_226278_cu_() + 0.5) {
                    return 0.5f;
                }
            }
            return this.field_70765_h.func_75638_b() <= 0.6 ? 0.2f : 0.3f;
        }
        return 0.5f;
    }

    protected void func_70664_aZ() {
        double d1;
        super.func_70664_aZ();
        double d0 = this.field_70765_h.func_75638_b();
        if (d0 > 0.0 && (d1 = GloomperEntity.func_213296_b((Vector3d)this.func_213322_ci())) < 0.01) {
            this.func_213309_a(0.1f, new Vector3d(0.0, 0.0, 1.0));
        }
        if (!this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)1);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getJumpCompletion(float delta) {
        return this.jumpDuration == 0 ? 0.0f : ((float)this.jumpTicks + delta) / (float)this.jumpDuration;
    }

    public void setMovementSpeed(double newSpeed) {
        this.func_70661_as().func_75489_a(newSpeed);
        this.field_70765_h.func_75642_a(this.field_70765_h.func_179917_d(), this.field_70765_h.func_179919_e(), this.field_70765_h.func_179918_f(), newSpeed);
    }

    public void func_70637_d(boolean jumping) {
        super.func_70637_d(jumping);
        if (jumping) {
            this.func_184185_a((SoundEvent)UGSoundEvents.GLOOMPER_HOP.get(), this.func_70599_aP(), ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f) * 0.8f);
        }
    }

    public void startJumping() {
        this.func_70637_d(true);
        this.jumpDuration = 10;
        this.jumpTicks = 0;
    }

    public void func_70619_bc() {
        if (this.currentMoveTypeDuration > 0) {
            --this.currentMoveTypeDuration;
        }
        if (this.field_70122_E) {
            JumpHelperController jumpController;
            if (!this.wasOnGround) {
                this.func_70637_d(false);
                this.checkLandingDelay();
            }
            if (!(jumpController = (JumpHelperController)this.field_70767_i).getIsJumping()) {
                if (this.field_70765_h.func_75640_a() && this.currentMoveTypeDuration == 0) {
                    Path path = this.field_70699_by.func_75505_d();
                    Vector3d vector3d = new Vector3d(this.field_70765_h.func_179917_d(), this.field_70765_h.func_179919_e(), this.field_70765_h.func_179918_f());
                    if (path != null && !path.func_75879_b()) {
                        vector3d = path.func_75878_a((Entity)this);
                    }
                    this.calculateRotationYaw(vector3d.field_72450_a, vector3d.field_72449_c);
                    this.startJumping();
                }
            } else if (!jumpController.canJump()) {
                this.enableJumpControl();
            }
        }
        this.wasOnGround = this.field_70122_E;
    }

    public boolean func_230269_aK_() {
        return false;
    }

    private void calculateRotationYaw(double x, double z) {
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)(z - this.func_226281_cx_()), (double)(x - this.func_226277_ct_())) * 57.2957763671875) - 90.0f;
    }

    private void enableJumpControl() {
        ((JumpHelperController)this.field_70767_i).setCanJump(true);
    }

    private void disableJumpControl() {
        ((JumpHelperController)this.field_70767_i).setCanJump(false);
    }

    private void updateMoveTypeDuration() {
        this.currentMoveTypeDuration = this.field_70765_h.func_75638_b() < 2.2 ? 10 : 1;
    }

    private void checkLandingDelay() {
        this.updateMoveTypeDuration();
        this.disableJumpControl();
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.jumpTicks != this.jumpDuration) {
            ++this.jumpTicks;
        } else if (this.jumpDuration != 0) {
            this.jumpTicks = 0;
            this.jumpDuration = 0;
            this.func_70637_d(false);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 1) {
            this.func_233569_aL_();
            this.jumpDuration = 10;
            this.jumpTicks = 0;
        } else {
            super.func_70103_a(id);
        }
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77973_b() == UGItems.GLOOMPER_ANTHEM_DISC.get() && this.func_70089_S()) {
            if (!this.field_70170_p.field_72995_K) {
                this.func_199703_a((IItemProvider)UGItems.GLOOMPER_SECRET_DISC.get());
                this.func_174812_G();
            }
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        return super.func_230254_b_(player, hand);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        AreaEffectCloudEntity cloud = new AreaEffectCloudEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        cloud.func_195059_a((IParticleData)UGParticleTypes.GLOOMPER_FART.get());
        cloud.func_184483_a(3.0f);
        cloud.func_184495_b(-0.5f);
        cloud.func_184485_d(10);
        cloud.func_184487_c(-cloud.func_184490_j() / (float)cloud.func_184489_o());
        cloud.func_184496_a(new EffectInstance(Effects.field_76436_u, 100, 0));
        if (this.field_70146_Z.nextInt(2) == 0) {
            this.func_184185_a((SoundEvent)UGSoundEvents.GLOOMPER_FART.get(), 1.0f, 1.0f);
            this.field_70170_p.func_217376_c((Entity)cloud);
        }
        return super.func_70097_a(source, amount);
    }

    public boolean func_70687_e(EffectInstance effectInstance) {
        Effect effect = effectInstance.func_188419_a();
        if (effect == Effects.field_76436_u) {
            return false;
        }
        return super.func_70687_e(effectInstance);
    }

    static class MoveHelperController
    extends MovementController {
        private final GloomperEntity gloomper;
        private double nextJumpSpeed;

        public MoveHelperController(GloomperEntity gloomper) {
            super((MobEntity)gloomper);
            this.gloomper = gloomper;
        }

        public void func_75641_c() {
            if (this.gloomper.field_70122_E && !this.gloomper.field_70703_bu && !((JumpHelperController)this.gloomper.field_70767_i).getIsJumping()) {
                this.gloomper.setMovementSpeed(0.0);
            } else if (this.func_75640_a()) {
                this.gloomper.setMovementSpeed(this.nextJumpSpeed);
            }
            super.func_75641_c();
        }

        public void func_75642_a(double x, double y, double z, double speedIn) {
            if (this.gloomper.func_70090_H()) {
                speedIn = 1.5;
            }
            super.func_75642_a(x, y, z, speedIn);
            if (speedIn > 0.0) {
                this.nextJumpSpeed = speedIn;
            }
        }
    }

    public static class JumpHelperController
    extends JumpController {
        private final GloomperEntity gloomper;
        private boolean canJump;

        public JumpHelperController(GloomperEntity gloomper) {
            super((MobEntity)gloomper);
            this.gloomper = gloomper;
        }

        public boolean getIsJumping() {
            return this.field_75662_b;
        }

        public boolean canJump() {
            return this.canJump;
        }

        public void setCanJump(boolean canJumpIn) {
            this.canJump = canJumpIn;
        }

        public void func_75661_b() {
            if (this.field_75662_b) {
                this.gloomper.startJumping();
                this.field_75662_b = false;
            }
        }
    }
}

