/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.entity.boss;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.Difficulty;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import quek.undergarden.registry.UGSoundEvents;

public class ForgottenGuardianEntity
extends MonsterEntity {
    private int attackTimer;

    public ForgottenGuardianEntity(EntityType<? extends MonsterEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70138_W = 1.0f;
        this.field_70728_aV = 30;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, false));
        this.field_70714_bg.func_75776_a(2, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(0, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, false));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MonsterEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 80.0).func_233815_a_(Attributes.field_233826_i_, 20.0).func_233815_a_(Attributes.field_233827_j_, 5.0).func_233815_a_(Attributes.field_233823_f_, 20.0).func_233815_a_(Attributes.field_233821_d_, 0.2).func_233815_a_(Attributes.field_233820_c_, 1.0).func_233815_a_(Attributes.field_233819_b_, 64.0);
    }

    protected SoundEvent func_184639_G() {
        return (SoundEvent)UGSoundEvents.FORGOTTEN_GUARDIAN_LIVING.get();
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return (SoundEvent)UGSoundEvents.FORGOTTEN_GUARDIAN_HURT.get();
    }

    protected SoundEvent func_184615_bR() {
        return (SoundEvent)UGSoundEvents.FORGOTTEN_GUARDIAN_DEATH.get();
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a((SoundEvent)UGSoundEvents.FORGOTTEN_GUARDIAN_STEP.get(), 0.5f, 1.0f);
    }

    public boolean func_184222_aU() {
        return false;
    }

    public void func_70623_bb() {
        if (this.field_70170_p.func_175659_aa() == Difficulty.PEACEFUL && this.func_225511_J_()) {
            this.func_70106_y();
        } else {
            this.field_70708_bq = 0;
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.attackTimer > 0) {
            --this.attackTimer;
        }
        if (this.field_70123_F && ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this)) {
            AxisAlignedBB axisalignedbb = this.func_174813_aQ().func_72314_b(0.2, 0.0, 0.2);
            for (BlockPos blockpos : BlockPos.func_191531_b((int)MathHelper.func_76128_c((double)axisalignedbb.field_72340_a), (int)MathHelper.func_76128_c((double)axisalignedbb.field_72338_b), (int)MathHelper.func_76128_c((double)axisalignedbb.field_72339_c), (int)MathHelper.func_76128_c((double)axisalignedbb.field_72336_d), (int)MathHelper.func_76128_c((double)axisalignedbb.field_72337_e), (int)MathHelper.func_76128_c((double)axisalignedbb.field_72334_f))) {
                BlockState blockstate = this.field_70170_p.func_180495_p(blockpos);
                Block block = blockstate.func_177230_c();
                if (block.func_203417_a((ITag)BlockTags.field_219755_X)) continue;
                this.field_70170_p.func_225521_a_(blockpos, false, (Entity)this);
            }
        }
    }

    public boolean func_70652_k(Entity entityIn) {
        this.attackTimer = 10;
        this.field_70170_p.func_72960_a((Entity)this, (byte)4);
        float damage = (float)this.func_233637_b_(Attributes.field_233823_f_);
        float f1 = (int)damage > 0 ? damage / 2.0f + (float)this.field_70146_Z.nextInt((int)damage) : damage;
        boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), f1);
        if (flag) {
            double x = entityIn.func_226277_ct_() - this.func_226277_ct_();
            double z = entityIn.func_226281_cx_() - this.func_226281_cx_();
            double modifier = Math.max(x * x + z * z, 0.001);
            entityIn.func_213317_d(entityIn.func_213322_ci().func_72441_c(x / modifier * 2.0, (double)0.2f, z / modifier * 2.0));
            this.func_174815_a((LivingEntity)this, entityIn);
        }
        this.func_184185_a((SoundEvent)UGSoundEvents.FORGOTTEN_GUARDIAN_ATTACK.get(), 1.0f, 1.0f);
        return flag;
    }

    protected void func_213371_e(LivingEntity entityIn) {
        double x = entityIn.func_226277_ct_() - this.func_226277_ct_();
        double z = entityIn.func_226281_cx_() - this.func_226281_cx_();
        double modifier = Math.max(x * x + z * z, 0.001);
        entityIn.func_70024_g(x / modifier * 2.0, (double)0.2f, z / modifier * 2.0);
        entityIn.field_70133_I = true;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        Entity entity = source.func_76364_f();
        if (entity instanceof ProjectileEntity) {
            this.func_184185_a((SoundEvent)UGSoundEvents.FORGOTTEN_GUARDIAN_DEFLECT.get(), 1.0f, 1.0f);
            return false;
        }
        return super.func_70097_a(source, amount);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 4) {
            this.attackTimer = 10;
            this.func_184185_a((SoundEvent)UGSoundEvents.FORGOTTEN_GUARDIAN_ATTACK.get(), 1.0f, 1.0f);
        } else {
            super.func_70103_a(id);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getAttackTimer() {
        return this.attackTimer;
    }

    public boolean func_70648_aU() {
        return true;
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    protected void func_184231_a(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public boolean func_195064_c(EffectInstance effectInstanceIn) {
        return false;
    }

    public boolean func_96092_aw() {
        return false;
    }

    public boolean func_184652_a(PlayerEntity player) {
        return false;
    }
}

