/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.registry;

import com.google.common.collect.ImmutableSet;
import com.mojang.serialization.Codec;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.StemGrownBlock;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.state.Property;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.gen.blockplacer.BlockPlacer;
import net.minecraft.world.gen.blockplacer.DoublePlantBlockPlacer;
import net.minecraft.world.gen.blockplacer.SimpleBlockPlacer;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.feature.AbstractFeatureSizeType;
import net.minecraft.world.gen.feature.BasaltDeltasFeature;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.BigMushroomFeatureConfig;
import net.minecraft.world.gen.feature.BlockClusterFeatureConfig;
import net.minecraft.world.gen.feature.BlockStateFeatureConfig;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.FeatureSpread;
import net.minecraft.world.gen.feature.FeatureSpreadConfig;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.LiquidsConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.feature.TwoLayerFeature;
import net.minecraft.world.gen.feature.template.RuleTest;
import net.minecraft.world.gen.feature.template.TagMatchRuleTest;
import net.minecraft.world.gen.foliageplacer.BlobFoliagePlacer;
import net.minecraft.world.gen.foliageplacer.BushFoliagePlacer;
import net.minecraft.world.gen.foliageplacer.FoliagePlacer;
import net.minecraft.world.gen.placement.ChanceConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.placement.TopSolidRangeConfig;
import net.minecraft.world.gen.trunkplacer.AbstractTrunkPlacer;
import net.minecraft.world.gen.trunkplacer.ForkyTrunkPlacer;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import quek.undergarden.block.BlisterberryBushBlock;
import quek.undergarden.block.DitchbulbBlock;
import quek.undergarden.block.UnderbeanBushBlock;
import quek.undergarden.registry.UGBlocks;
import quek.undergarden.registry.UGFluids;
import quek.undergarden.registry.UGTags;
import quek.undergarden.world.gen.feature.BigBloodMushroomFeature;
import quek.undergarden.world.gen.feature.BigIndigoMushroomFeature;
import quek.undergarden.world.gen.feature.BigInkMushroomFeature;
import quek.undergarden.world.gen.feature.BigVeilMushroomFeature;
import quek.undergarden.world.gen.feature.DroopvineFeature;
import quek.undergarden.world.gen.feature.GlowingKelpFeature;
import quek.undergarden.world.gen.feature.IcePillarFeature;
import quek.undergarden.world.gen.feature.SmogVentFeature;
import quek.undergarden.world.gen.feature.UGTreeFeature;
import quek.undergarden.world.gen.trunkplacer.SmogstemTrunkPlacer;

public class UGFeatures {
    public static final DeferredRegister<Feature<?>> FEATURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"undergarden");
    public static final RegistryObject<Feature<BaseTreeFeatureConfig>> UNDERGARDEN_TREE = FEATURES.register("undergarden_tree", () -> new UGTreeFeature((Codec<BaseTreeFeatureConfig>)BaseTreeFeatureConfig.field_236676_a_));
    public static final RegistryObject<Feature<BigMushroomFeatureConfig>> BLOOD_MUSHROOM = FEATURES.register("blood_mushroom", () -> new BigBloodMushroomFeature((Codec<BigMushroomFeatureConfig>)BigMushroomFeatureConfig.field_236528_a_));
    public static final RegistryObject<Feature<BigMushroomFeatureConfig>> INDIGO_MUSHROOM = FEATURES.register("indigo_mushroom", () -> new BigIndigoMushroomFeature((Codec<BigMushroomFeatureConfig>)BigMushroomFeatureConfig.field_236528_a_));
    public static final RegistryObject<Feature<BigMushroomFeatureConfig>> INK_MUSHROOM = FEATURES.register("ink_mushroom", () -> new BigInkMushroomFeature((Codec<BigMushroomFeatureConfig>)BigMushroomFeatureConfig.field_236528_a_));
    public static final RegistryObject<Feature<BigMushroomFeatureConfig>> VEIL_MUSHROOM = FEATURES.register("veil_mushroom", () -> new BigVeilMushroomFeature((Codec<BigMushroomFeatureConfig>)BigMushroomFeatureConfig.field_236528_a_));
    public static final RegistryObject<Feature<NoFeatureConfig>> GLOWING_KELP = FEATURES.register("glowing_kelp", () -> new GlowingKelpFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<Feature<NoFeatureConfig>> SMOG_VENT = FEATURES.register("smog_vent", () -> new SmogVentFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<Feature<NoFeatureConfig>> DROOPVINE = FEATURES.register("droopvine", () -> new DroopvineFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<Feature<NoFeatureConfig>> ICE_PILLAR = FEATURES.register("ice_pillar", () -> new IcePillarFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));

    public static void registerConfiguredFeatures() {
        UGFeatures.register("spring", (ConfiguredFeature)((ConfiguredFeature)ConfiguredFeatures.SPRING.func_227228_a_(Placement.field_242908_m.func_227446_a_((IPlacementConfig)new TopSolidRangeConfig(8, 8, 256))).func_242728_a()).func_242731_b(50));
        UGFeatures.register("virulent_spring", (ConfiguredFeature)((ConfiguredFeature)ConfiguredFeatures.VIRULENT_SPRING.func_227228_a_(Placement.field_242908_m.func_227446_a_((IPlacementConfig)new TopSolidRangeConfig(8, 8, 256))).func_242728_a()).func_242731_b(50));
        UGFeatures.register("bog_virulent_spring", (ConfiguredFeature)((ConfiguredFeature)ConfiguredFeatures.VIRULENT_SPRING.func_227228_a_(Placement.field_242908_m.func_227446_a_((IPlacementConfig)new TopSolidRangeConfig(8, 8, 256))).func_242728_a()).func_242731_b(100));
        UGFeatures.register("lake_virulent", ConfiguredFeatures.VIRULENT_LAKE.func_227228_a_(Placement.field_215006_E.func_227446_a_((IPlacementConfig)new ChanceConfig(8))));
        UGFeatures.register("bog_lake_virulent", ConfiguredFeatures.VIRULENT_LAKE.func_227228_a_(Placement.field_215006_E.func_227446_a_((IPlacementConfig)new ChanceConfig(2))));
        UGFeatures.register("bog_pond", ConfiguredFeatures.BOG_PONDS.func_227228_a_(Placement.field_242897_C.func_227446_a_((IPlacementConfig)new FeatureSpreadConfig(40))));
        UGFeatures.register("lilypads", (ConfiguredFeature)((ConfiguredFeature)ConfiguredFeatures.LILYPADS.func_242733_d(256)).func_242731_b(5));
        UGFeatures.register("deepturf_patch", (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)ConfiguredFeatures.DEEPTURF_PATCH.func_242733_d(256)).func_242728_a()).func_242731_b(100));
        UGFeatures.register("ashen_patch", (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)ConfiguredFeatures.ASHEN_DEEPTURF_PATCH.func_242733_d(256)).func_242728_a()).func_242731_b(100));
        UGFeatures.register("frozen_patch", (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)ConfiguredFeatures.FROZEN_DEEPTURF_PATCH.func_242733_d(256)).func_242728_a()).func_242731_b(100));
        UGFeatures.register("shimmerweed_patch", (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)ConfiguredFeatures.SHIMMERWEED_PATCH.func_242733_d(256)).func_242728_a()).func_242731_b(75));
        UGFeatures.register("pebble_patch", (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)ConfiguredFeatures.PEBBLE_PATCH.func_242733_d(256)).func_242728_a()).func_242731_b(75));
        UGFeatures.register("ditchbulb_patch", (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)ConfiguredFeatures.DITCHBULB_PATCH.func_242733_d(256)).func_242728_a()).func_242731_b(50));
        UGFeatures.register("tall_deepturf_patch", (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)ConfiguredFeatures.TALL_DEEPTURF_PATCH.func_242733_d(256)).func_242728_a()).func_242731_b(100));
        UGFeatures.register("tall_shimmerweed_patch", (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)ConfiguredFeatures.TALL_SHIMMERWEED_PATCH.func_242733_d(256)).func_242728_a()).func_242731_b(50));
        UGFeatures.register("indigo_patch", (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)ConfiguredFeatures.INDIGO_MUSHROOM_PATCH.func_242733_d(256)).func_242728_a()).func_242731_b(1));
        UGFeatures.register("veil_patch", (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)ConfiguredFeatures.VEIL_MUSHROOM_PATCH.func_242733_d(256)).func_242728_a()).func_242731_b(1));
        UGFeatures.register("ink_patch", (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)ConfiguredFeatures.INK_MUSHROOM_PATCH.func_242733_d(256)).func_242728_a()).func_242731_b(1));
        UGFeatures.register("blood_patch", (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)ConfiguredFeatures.BLOOD_MUSHROOM_PATCH.func_242733_d(256)).func_242728_a()).func_242731_b(1));
        UGFeatures.register("gronglet_patch", (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)ConfiguredFeatures.GRONGLET_PATCH.func_242733_d(256)).func_242728_a()).func_242731_b(100));
        UGFeatures.register("bog_indigo_patch", (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)ConfiguredFeatures.INDIGO_MUSHROOM_PATCH.func_242733_d(256)).func_242728_a()).func_242731_b(25));
        UGFeatures.register("bog_veil_patch", (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)ConfiguredFeatures.VEIL_MUSHROOM_PATCH.func_242733_d(256)).func_242728_a()).func_242731_b(25));
        UGFeatures.register("bog_ink_patch", (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)ConfiguredFeatures.INK_MUSHROOM_PATCH.func_242733_d(256)).func_242728_a()).func_242731_b(25));
        UGFeatures.register("bog_blood_patch", (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)ConfiguredFeatures.BLOOD_MUSHROOM_PATCH.func_242733_d(256)).func_242728_a()).func_242731_b(25));
        UGFeatures.register("underbean_patch", (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)ConfiguredFeatures.UNDERBEAN_BUSH_PATCH.func_242733_d(256)).func_242728_a()).func_242731_b(5));
        UGFeatures.register("blisterberry_patch", (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)ConfiguredFeatures.BLISTERBERRY_BUSH_PATCH.func_242733_d(256)).func_242728_a()).func_242731_b(5));
        UGFeatures.register("gloomgourd_patch", (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)ConfiguredFeatures.GLOOMGOURD_PATCH.func_242733_d(256)).func_242728_a()).func_242731_b(5));
        UGFeatures.register("coal_ore", (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)ConfiguredFeatures.COAL_ORE.func_242733_d(256)).func_242728_a()).func_242731_b(30));
        UGFeatures.register("iron_ore", (ConfiguredFeature)((ConfiguredFeature)ConfiguredFeatures.IRON_ORE.func_227228_a_(Placement.field_242907_l.func_227446_a_((IPlacementConfig)new TopSolidRangeConfig(200, 0, 16))).func_242728_a()).func_242731_b(10));
        UGFeatures.register("gold_ore", (ConfiguredFeature)((ConfiguredFeature)ConfiguredFeatures.GOLD_ORE.func_227228_a_(Placement.field_242907_l.func_227446_a_((IPlacementConfig)new TopSolidRangeConfig(220, 0, 16))).func_242728_a()).func_242731_b(3));
        UGFeatures.register("diamond_ore", (ConfiguredFeature)((ConfiguredFeature)ConfiguredFeatures.DIAMOND_ORE.func_227228_a_(Placement.field_242907_l.func_227446_a_((IPlacementConfig)new TopSolidRangeConfig(230, 0, 16))).func_242728_a()).func_242731_b(1));
        UGFeatures.register("cloggrum_ore", (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)ConfiguredFeatures.CLOGGRUM_ORE.func_242733_d(128)).func_242728_a()).func_242731_b(20));
        UGFeatures.register("froststeel_ore", (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)ConfiguredFeatures.FROSTSTEEL_ORE.func_242733_d(64)).func_242728_a()).func_242731_b(15));
        UGFeatures.register("utherium_ore", (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)ConfiguredFeatures.UTHERIUM_ORE.func_242733_d(32)).func_242728_a()).func_242731_b(5));
        UGFeatures.register("regalium_ore", (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)ConfiguredFeatures.REGALIUM_ORE.func_242733_d(12)).func_242728_a()).func_242731_b(3));
        UGFeatures.register("shiverstone_patch", (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)ConfiguredFeatures.SHIVERSTONE_PATCH.func_242733_d(256)).func_242728_a()).func_242731_b(10));
        UGFeatures.register("deepsoil_patch", (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)ConfiguredFeatures.DEEPSOIL_PATCH.func_242733_d(256)).func_242728_a()).func_242731_b(10));
        UGFeatures.register("ice_patch", (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)ConfiguredFeatures.ICE_PATCH.func_242733_d(256)).func_242728_a()).func_242731_b(20));
        UGFeatures.register("smogstem_tree", ConfiguredFeatures.SMOGSTEM_TREE.func_227228_a_(Placement.field_242897_C.func_227446_a_((IPlacementConfig)new FeatureSpreadConfig(8))));
        UGFeatures.register("wigglewood_tree", ConfiguredFeatures.WIGGLEWOOD_TREE.func_227228_a_(Placement.field_242897_C.func_227446_a_((IPlacementConfig)new FeatureSpreadConfig(8))));
        UGFeatures.register("smogstem_tree_tall", ConfiguredFeatures.SMOGSTEM_TREE_TALL.func_227228_a_(Placement.field_242897_C.func_227446_a_((IPlacementConfig)new FeatureSpreadConfig(8))));
        UGFeatures.register("wigglewood_tree_tall", ConfiguredFeatures.WIGGLEWOOD_TREE_TALL.func_227228_a_(Placement.field_242897_C.func_227446_a_((IPlacementConfig)new FeatureSpreadConfig(8))));
        UGFeatures.register("huge_blood_mushroom", ConfiguredFeatures.BLOOD_MUSHROOM.func_227228_a_(Placement.field_242897_C.func_227446_a_((IPlacementConfig)new FeatureSpreadConfig(2))));
        UGFeatures.register("huge_indigo_mushroom", ConfiguredFeatures.INDIGO_MUSHROOM.func_227228_a_(Placement.field_242897_C.func_227446_a_((IPlacementConfig)new FeatureSpreadConfig(2))));
        UGFeatures.register("huge_ink_mushroom", ConfiguredFeatures.INK_MUSHROOM.func_227228_a_(Placement.field_242897_C.func_227446_a_((IPlacementConfig)new FeatureSpreadConfig(2))));
        UGFeatures.register("huge_veil_mushroom", ConfiguredFeatures.VEIL_MUSHROOM.func_227228_a_(Placement.field_242897_C.func_227446_a_((IPlacementConfig)new FeatureSpreadConfig(2))));
        UGFeatures.register("depthrock_boulder", (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)ConfiguredFeatures.DEPTHROCK_BOULDER.func_242733_d(256)).func_242728_a()).func_242731_b(5));
        UGFeatures.register("shiverstone_boulder", (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)ConfiguredFeatures.SHIVERSTONE_BOULDER.func_242733_d(256)).func_242728_a()).func_242731_b(5));
        UGFeatures.register("glowing_kelp", (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)ConfiguredFeatures.GLOWING_KELP.func_242733_d(32)).func_242728_a()).func_242731_b(100));
        UGFeatures.register("smog_vent", ConfiguredFeatures.SMOG_VENT.func_227228_a_(Placement.field_242897_C.func_227446_a_((IPlacementConfig)new FeatureSpreadConfig(8))));
        UGFeatures.register("droopvine", (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)ConfiguredFeatures.DROOPVINE.func_242733_d(256)).func_242728_a()).func_242731_b(100));
        UGFeatures.register("ice_pillar", (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)ConfiguredFeatures.ICE_PILLAR.func_242733_d(256)).func_242728_a()).func_242731_b(50));
    }

    private static <FC extends IFeatureConfig> void register(String name, ConfiguredFeature<FC, ?> feature) {
        Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)new ResourceLocation("undergarden", name), feature);
    }

    public static final class ConfiguredFeatures {
        static final RuleTest UNDERGARDEN_FILLER = new TagMatchRuleTest(UGTags.Blocks.BASE_STONE_UNDERGARDEN);
        public static final ConfiguredFeature<?, ?> SPRING = Feature.field_202295_ao.func_225566_b_((IFeatureConfig)new LiquidsConfig(Fluids.field_204546_a.func_207188_f(), false, 4, 1, (Set)ImmutableSet.of((Object)UGBlocks.DEPTHROCK.get(), (Object)UGBlocks.DEEPSOIL.get(), (Object)UGBlocks.TREMBLECRUST.get())));
        public static final ConfiguredFeature<?, ?> VIRULENT_SPRING = Feature.field_202295_ao.func_225566_b_((IFeatureConfig)new LiquidsConfig(((FlowingFluid)UGFluids.VIRULENT_MIX_SOURCE.get()).func_207188_f(), false, 4, 1, (Set)ImmutableSet.of((Object)UGBlocks.DEPTHROCK.get(), (Object)UGBlocks.DEEPSOIL.get(), (Object)UGBlocks.TREMBLECRUST.get())));
        public static final ConfiguredFeature<?, ?> VIRULENT_LAKE = Feature.field_202289_ai.func_225566_b_((IFeatureConfig)new BlockStateFeatureConfig(((FlowingFluidBlock)UGBlocks.VIRULENT_MIX.get()).func_176223_P()));
        public static final ConfiguredFeature<?, ?> BOG_PONDS = Feature.field_236286_Q_.func_225566_b_((IFeatureConfig)new BasaltDeltasFeature(((FlowingFluidBlock)UGBlocks.VIRULENT_MIX.get()).func_176223_P(), ((Block)UGBlocks.COARSE_DEEPSOIL.get()).func_176223_P(), FeatureSpread.func_242253_a((int)6, (int)8), FeatureSpread.func_242253_a((int)0, (int)4)));
        public static final ConfiguredFeature<?, ?> LILYPADS = Feature.field_227248_z_.func_225566_b_((IFeatureConfig)new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(Blocks.field_196651_dG.func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(32).func_227320_c_().func_227317_b_().func_227322_d_());
        public static final ConfiguredFeature<?, ?> DEEPTURF_PATCH = Feature.field_227248_z_.func_225566_b_((IFeatureConfig)new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(((Block)UGBlocks.DEEPTURF.get()).func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(64).func_227316_a_((Set)ImmutableSet.of((Object)UGBlocks.DEEPTURF_BLOCK.get())).func_227317_b_().func_227322_d_());
        public static final ConfiguredFeature<?, ?> ASHEN_DEEPTURF_PATCH = Feature.field_227248_z_.func_225566_b_((IFeatureConfig)new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(((Block)UGBlocks.ASHEN_DEEPTURF.get()).func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(64).func_227316_a_((Set)ImmutableSet.of((Object)UGBlocks.ASHEN_DEEPTURF_BLOCK.get())).func_227317_b_().func_227322_d_());
        public static final ConfiguredFeature<?, ?> FROZEN_DEEPTURF_PATCH = Feature.field_227248_z_.func_225566_b_((IFeatureConfig)new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(((Block)UGBlocks.FROZEN_DEEPTURF.get()).func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(64).func_227316_a_((Set)ImmutableSet.of((Object)UGBlocks.FROZEN_DEEPTURF_BLOCK.get())).func_227317_b_().func_227322_d_());
        public static final ConfiguredFeature<?, ?> SHIMMERWEED_PATCH = Feature.field_227248_z_.func_225566_b_((IFeatureConfig)new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(((Block)UGBlocks.SHIMMERWEED.get()).func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(32).func_227316_a_((Set)ImmutableSet.of((Object)UGBlocks.DEEPTURF_BLOCK.get(), (Object)UGBlocks.FROZEN_DEEPTURF_BLOCK.get())).func_227317_b_().func_227322_d_());
        public static final ConfiguredFeature<?, ?> PEBBLE_PATCH = Feature.field_227248_z_.func_225566_b_((IFeatureConfig)new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(((Block)UGBlocks.DEPTHROCK_PEBBLES.get()).func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(32).func_227316_a_((Set)ImmutableSet.of((Object)UGBlocks.DEEPTURF_BLOCK.get(), (Object)UGBlocks.ASHEN_DEEPTURF_BLOCK.get(), (Object)UGBlocks.DEPTHROCK.get(), (Object)UGBlocks.SHIVERSTONE.get())).func_227317_b_().func_227322_d_());
        public static final ConfiguredFeature<?, ?> DITCHBULB_PATCH = Feature.field_227248_z_.func_225566_b_((IFeatureConfig)new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider((BlockState)((Block)UGBlocks.DITCHBULB_PLANT.get()).func_176223_P().func_206870_a((Property)DitchbulbBlock.AGE, (Comparable)Integer.valueOf(1))), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(16).func_227316_a_((Set)ImmutableSet.of((Object)UGBlocks.DEPTHROCK.get())).func_227317_b_().func_227322_d_());
        public static final ConfiguredFeature<?, ?> TALL_DEEPTURF_PATCH = Feature.field_227248_z_.func_225566_b_((IFeatureConfig)new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(((Block)UGBlocks.TALL_DEEPTURF.get()).func_176223_P()), (BlockPlacer)new DoublePlantBlockPlacer()).func_227315_a_(32).func_227316_a_((Set)ImmutableSet.of((Object)UGBlocks.DEEPTURF_BLOCK.get())).func_227317_b_().func_227322_d_());
        public static final ConfiguredFeature<?, ?> TALL_SHIMMERWEED_PATCH = Feature.field_227248_z_.func_225566_b_((IFeatureConfig)new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(((Block)UGBlocks.TALL_SHIMMERWEED.get()).func_176223_P()), (BlockPlacer)new DoublePlantBlockPlacer()).func_227315_a_(16).func_227316_a_((Set)ImmutableSet.of((Object)UGBlocks.DEEPTURF_BLOCK.get(), (Object)UGBlocks.FROZEN_DEEPTURF_BLOCK.get())).func_227317_b_().func_227322_d_());
        public static final ConfiguredFeature<?, ?> INDIGO_MUSHROOM_PATCH = Feature.field_227248_z_.func_225566_b_((IFeatureConfig)new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(((Block)UGBlocks.INDIGO_MUSHROOM.get()).func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(64).func_227317_b_().func_227322_d_());
        public static final ConfiguredFeature<?, ?> VEIL_MUSHROOM_PATCH = Feature.field_227248_z_.func_225566_b_((IFeatureConfig)new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(((Block)UGBlocks.VEIL_MUSHROOM.get()).func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(64).func_227317_b_().func_227322_d_());
        public static final ConfiguredFeature<?, ?> INK_MUSHROOM_PATCH = Feature.field_227248_z_.func_225566_b_((IFeatureConfig)new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(((Block)UGBlocks.INK_MUSHROOM.get()).func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(64).func_227317_b_().func_227322_d_());
        public static final ConfiguredFeature<?, ?> BLOOD_MUSHROOM_PATCH = Feature.field_227248_z_.func_225566_b_((IFeatureConfig)new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(((Block)UGBlocks.BLOOD_MUSHROOM.get()).func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(64).func_227317_b_().func_227322_d_());
        public static final ConfiguredFeature<?, ?> GRONGLET_PATCH = Feature.field_227248_z_.func_225566_b_((IFeatureConfig)new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(((Block)UGBlocks.GRONGLET.get()).func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(64).func_227317_b_().func_227322_d_());
        public static final ConfiguredFeature<?, ?> UNDERBEAN_BUSH_PATCH = Feature.field_227248_z_.func_225566_b_((IFeatureConfig)new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider((BlockState)((Block)UGBlocks.UNDERBEAN_BUSH.get()).func_176223_P().func_206870_a((Property)UnderbeanBushBlock.AGE, (Comparable)Integer.valueOf(3))), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(64).func_227316_a_((Set)ImmutableSet.of((Object)UGBlocks.DEEPTURF_BLOCK.get())).func_227317_b_().func_227322_d_());
        public static final ConfiguredFeature<?, ?> BLISTERBERRY_BUSH_PATCH = Feature.field_227248_z_.func_225566_b_((IFeatureConfig)new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider((BlockState)((Block)UGBlocks.BLISTERBERRY_BUSH.get()).func_176223_P().func_206870_a((Property)BlisterberryBushBlock.AGE, (Comparable)Integer.valueOf(3))), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(64).func_227316_a_((Set)ImmutableSet.of((Object)UGBlocks.ASHEN_DEEPTURF_BLOCK.get())).func_227317_b_().func_227322_d_());
        public static final ConfiguredFeature<?, ?> GLOOMGOURD_PATCH = Feature.field_227248_z_.func_225566_b_((IFeatureConfig)new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(((StemGrownBlock)UGBlocks.GLOOMGOURD.get()).func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(16).func_227316_a_((Set)ImmutableSet.of((Object)UGBlocks.DEEPTURF_BLOCK.get())).func_227317_b_().func_227322_d_());
        public static final ConfiguredFeature<?, ?> COAL_ORE = Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(UNDERGARDEN_FILLER, ((Block)UGBlocks.COAL_ORE.get()).func_176223_P(), 17));
        public static final ConfiguredFeature<?, ?> IRON_ORE = Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(UNDERGARDEN_FILLER, ((Block)UGBlocks.IRON_ORE.get()).func_176223_P(), 9));
        public static final ConfiguredFeature<?, ?> GOLD_ORE = Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(UNDERGARDEN_FILLER, ((Block)UGBlocks.GOLD_ORE.get()).func_176223_P(), 9));
        public static final ConfiguredFeature<?, ?> DIAMOND_ORE = Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(UNDERGARDEN_FILLER, ((Block)UGBlocks.DIAMOND_ORE.get()).func_176223_P(), 8));
        public static final ConfiguredFeature<?, ?> CLOGGRUM_ORE = Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(UNDERGARDEN_FILLER, ((Block)UGBlocks.CLOGGRUM_ORE.get()).func_176223_P(), 9));
        public static final ConfiguredFeature<?, ?> FROSTSTEEL_ORE = Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(UNDERGARDEN_FILLER, ((Block)UGBlocks.FROSTSTEEL_ORE.get()).func_176223_P(), 9));
        public static final ConfiguredFeature<?, ?> UTHERIUM_ORE = Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(UNDERGARDEN_FILLER, ((Block)UGBlocks.UTHERIUM_ORE.get()).func_176223_P(), 8));
        public static final ConfiguredFeature<?, ?> REGALIUM_ORE = Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(UNDERGARDEN_FILLER, ((Block)UGBlocks.REGALIUM_ORE.get()).func_176223_P(), 4));
        public static final ConfiguredFeature<?, ?> SHIVERSTONE_PATCH = Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(UNDERGARDEN_FILLER, ((Block)UGBlocks.SHIVERSTONE.get()).func_176223_P(), 33));
        public static final ConfiguredFeature<?, ?> DEEPSOIL_PATCH = Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(UNDERGARDEN_FILLER, ((Block)UGBlocks.DEEPSOIL.get()).func_176223_P(), 33));
        public static final ConfiguredFeature<?, ?> ICE_PATCH = Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(UNDERGARDEN_FILLER, Blocks.field_150403_cj.func_176223_P(), 33));
        public static final ConfiguredFeature<BaseTreeFeatureConfig, ?> SMOGSTEM_TREE = ((Feature)UNDERGARDEN_TREE.get()).func_225566_b_((IFeatureConfig)new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(((RotatedPillarBlock)UGBlocks.SMOGSTEM_WOOD.get()).func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(((Block)UGBlocks.SMOGSTEM_LEAVES.get()).func_176223_P()), (FoliagePlacer)new BlobFoliagePlacer(FeatureSpread.func_242252_a((int)2), FeatureSpread.func_242252_a((int)0), 2), (AbstractTrunkPlacer)new SmogstemTrunkPlacer(10, 2, 2), (AbstractFeatureSizeType)new TwoLayerFeature(1, 1, 2)).func_236700_a_().func_225568_b_());
        public static final ConfiguredFeature<BaseTreeFeatureConfig, ?> WIGGLEWOOD_TREE = ((Feature)UNDERGARDEN_TREE.get()).func_225566_b_((IFeatureConfig)new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(((RotatedPillarBlock)UGBlocks.WIGGLEWOOD_LOG.get()).func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(((Block)UGBlocks.WIGGLEWOOD_LEAVES.get()).func_176223_P()), (FoliagePlacer)new BushFoliagePlacer(FeatureSpread.func_242252_a((int)2), FeatureSpread.func_242252_a((int)0), 0), (AbstractTrunkPlacer)new ForkyTrunkPlacer(3, 1, 1), (AbstractFeatureSizeType)new TwoLayerFeature(1, 0, 2)).func_236700_a_().func_225568_b_());
        public static final ConfiguredFeature<BaseTreeFeatureConfig, ?> SMOGSTEM_TREE_TALL = ((Feature)UNDERGARDEN_TREE.get()).func_225566_b_((IFeatureConfig)new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(((RotatedPillarBlock)UGBlocks.SMOGSTEM_WOOD.get()).func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(((Block)UGBlocks.SMOGSTEM_LEAVES.get()).func_176223_P()), (FoliagePlacer)new BlobFoliagePlacer(FeatureSpread.func_242252_a((int)2), FeatureSpread.func_242252_a((int)0), 2), (AbstractTrunkPlacer)new SmogstemTrunkPlacer(15, 4, 4), (AbstractFeatureSizeType)new TwoLayerFeature(1, 1, 2)).func_236700_a_().func_225568_b_());
        public static final ConfiguredFeature<BaseTreeFeatureConfig, ?> WIGGLEWOOD_TREE_TALL = ((Feature)UNDERGARDEN_TREE.get()).func_225566_b_((IFeatureConfig)new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(((RotatedPillarBlock)UGBlocks.WIGGLEWOOD_LOG.get()).func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(((Block)UGBlocks.WIGGLEWOOD_LEAVES.get()).func_176223_P()), (FoliagePlacer)new BushFoliagePlacer(FeatureSpread.func_242252_a((int)2), FeatureSpread.func_242252_a((int)0), 0), (AbstractTrunkPlacer)new ForkyTrunkPlacer(6, 2, 2), (AbstractFeatureSizeType)new TwoLayerFeature(1, 0, 2)).func_236700_a_().func_225568_b_());
        public static final ConfiguredFeature<BigMushroomFeatureConfig, ?> BLOOD_MUSHROOM = ((Feature)BLOOD_MUSHROOM.get()).func_225566_b_((IFeatureConfig)new BigMushroomFeatureConfig((BlockStateProvider)new SimpleBlockStateProvider(((Block)UGBlocks.BLOOD_MUSHROOM_CAP.get()).func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(((Block)UGBlocks.BLOOD_MUSHROOM_STALK.get()).func_176223_P()), 3));
        public static final ConfiguredFeature<BigMushroomFeatureConfig, ?> INDIGO_MUSHROOM = ((Feature)INDIGO_MUSHROOM.get()).func_225566_b_((IFeatureConfig)new BigMushroomFeatureConfig((BlockStateProvider)new SimpleBlockStateProvider(((Block)UGBlocks.INDIGO_MUSHROOM_CAP.get()).func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(((Block)UGBlocks.INDIGO_MUSHROOM_STALK.get()).func_176223_P()), 3));
        public static final ConfiguredFeature<BigMushroomFeatureConfig, ?> INK_MUSHROOM = ((Feature)INK_MUSHROOM.get()).func_225566_b_((IFeatureConfig)new BigMushroomFeatureConfig((BlockStateProvider)new SimpleBlockStateProvider(((Block)UGBlocks.INK_MUSHROOM_CAP.get()).func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(Blocks.field_196706_do.func_176223_P()), 5));
        public static final ConfiguredFeature<BigMushroomFeatureConfig, ?> VEIL_MUSHROOM = ((Feature)VEIL_MUSHROOM.get()).func_225566_b_((IFeatureConfig)new BigMushroomFeatureConfig((BlockStateProvider)new SimpleBlockStateProvider(((Block)UGBlocks.VEIL_MUSHROOM_CAP.get()).func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(((Block)UGBlocks.VEIL_MUSHROOM_STALK.get()).func_176223_P()), 2));
        public static final ConfiguredFeature<?, ?> DEPTHROCK_BOULDER = Feature.field_202283_ac.func_225566_b_((IFeatureConfig)new BlockStateFeatureConfig(((Block)UGBlocks.DEPTHROCK.get()).func_176223_P()));
        public static final ConfiguredFeature<?, ?> SHIVERSTONE_BOULDER = Feature.field_202283_ac.func_225566_b_((IFeatureConfig)new BlockStateFeatureConfig(((Block)UGBlocks.SHIVERSTONE.get()).func_176223_P()));
        public static final ConfiguredFeature<?, ?> GLOWING_KELP = ((Feature)GLOWING_KELP.get()).func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e);
        public static final ConfiguredFeature<?, ?> SMOG_VENT = ((Feature)SMOG_VENT.get()).func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e);
        public static final ConfiguredFeature<?, ?> DROOPVINE = ((Feature)DROOPVINE.get()).func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e);
        public static final ConfiguredFeature<?, ?> ICE_PILLAR = ((Feature)ICE_PILLAR.get()).func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e);
    }
}

