/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.common;

import ht.treechop.common.capabilities.ChopSettingsCapability;
import ht.treechop.common.capabilities.ChopSettingsProvider;
import ht.treechop.common.config.ConfigHandler;
import ht.treechop.common.network.PacketHandler;
import ht.treechop.common.util.ChopResult;
import ht.treechop.common.util.ChopUtil;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class Common {
    private static Set<EntityPlayer> playersAlreadyChopping = new HashSet<EntityPlayer>();

    public void preInit() {
        ChopSettingsCapability.register();
        PacketHandler.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void onBreakEvent(BlockEvent.BreakEvent event) {
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        EntityPlayer agent = event.getPlayer();
        ItemStack tool = agent.func_184614_ca();
        IBlockState blockState = event.getState();
        if (!ChopUtil.isBlockALog(world, pos, blockState) || playersAlreadyChopping.contains(agent) || !ConfigHandler.enabled || !ChopUtil.canChopWithTool(tool) || !ChopUtil.playerWantsToChop(agent) || event.isCanceled()) {
            return;
        }
        try {
            playersAlreadyChopping.add(agent);
            ChopResult chopResult = ChopUtil.getChopResult(world, pos, agent, ChopUtil.getNumChopsByTool(tool), tool, ChopUtil.playerWantsToFell(agent), logPos -> ChopUtil.isBlockALog(world, logPos));
            if (chopResult != ChopResult.IGNORED && chopResult.apply(pos, agent, tool, ConfigHandler.breakLeaves)) {
                event.setCanceled(true);
                if (!agent.func_184812_l_()) {
                    ChopUtil.doItemDamage(tool, world, blockState, pos, agent);
                }
            }
        }
        finally {
            playersAlreadyChopping.remove(agent);
        }
    }

    @SubscribeEvent
    public void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        ResourceLocation loc = new ResourceLocation("treechopchop_settings_capability");
        Entity entity = (Entity)event.getObject();
        if (entity instanceof EntityPlayer) {
            event.addCapability(loc, (ICapabilityProvider)new ChopSettingsProvider());
        }
    }

    @SubscribeEvent
    public void onPlayerCloned(PlayerEvent.Clone event) {
        if (event.isWasDeath()) {
            EntityPlayer oldPlayer = event.getOriginal();
            EntityPlayer newPlayer = event.getEntityPlayer();
            ChopSettingsCapability oldSettings = ChopSettingsCapability.forPlayer(oldPlayer);
            ChopSettingsCapability newSettings = ChopSettingsCapability.forPlayer(newPlayer);
            newSettings.copyFrom(oldSettings);
        }
    }

    public boolean isClient() {
        return false;
    }
}

