/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.common.block;

import ht.treechop.common.block.IChoppable;
import ht.treechop.common.properties.BlockStateProperties;
import ht.treechop.common.properties.ChoppedLogShape;
import ht.treechop.common.util.ChopUtil;
import java.util.List;
import java.util.function.BinaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ChoppedLogBlock
extends Block
implements IChoppable {
    private final ChoppedLogShape shape;
    private static final int MAX_NUM_CHOPS = 7;
    private static final PropertyInteger CHOPS = BlockStateProperties.CHOP_COUNT;
    public static final AxisAlignedBB[] PILLAR_SHAPES_BY_CHOPS;
    public static final AxisAlignedBB[] CORNER_NW_SHAPES_BY_CHOPS;
    public static final AxisAlignedBB[] CORNER_NE_SHAPES_BY_CHOPS;
    public static final AxisAlignedBB[] CORNER_SE_SHAPES_BY_CHOPS;
    public static final AxisAlignedBB[] CORNER_SW_SHAPES_BY_CHOPS;
    public static final AxisAlignedBB[] END_W_SHAPES_BY_CHOPS;
    public static final AxisAlignedBB[] END_N_SHAPES_BY_CHOPS;
    public static final AxisAlignedBB[] END_E_SHAPES_BY_CHOPS;
    public static final AxisAlignedBB[] END_S_SHAPES_BY_CHOPS;
    public static final AxisAlignedBB[] SIDE_W_SHAPES_BY_CHOPS;
    public static final AxisAlignedBB[] SIDE_N_SHAPES_BY_CHOPS;
    public static final AxisAlignedBB[] SIDE_E_SHAPES_BY_CHOPS;
    public static final AxisAlignedBB[] SIDE_S_SHAPES_BY_CHOPS;

    public ChoppedLogBlock(ChoppedLogShape shape) {
        super(Material.field_151575_d, MapColor.field_151663_o);
        this.setRegistryName(new ResourceLocation("treechop", "chopped_log_" + shape.func_176610_l().toLowerCase()));
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149711_c(2.0f);
        this.func_149752_b(2.0f);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)CHOPS, (Comparable)Integer.valueOf(1)));
        this.shape = shape;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)CHOPS, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState blockState) {
        return (Integer)blockState.func_177229_b((IProperty)CHOPS);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{CHOPS});
    }

    @Override
    public IBlockState withChops(IBlockState blockState, int numChops) {
        return blockState.func_177226_a((IProperty)CHOPS, (Comparable)Integer.valueOf(numChops));
    }

    @Override
    public int getNumChops(IBlockState blockState) {
        return (Integer)blockState.func_177229_b((IProperty)CHOPS);
    }

    @Override
    public int getMaxNumChops() {
        return 7;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        boolean flush;
        double[] edges;
        AxisAlignedBB box = this.func_185496_a(state, null, pos);
        switch (face) {
            case WEST: 
            case EAST: {
                edges = new double[]{box.field_72338_b, box.field_72339_c, box.field_72337_e, box.field_72334_f};
                flush = face == EnumFacing.WEST ? box.field_72340_a == 0.0 : box.field_72336_d == 1.0;
                break;
            }
            case NORTH: 
            case SOUTH: {
                edges = new double[]{box.field_72338_b, box.field_72340_a, box.field_72337_e, box.field_72336_d};
                flush = face == EnumFacing.NORTH ? box.field_72339_c == 0.0 : box.field_72334_f == 1.0;
                break;
            }
            case DOWN: 
            case UP: {
                edges = new double[]{box.field_72340_a, box.field_72339_c, box.field_72336_d, box.field_72334_f};
                flush = face == EnumFacing.DOWN ? box.field_72338_b == 0.0 : box.field_72337_e == 1.0;
                break;
            }
            default: {
                return BlockFaceShape.UNDEFINED;
            }
        }
        if (!flush) {
            return BlockFaceShape.UNDEFINED;
        }
        double minDistanceFromCenter = Stream.of(0.5 - edges[0], 0.5 - edges[1], edges[2] - 0.5, edges[3] - 0.5).reduce(BinaryOperator.minBy(Double::compare)).orElse(0.0);
        return minDistanceFromCenter > 0.0 ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        int chops = (Integer)state.func_177229_b((IProperty)CHOPS);
        switch (this.shape) {
            case CORNER_NW: {
                return CORNER_NW_SHAPES_BY_CHOPS[chops];
            }
            case CORNER_NE: {
                return CORNER_NE_SHAPES_BY_CHOPS[chops];
            }
            case CORNER_SE: {
                return CORNER_SE_SHAPES_BY_CHOPS[chops];
            }
            case CORNER_SW: {
                return CORNER_SW_SHAPES_BY_CHOPS[chops];
            }
            case END_W: {
                return END_W_SHAPES_BY_CHOPS[chops];
            }
            case END_N: {
                return END_N_SHAPES_BY_CHOPS[chops];
            }
            case END_E: {
                return END_E_SHAPES_BY_CHOPS[chops];
            }
            case END_S: {
                return END_S_SHAPES_BY_CHOPS[chops];
            }
            case SIDE_W: {
                return SIDE_W_SHAPES_BY_CHOPS[chops];
            }
            case SIDE_N: {
                return SIDE_N_SHAPES_BY_CHOPS[chops];
            }
            case SIDE_E: {
                return SIDE_E_SHAPES_BY_CHOPS[chops];
            }
            case SIDE_S: {
                return SIDE_S_SHAPES_BY_CHOPS[chops];
            }
        }
        return PILLAR_SHAPES_BY_CHOPS[chops];
    }

    public static ChoppedLogShape getPlacementShape(World world, BlockPos blockPos) {
        boolean NORTH = true;
        int EAST = 2;
        int SOUTH = 4;
        int WEST = 8;
        byte sides = (byte)((ChopUtil.isBlockALog(world, blockPos.func_177978_c()) ? 1 : 0) | (ChopUtil.isBlockALog(world, blockPos.func_177974_f()) ? 2 : 0) | (ChopUtil.isBlockALog(world, blockPos.func_177968_d()) ? 4 : 0) | (ChopUtil.isBlockALog(world, blockPos.func_177976_e()) ? 8 : 0));
        switch (sides) {
            case 9: {
                return ChoppedLogShape.CORNER_NW;
            }
            case 3: {
                return ChoppedLogShape.CORNER_NE;
            }
            case 6: {
                return ChoppedLogShape.CORNER_SE;
            }
            case 12: {
                return ChoppedLogShape.CORNER_SW;
            }
            case 2: {
                return ChoppedLogShape.END_W;
            }
            case 4: {
                return ChoppedLogShape.END_N;
            }
            case 8: {
                return ChoppedLogShape.END_E;
            }
            case 1: {
                return ChoppedLogShape.END_S;
            }
            case 7: {
                return ChoppedLogShape.SIDE_W;
            }
            case 14: {
                return ChoppedLogShape.SIDE_N;
            }
            case 13: {
                return ChoppedLogShape.SIDE_E;
            }
            case 11: {
                return ChoppedLogShape.SIDE_S;
            }
        }
        return ChoppedLogShape.PILLAR;
    }

    static {
        List scaledChops = Stream.of(Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(2.0f), Float.valueOf(3.0f), Float.valueOf(4.0f), Float.valueOf(5.0f), Float.valueOf(6.0f), Float.valueOf(7.0f)).map(a -> Float.valueOf(a.floatValue() / 16.0f)).collect(Collectors.toList());
        PILLAR_SHAPES_BY_CHOPS = (AxisAlignedBB[])scaledChops.stream().map(chops -> new AxisAlignedBB((double)chops.floatValue(), 0.0, (double)chops.floatValue(), (double)(1.0f - chops.floatValue()), 1.0, (double)(1.0f - chops.floatValue()))).toArray(AxisAlignedBB[]::new);
        CORNER_NW_SHAPES_BY_CHOPS = (AxisAlignedBB[])scaledChops.stream().map(chops -> new AxisAlignedBB(0.0, 0.0, 0.0, (double)(1.0f - chops.floatValue() * 2.0f), 1.0, (double)(1.0f - chops.floatValue() * 2.0f))).toArray(AxisAlignedBB[]::new);
        CORNER_NE_SHAPES_BY_CHOPS = (AxisAlignedBB[])scaledChops.stream().map(chops -> new AxisAlignedBB((double)(chops.floatValue() * 2.0f), 0.0, 0.0, 1.0, 1.0, (double)(1.0f - chops.floatValue() * 2.0f))).toArray(AxisAlignedBB[]::new);
        CORNER_SE_SHAPES_BY_CHOPS = (AxisAlignedBB[])scaledChops.stream().map(chops -> new AxisAlignedBB((double)(chops.floatValue() * 2.0f), 0.0, (double)(chops.floatValue() * 2.0f), 1.0, 1.0, 1.0)).toArray(AxisAlignedBB[]::new);
        CORNER_SW_SHAPES_BY_CHOPS = (AxisAlignedBB[])scaledChops.stream().map(chops -> new AxisAlignedBB(0.0, 0.0, (double)(chops.floatValue() * 2.0f), (double)(1.0f - chops.floatValue() * 2.0f), 1.0, 1.0)).toArray(AxisAlignedBB[]::new);
        END_W_SHAPES_BY_CHOPS = (AxisAlignedBB[])scaledChops.stream().map(chops -> new AxisAlignedBB((double)(chops.floatValue() * 2.0f), 0.0, (double)chops.floatValue(), 1.0, 1.0, (double)(1.0f - chops.floatValue()))).toArray(AxisAlignedBB[]::new);
        END_N_SHAPES_BY_CHOPS = (AxisAlignedBB[])scaledChops.stream().map(chops -> new AxisAlignedBB((double)chops.floatValue(), 0.0, (double)(chops.floatValue() * 2.0f), (double)(1.0f - chops.floatValue()), 1.0, 1.0)).toArray(AxisAlignedBB[]::new);
        END_E_SHAPES_BY_CHOPS = (AxisAlignedBB[])scaledChops.stream().map(chops -> new AxisAlignedBB(0.0, 0.0, (double)chops.floatValue(), (double)(1.0f - chops.floatValue() * 2.0f), 1.0, (double)(1.0f - chops.floatValue()))).toArray(AxisAlignedBB[]::new);
        END_S_SHAPES_BY_CHOPS = (AxisAlignedBB[])scaledChops.stream().map(chops -> new AxisAlignedBB((double)chops.floatValue(), 0.0, 0.0, (double)(1.0f - chops.floatValue()), 1.0, (double)(1.0f - chops.floatValue() * 2.0f))).toArray(AxisAlignedBB[]::new);
        SIDE_W_SHAPES_BY_CHOPS = (AxisAlignedBB[])scaledChops.stream().map(chops -> new AxisAlignedBB((double)(chops.floatValue() * 2.0f), 0.0, 0.0, 1.0, 1.0, 1.0)).toArray(AxisAlignedBB[]::new);
        SIDE_N_SHAPES_BY_CHOPS = (AxisAlignedBB[])scaledChops.stream().map(chops -> new AxisAlignedBB(0.0, 0.0, (double)(chops.floatValue() * 2.0f), 1.0, 1.0, 1.0)).toArray(AxisAlignedBB[]::new);
        SIDE_E_SHAPES_BY_CHOPS = (AxisAlignedBB[])scaledChops.stream().map(chops -> new AxisAlignedBB(0.0, 0.0, 0.0, (double)(1.0f - chops.floatValue() * 2.0f), 1.0, 1.0)).toArray(AxisAlignedBB[]::new);
        SIDE_S_SHAPES_BY_CHOPS = (AxisAlignedBB[])scaledChops.stream().map(chops -> new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, (double)(1.0f - chops.floatValue() * 2.0f))).toArray(AxisAlignedBB[]::new);
    }
}

