/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.common.capabilities;

import ht.treechop.TreeChopMod;
import ht.treechop.common.capabilities.ChopSettings;
import ht.treechop.common.config.SneakBehavior;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;

public class ChopSettingsCapability
extends ChopSettings {
    @CapabilityInject(value=ChopSettingsCapability.class)
    public static final Capability<ChopSettingsCapability> CAPABILITY = null;
    private boolean isSynced = false;

    public boolean isSynced() {
        return this.isSynced;
    }

    public void setSynced() {
        this.isSynced = true;
    }

    public static void register() {
        CapabilityManager.INSTANCE.register(ChopSettingsCapability.class, (Capability.IStorage)new Storage(), ChopSettingsCapability::new);
    }

    public static ChopSettingsCapability forPlayer(EntityPlayer player) {
        return (ChopSettingsCapability)player.getCapability(CAPABILITY, null);
    }

    public static class Storage
    implements Capability.IStorage<ChopSettingsCapability> {
        private static final String CHOPPING_ENABLED_KEY = "choppingEnabled";
        private static final String FELLING_ENABLED_KEY = "fellingEnabled";
        private static final String SNEAK_BEHAVIOR_KEY = "sneakBehavior";
        private static final String ONLY_CHOP_TREES_WITH_LEAVES_KEY = "sneakBehavior";
        private static final String IS_SYNCED_KEY = "isSynced";

        @Nullable
        public NBTBase writeNBT(Capability<ChopSettingsCapability> capability, ChopSettingsCapability instance, EnumFacing side) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74757_a(CHOPPING_ENABLED_KEY, instance.getChoppingEnabled());
            nbt.func_74757_a(FELLING_ENABLED_KEY, instance.getFellingEnabled());
            nbt.func_74778_a("sneakBehavior", instance.getSneakBehavior().name());
            nbt.func_74757_a("sneakBehavior", instance.getTreeMustHaveLeaves());
            nbt.func_74757_a(IS_SYNCED_KEY, instance.isSynced());
            return nbt;
        }

        public void readNBT(Capability<ChopSettingsCapability> capability, ChopSettingsCapability instance, EnumFacing side, NBTBase nbt) {
            if (nbt instanceof NBTTagCompound) {
                SneakBehavior sneakBehavior;
                NBTTagCompound compoundNbt = (NBTTagCompound)nbt;
                Optional<Boolean> choppingEnabled = this.getBoolean(compoundNbt, CHOPPING_ENABLED_KEY);
                Optional<Boolean> fellingEnabled = this.getBoolean(compoundNbt, FELLING_ENABLED_KEY);
                try {
                    sneakBehavior = SneakBehavior.valueOf(compoundNbt.func_74779_i("sneakBehavior"));
                }
                catch (IllegalArgumentException e) {
                    TreeChopMod.LOGGER.warn(String.format("NBT contains bad sneak behavior value \"%s\"; using default value instead", compoundNbt.func_74779_i("sneakBehavior")));
                    sneakBehavior = SneakBehavior.INVERT_CHOPPING;
                }
                Optional<Boolean> onlyChopTreesWithLeaves = this.getBoolean(compoundNbt, "sneakBehavior");
                Optional<Boolean> isSynced = this.getBoolean(compoundNbt, IS_SYNCED_KEY);
                instance.setChoppingEnabled(choppingEnabled.orElse(instance.getChoppingEnabled()));
                instance.setFellingEnabled(fellingEnabled.orElse(instance.getFellingEnabled()));
                instance.setSneakBehavior(sneakBehavior);
                instance.setOnlyChopTreesWithLeaves(onlyChopTreesWithLeaves.orElse(instance.getTreeMustHaveLeaves()));
                if (isSynced.orElse(false).booleanValue()) {
                    instance.setSynced();
                }
            } else {
                TreeChopMod.LOGGER.warn("Failed to read ChopSettingsCapability NBT");
            }
        }

        private Optional<Boolean> getBoolean(NBTTagCompound compoundNbt, String key) {
            return compoundNbt.func_74764_b(key) ? Optional.of(compoundNbt.func_74767_n(key)) : Optional.empty();
        }
    }
}

