/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.common.config;

import java.util.Arrays;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.util.IStringSerializable;

public enum SneakBehavior implements IStringSerializable
{
    NONE("NONE", agent -> false, agent -> false),
    INVERT_CHOPPING("INVERT CHOPPING", Entity::func_70093_af, agent -> false),
    INVERT_FELLING("INVERT FELLING", agent -> false, Entity::func_70093_af);

    public static final int maxNameLength;
    private final String name;
    private final Predicate<Entity> chopBehavior;
    private final Predicate<Entity> fellBehavior;

    private SneakBehavior(String name, Predicate<Entity> chopBehavior, Predicate<Entity> fellBehavior) {
        this.name = name;
        this.chopBehavior = chopBehavior;
        this.fellBehavior = fellBehavior;
    }

    public String toString() {
        return this.name;
    }

    public String func_176610_l() {
        return this.name;
    }

    public boolean shouldChangeChopBehavior(Entity agent) {
        return this.chopBehavior.test(agent);
    }

    public boolean shouldChangeFellBehavior(Entity agent) {
        return this.fellBehavior.test(agent);
    }

    static {
        maxNameLength = Arrays.stream(SneakBehavior.values()).map(Enum::name).map(String::length).max(Integer::compareTo).orElse(0);
    }
}

