/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.common.network;

import ht.treechop.TreeChopMod;
import ht.treechop.common.capabilities.ChopSettingsCapability;
import ht.treechop.common.config.ConfigHandler;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class PacketEnableChopping
implements IMessage {
    private boolean choppingEnabled;

    public PacketEnableChopping(boolean choppingEnabled) {
        this.choppingEnabled = choppingEnabled;
    }

    public PacketEnableChopping() {
        this(true);
    }

    public void fromBytes(ByteBuf buffer) {
        this.choppingEnabled = buffer.readBoolean();
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeBoolean(this.choppingEnabled);
    }

    public static class Handler
    implements IMessageHandler<PacketEnableChopping, IMessage> {
        public IMessage onMessage(PacketEnableChopping message, MessageContext context) {
            if (context.side == Side.SERVER) {
                EntityPlayerMP player = context.getServerHandler().field_147369_b;
                player.func_184102_h().func_152344_a(() -> {
                    if (ConfigHandler.canChooseNotToChop) {
                        ChopSettingsCapability chopSettings = ChopSettingsCapability.forPlayer((EntityPlayer)player);
                        chopSettings.setChoppingEnabled(message.choppingEnabled);
                        player.func_145747_a(TreeChopMod.makeText("Chopping " + (chopSettings.getChoppingEnabled() ? "ON" : "OFF")));
                    } else {
                        player.func_145747_a(TreeChopMod.makeText("Chopping ON" + TextFormatting.RED + " (you are not permitted to disable chopping)"));
                    }
                });
            }
            return null;
        }
    }
}

