/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.common.network;

import ht.treechop.TreeChopMod;
import ht.treechop.common.capabilities.ChopSettings;
import ht.treechop.common.capabilities.ChopSettingsCapability;
import ht.treechop.common.config.ConfigHandler;
import ht.treechop.common.config.SneakBehavior;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class PacketSetSneakBehavior
implements IMessage {
    private SneakBehavior sneakBehavior;
    private static final SneakBehavior defaultSneakBehavior = new ChopSettings().getSneakBehavior();

    public PacketSetSneakBehavior(SneakBehavior sneakBehavior) {
        this.sneakBehavior = sneakBehavior;
    }

    public PacketSetSneakBehavior() {
        this(defaultSneakBehavior);
    }

    public void fromBytes(ByteBuf buffer) {
        int sneakBehaviorIndex = buffer.readInt();
        this.sneakBehavior = sneakBehaviorIndex < SneakBehavior.values().length ? SneakBehavior.values()[sneakBehaviorIndex] : defaultSneakBehavior;
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeInt(this.sneakBehavior.ordinal());
    }

    public static class Handler
    implements IMessageHandler<PacketSetSneakBehavior, IMessage> {
        public IMessage onMessage(PacketSetSneakBehavior message, MessageContext context) {
            if (context.side == Side.SERVER) {
                EntityPlayerMP player = context.getServerHandler().field_147369_b;
                player.func_184102_h().func_152344_a(() -> {
                    if (ConfigHandler.canChooseNotToChop) {
                        ChopSettingsCapability chopSettings = ChopSettingsCapability.forPlayer((EntityPlayer)player);
                        chopSettings.setSneakBehavior(message.sneakBehavior);
                        player.func_145747_a(TreeChopMod.makeText("Sneak behavior " + chopSettings.getSneakBehavior().func_176610_l()));
                    } else {
                        player.func_145747_a(TreeChopMod.makeText("Sneak behavior " + SneakBehavior.NONE.func_176610_l() + TextFormatting.RED + " (you are not permitted to disable chopping or felling)"));
                    }
                });
            }
            return null;
        }
    }
}

