/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.common.network;

import ht.treechop.common.capabilities.ChopSettings;
import ht.treechop.common.config.SneakBehavior;
import io.netty.buffer.ByteBuf;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public abstract class PacketSyncChopSettings
implements IMessage {
    protected ChopSettings chopSettings;
    private static final SneakBehavior defaultSneakBehavior = new ChopSettings().getSneakBehavior();

    public PacketSyncChopSettings(ChopSettings chopSettings) {
        this.chopSettings = chopSettings;
    }

    public PacketSyncChopSettings() {
        this(new ChopSettings());
    }

    public void fromBytes(ByteBuf buffer) {
        this.chopSettings.setChoppingEnabled(buffer.readBoolean());
        this.chopSettings.setFellingEnabled(buffer.readBoolean());
        int sneakBehaviorIndex = buffer.readInt();
        this.chopSettings.setSneakBehavior(sneakBehaviorIndex < SneakBehavior.values().length ? SneakBehavior.values()[sneakBehaviorIndex] : defaultSneakBehavior);
        this.chopSettings.setOnlyChopTreesWithLeaves(buffer.readBoolean());
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeBoolean(this.chopSettings.getChoppingEnabled());
        buffer.writeBoolean(this.chopSettings.getFellingEnabled());
        buffer.writeInt(this.chopSettings.getSneakBehavior().ordinal());
        buffer.writeBoolean(this.chopSettings.getTreeMustHaveLeaves());
    }
}

