/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.common.util;

import ht.treechop.TreeChopMod;
import ht.treechop.client.Client;
import ht.treechop.common.block.ChoppedLogBlock;
import ht.treechop.common.block.IChoppable;
import ht.treechop.common.capabilities.ChopSettings;
import ht.treechop.common.capabilities.ChopSettingsCapability;
import ht.treechop.common.config.ConfigHandler;
import ht.treechop.common.init.ModBlocks;
import ht.treechop.common.properties.ChoppedLogShape;
import ht.treechop.common.util.BlockNeighbors;
import ht.treechop.common.util.ChopResult;
import ht.treechop.common.util.TreeBlock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHugeMushroom;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.ForgeEventFactory;

public class ChopUtil {
    private static final Random RANDOM = new Random();
    public static final int FELL_NOISE_INTERVAL = 16;
    public static final int MAX_NOISE_ATTEMPTS = 128;

    public static boolean isBlockChoppable(World world, BlockPos pos, IBlockState blockState) {
        return blockState.func_177230_c() instanceof IChoppable || ChopUtil.isBlockALog(world, pos, blockState) && (!ChopUtil.isBlockALog(world, pos.func_177976_e()) || !ChopUtil.isBlockALog(world, pos.func_177978_c()) || !ChopUtil.isBlockALog(world, pos.func_177974_f()) || !ChopUtil.isBlockALog(world, pos.func_177968_d()));
    }

    public static boolean isBlockChoppable(World world, BlockPos pos) {
        return ChopUtil.isBlockChoppable(world, pos, world.func_180495_p(pos));
    }

    public static boolean isBlockALog(World world, BlockPos pos, IBlockState blockState) {
        Block block = blockState.func_177230_c();
        return block instanceof IChoppable || ConfigHandler.getLogBlocks().contains(block) || ConfigHandler.getLogItems().contains(block.getPickBlock(blockState, null, world, pos, null).func_77973_b()) || ChopUtil.isMushroomStem(blockState);
    }

    public static boolean isBlockALog(World world, BlockPos pos) {
        return ChopUtil.isBlockALog(world, pos, world.func_180495_p(pos));
    }

    public static boolean isBlockLeaves(World world, BlockPos pos) {
        return ChopUtil.isBlockLeaves(world, pos, world.func_180495_p(pos));
    }

    public static boolean isBlockLeaves(World world, BlockPos pos, IBlockState blockState) {
        Block block = blockState.func_177230_c();
        return ConfigHandler.getLeavesBlocks().contains(block) || ConfigHandler.getLeavesItems().contains(block.getPickBlock(blockState, null, world, pos, null).func_77973_b()) || ChopUtil.isMushroomCap(blockState);
    }

    private static boolean isMushroomCap(IBlockState blockState) {
        if (blockState.func_177230_c() instanceof BlockHugeMushroom) {
            BlockHugeMushroom.EnumType variant = (BlockHugeMushroom.EnumType)blockState.func_177229_b((IProperty)BlockHugeMushroom.field_176380_a);
            return variant != BlockHugeMushroom.EnumType.STEM && variant != BlockHugeMushroom.EnumType.ALL_STEM;
        }
        return false;
    }

    private static boolean isMushroomStem(IBlockState blockState) {
        if (blockState.func_177230_c() instanceof BlockHugeMushroom) {
            BlockHugeMushroom.EnumType variant = (BlockHugeMushroom.EnumType)blockState.func_177229_b((IProperty)BlockHugeMushroom.field_176380_a);
            return variant == BlockHugeMushroom.EnumType.STEM || variant == BlockHugeMushroom.EnumType.ALL_STEM;
        }
        return false;
    }

    public static Set<BlockPos> getConnectedBlocks(Collection<BlockPos> startingPoints, Function<BlockPos, Stream<BlockPos>> searchOffsetsSupplier, int maxNumBlocks, AtomicInteger iterationCounter) {
        HashSet<BlockPos> connectedBlocks = new HashSet<BlockPos>();
        List<Object> newConnectedBlocks = new LinkedList<BlockPos>(startingPoints);
        iterationCounter.set(0);
        do {
            connectedBlocks.addAll(newConnectedBlocks);
            if (connectedBlocks.size() >= maxNumBlocks) break;
            newConnectedBlocks = newConnectedBlocks.stream().flatMap(blockPos -> ((Stream)searchOffsetsSupplier.apply((BlockPos)blockPos)).filter(pos1 -> !connectedBlocks.contains(pos1))).limit(maxNumBlocks - connectedBlocks.size()).collect(Collectors.toList());
            iterationCounter.incrementAndGet();
        } while (!newConnectedBlocks.isEmpty());
        return connectedBlocks;
    }

    public static Set<BlockPos> getConnectedBlocks(Collection<BlockPos> startingPoints, Function<BlockPos, Stream<BlockPos>> searchOffsetsSupplier, int maxNumBlocks) {
        return ChopUtil.getConnectedBlocks(startingPoints, searchOffsetsSupplier, maxNumBlocks, new AtomicInteger());
    }

    public static boolean canChangeBlock(BlockPos blockPos, EntityPlayer agent, ItemStack tool) {
        return tool.func_190926_b() || !tool.func_77973_b().onBlockStartBreak(tool, blockPos, agent);
    }

    public static List<BlockPos> getTreeLeaves(World world, Collection<BlockPos> treeBlocks) {
        AtomicInteger iterationCounter = new AtomicInteger();
        HashSet leaves = new HashSet();
        int maxNumLeavesBlocks = ConfigHandler.maxNumLeavesBlocks;
        ChopUtil.getConnectedBlocks(treeBlocks, pos1 -> {
            IBlockState blockState = world.func_180495_p(pos1);
            return (ChopUtil.isBlockLeaves(world, pos1, blockState) && !(blockState.func_177230_c() instanceof BlockLeaves) ? BlockNeighbors.ADJACENTS_AND_BELOW_ADJACENTS : BlockNeighbors.ADJACENTS).asStream((BlockPos)pos1).filter(pos2 -> ChopUtil.markLeavesToDestroyAndKeepLooking(world, pos2, iterationCounter, leaves));
        }, maxNumLeavesBlocks, iterationCounter);
        if (leaves.size() >= maxNumLeavesBlocks) {
            TreeChopMod.LOGGER.warn(String.format("Max number of leaves reached: %d >= %d blocks", leaves.size(), maxNumLeavesBlocks));
        }
        return new ArrayList<BlockPos>(leaves);
    }

    public static boolean markLeavesToDestroyAndKeepLooking(World world, BlockPos pos, AtomicInteger iterationCounter, Set<BlockPos> leavesToDestroy) {
        IBlockState blockState = world.func_180495_p(pos);
        if (ChopUtil.isBlockLeaves(world, pos, blockState)) {
            if (blockState.func_177230_c() instanceof BlockLeaves) {
                if (iterationCounter.get() + 1 > ConfigHandler.maxBreakLeavesDistance) {
                    return false;
                }
                if (!((Boolean)blockState.func_177229_b((IProperty)BlockLeaves.field_176237_a)).booleanValue()) {
                    return true;
                }
            } else if (iterationCounter.get() >= ConfigHandler.maxBreakLeavesDistance) {
                return false;
            }
            leavesToDestroy.add(pos);
            return true;
        }
        return false;
    }

    public static int numChopsToFell(int numBlocks) {
        return (int)((float)ConfigHandler.chopCountingAlgorithm.calculate(numBlocks) * ConfigHandler.chopCountScale);
    }

    public static ChopResult getChopResult(World world, BlockPos blockPos, EntityPlayer agent, int numChops, ItemStack tool, boolean fellIfPossible, Predicate<BlockPos> logCondition) {
        return fellIfPossible ? ChopUtil.getChopResult(world, blockPos, agent, numChops, tool, logCondition) : ChopUtil.tryToChopWithoutFelling(world, blockPos, agent, numChops, tool);
    }

    public static ChopResult getChopResult(World world, BlockPos blockPos, EntityPlayer agent, int numChops, ItemStack tool, Predicate<BlockPos> logCondition) {
        if (!ChopUtil.isBlockChoppable(world, blockPos, world.func_180495_p(blockPos))) {
            return ChopResult.IGNORED;
        }
        int maxNumTreeBlocks = ConfigHandler.maxNumTreeBlocks;
        AtomicBoolean hasLeaves = new AtomicBoolean(!ChopUtil.getPlayerChopSettings(agent).getTreeMustHaveLeaves());
        Set<BlockPos> supportedBlocks = ChopUtil.getConnectedBlocks(Collections.singletonList(blockPos), somePos -> BlockNeighbors.HORIZONTAL_AND_ABOVE.asStream((BlockPos)somePos).peek(pos -> hasLeaves.compareAndSet(false, ChopUtil.isBlockLeaves(world, pos))).filter(logCondition), maxNumTreeBlocks);
        if (!hasLeaves.get()) {
            return ChopResult.IGNORED;
        }
        if (supportedBlocks.size() >= maxNumTreeBlocks) {
            TreeChopMod.LOGGER.warn(String.format("Max tree size reached: %d >= %d block (not including leaves)", supportedBlocks.size(), maxNumTreeBlocks));
        }
        return ChopUtil.chopTree(world, blockPos, supportedBlocks, numChops);
    }

    public static ChopResult chopTree(World world, BlockPos target, Set<BlockPos> supportedBlocks, int numChops) {
        int numChopsToFell;
        IBlockState blockState = world.func_180495_p(target);
        int currentNumChops = ChopUtil.getNumChops(blockState);
        if (currentNumChops + numChops < (numChopsToFell = ChopUtil.numChopsToFell(supportedBlocks.size()))) {
            Set<BlockPos> nearbyChoppableBlocks = ChopUtil.getConnectedBlocks(Collections.singletonList(target), pos -> BlockNeighbors.ADJACENTS_AND_DIAGONALS.asStream((BlockPos)pos).filter(checkPos -> Math.abs(checkPos.func_177956_o() - target.func_177956_o()) < 4 && ChopUtil.isBlockChoppable(world, checkPos)), 64);
            int totalNumChops = ChopUtil.getNumChops(world, nearbyChoppableBlocks) + numChops;
            if (totalNumChops >= numChopsToFell) {
                List choppedLogsSortedByY = nearbyChoppableBlocks.stream().filter(pos1 -> world.func_180495_p(pos1).func_177230_c() instanceof IChoppable).sorted(Comparator.comparingInt(Vec3i::func_177956_o)).collect(Collectors.toList());
                for (BlockPos pos2 : choppedLogsSortedByY) {
                    int chops = ChopUtil.getNumChops(world, pos2);
                    supportedBlocks.add(pos2);
                    if (chops <= numChopsToFell) continue;
                    break;
                }
            } else {
                return ChopUtil.gatherChops(world, target, numChops, nearbyChoppableBlocks);
            }
        }
        supportedBlocks.remove(target);
        return new ChopResult(world, Collections.singletonList(target), supportedBlocks);
    }

    public static ChopResult gatherChops(World world, BlockPos target, int numChops, Set<BlockPos> nearbyChoppableBlocks) {
        List sortedChoppableBlocks;
        LinkedList<TreeBlock> choppedBlocks = new LinkedList<TreeBlock>();
        int numChopsLeft = ChopUtil.gatherChopAndGetNumChopsRemaining(world, target, numChops, choppedBlocks);
        if (numChopsLeft > 0 && (sortedChoppableBlocks = nearbyChoppableBlocks.stream().filter(blockPos1 -> {
            IBlockState blockState1 = world.func_180495_p(blockPos1);
            Block block1 = blockState1.func_177230_c();
            if (block1 instanceof IChoppable) {
                return ChopUtil.getNumChops(blockState1) < ChopUtil.getMaxNumChops(world, target, blockState1);
            }
            return blockPos1.func_177956_o() >= target.func_177956_o();
        }).sorted(Comparator.comparingInt(a -> ChopUtil.chopDistance(target, a))).collect(Collectors.toList())).size() > 0) {
            int nextChoiceDistance = ChopUtil.chopDistance(target, (BlockPos)sortedChoppableBlocks.get(0));
            int candidateStartIndex = 0;
            int n = sortedChoppableBlocks.size();
            for (int i = 0; i <= n; ++i) {
                BlockPos nextTarget;
                if (i != n && ChopUtil.chopDistance(target, (BlockPos)sortedChoppableBlocks.get(i)) <= nextChoiceDistance) continue;
                List candidates = sortedChoppableBlocks.subList(candidateStartIndex, i);
                Collections.shuffle(candidates);
                Iterator iterator = candidates.iterator();
                while (iterator.hasNext() && (numChopsLeft = ChopUtil.gatherChopAndGetNumChopsRemaining(world, nextTarget = (BlockPos)iterator.next(), numChopsLeft, choppedBlocks)) > 0) {
                }
                if (numChopsLeft <= 0) break;
                candidateStartIndex = i;
            }
        }
        return new ChopResult(choppedBlocks);
    }

    private static int gatherChopAndGetNumChopsRemaining(World world, BlockPos target, int numChops, List<TreeBlock> choppedBlocks) {
        IBlockState blockStateAfterChopping;
        IBlockState blockStateBeforeChopping = world.func_180495_p(target);
        if (blockStateBeforeChopping != (blockStateAfterChopping = ChopUtil.getBlockStateAfterChops(world, target, numChops, false))) {
            choppedBlocks.add(new TreeBlock(world, target, blockStateAfterChopping));
        }
        return numChops - (ChopUtil.getNumChops(blockStateAfterChopping) - ChopUtil.getNumChops(blockStateBeforeChopping));
    }

    private static IBlockState getBlockStateAfterChops(World world, BlockPos blockPos, int numChops, boolean destructive) {
        IBlockState blockState = world.func_180495_p(blockPos);
        Block block = blockState.func_177230_c();
        if (block instanceof IChoppable) {
            return ChopUtil.getBlockStateAfterChops(world, blockPos, blockState, numChops, destructive);
        }
        ChoppedLogShape shape = ChoppedLogBlock.getPlacementShape(world, blockPos);
        IChoppable choppedBlock = ChopUtil.getChoppedBlock(world, blockPos, blockState, shape);
        if (choppedBlock instanceof Block) {
            IBlockState defaultChoppedState = ((Block)choppedBlock).func_176223_P();
            return ChopUtil.getBlockStateAfterChops(world, blockPos, defaultChoppedState, numChops - ChopUtil.getNumChops(defaultChoppedState), destructive);
        }
        throw new IllegalArgumentException(String.format("Block \"%s\" is not choppable", block.getRegistryName()));
    }

    private static IBlockState getBlockStateAfterChops(World world, BlockPos pos, IBlockState blockState, int numChops, boolean destructive) {
        int maxNumChops;
        Block block = blockState.func_177230_c();
        int currentNumChops = ChopUtil.getNumChops(blockState);
        int newNumChops = currentNumChops + numChops;
        if (newNumChops <= (maxNumChops = ChopUtil.getMaxNumChops(world, pos, blockState))) {
            return ((IChoppable)block).withChops(blockState, newNumChops);
        }
        return destructive ? Blocks.field_150350_a.func_176223_P() : ((IChoppable)block).withChops(blockState, maxNumChops);
    }

    private static int getMaxNumChops(World world, BlockPos pos, IBlockState blockState) {
        Block block = blockState.func_177230_c();
        if (block instanceof IChoppable) {
            return ((IChoppable)block).getMaxNumChops();
        }
        IChoppable choppedBlock = ChopUtil.getChoppedBlock(world, pos, blockState, ChoppedLogShape.PILLAR);
        return choppedBlock != null ? choppedBlock.getMaxNumChops() : 0;
    }

    private static IChoppable getChoppedBlock(World world, BlockPos pos, IBlockState blockState, ChoppedLogShape shape) {
        if (ChopUtil.isBlockALog(world, pos, blockState)) {
            return blockState.func_177230_c() instanceof IChoppable ? (IChoppable)blockState.func_177230_c() : (IChoppable)ModBlocks.CHOPPED_LOGS.get((Object)shape);
        }
        return null;
    }

    private static IChoppable getChoppedBlock(World world, BlockPos pos, IBlockState blockState) {
        return ChopUtil.getChoppedBlock(world, pos, blockState, ChoppedLogShape.PILLAR);
    }

    public static int getNumChops(World world, BlockPos pos) {
        return ChopUtil.getNumChops(world.func_180495_p(pos));
    }

    public static int getNumChops(IBlockState blockState) {
        Block block = blockState.func_177230_c();
        return block instanceof IChoppable ? ((IChoppable)block).getNumChops(blockState) : 0;
    }

    public static int getNumChops(World world, Set<BlockPos> nearbyChoppableBlocks) {
        return nearbyChoppableBlocks.stream().map(arg_0 -> ((World)world).func_180495_p(arg_0)).map(blockState1 -> blockState1.func_177230_c() instanceof IChoppable ? ((IChoppable)blockState1.func_177230_c()).getNumChops((IBlockState)blockState1) : 0).reduce(Integer::sum).orElse(0);
    }

    private static ChopResult tryToChopWithoutFelling(World world, BlockPos blockPos, EntityPlayer agent, int numChops, ItemStack tool) {
        return ChopUtil.isBlockChoppable(world, blockPos) ? new ChopResult(Collections.singletonList(new TreeBlock(world, blockPos, ChopUtil.getBlockStateAfterChops(world, blockPos, numChops, true))), false) : ChopResult.IGNORED;
    }

    public static int manhattanDistance(BlockPos a, BlockPos b) {
        float f = Math.abs(a.func_177958_n() - b.func_177958_n());
        float f1 = Math.abs(a.func_177956_o() - b.func_177956_o());
        float f2 = Math.abs(a.func_177952_p() - b.func_177952_p());
        return (int)(f + f1 + f2);
    }

    public static int chopDistance(BlockPos a, BlockPos b) {
        return ChopUtil.manhattanDistance(a, b);
    }

    public static boolean canChopWithTool(ItemStack tool) {
        return !ConfigHandler.getChoppingToolBlacklistItems().contains(tool.func_77973_b());
    }

    public static int getNumChopsByTool(ItemStack tool) {
        return 1;
    }

    public static boolean playerWantsToChop(EntityPlayer player) {
        ChopSettings chopSettings = ChopUtil.getPlayerChopSettings(player);
        if (ConfigHandler.canChooseNotToChop) {
            return chopSettings.getChoppingEnabled() ^ chopSettings.getSneakBehavior().shouldChangeChopBehavior((Entity)player);
        }
        return true;
    }

    public static boolean playerWantsToFell(EntityPlayer player) {
        ChopSettings chopSettings = ChopUtil.getPlayerChopSettings(player);
        if (ConfigHandler.canChooseNotToChop) {
            return chopSettings.getFellingEnabled() ^ chopSettings.getSneakBehavior().shouldChangeFellBehavior((Entity)player);
        }
        return true;
    }

    private static boolean isLocalPlayer(EntityPlayer player) {
        return !player.func_70613_aW() && Minecraft.func_71410_x().field_71439_g == player;
    }

    private static ChopSettings getPlayerChopSettings(EntityPlayer player) {
        return ChopUtil.isLocalPlayer(player) ? Client.getChopSettings() : (ChopSettings)player.getCapability(ChopSettingsCapability.CAPABILITY, null);
    }

    public static void doItemDamage(ItemStack itemStack, World world, IBlockState blockState, BlockPos blockPos, EntityPlayer agent) {
        ItemStack mockItemStack = itemStack.func_77946_l();
        itemStack.func_179548_a(world, blockState, blockPos, agent);
        if (itemStack.func_190926_b() && !mockItemStack.func_190926_b()) {
            ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)agent, (ItemStack)mockItemStack, (EnumHand)EnumHand.MAIN_HAND);
        }
    }

    public static void dropExperience(World world, BlockPos blockPos, int amount) {
        if (world instanceof WorldServer) {
            Blocks.field_150350_a.func_180637_b(world, blockPos, amount);
        }
    }
}

