/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.client.model;

import ht.treechop.TreeChopMod;
import ht.treechop.client.model.ModelUtil;
import ht.treechop.common.block.ChoppedLogBlock;
import ht.treechop.common.config.ConfigHandler;
import ht.treechop.common.init.ModBlocks;
import ht.treechop.common.properties.BlockStateProperties;
import ht.treechop.common.properties.ChoppedLogShape;
import ht.treechop.common.util.FaceShape;
import ht.treechop.common.util.Vector3;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ILightReader;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;

public class ChoppedLogBakedModel
implements IDynamicBakedModel {
    public static ModelProperty<ChoppedLogShape> SHAPE = new ModelProperty();
    public static ModelProperty<Integer> CHOPS = new ModelProperty();
    public static ModelProperty<Set<Direction>> SOLID_SIDES = new ModelProperty();
    private final IBakedModel staticModel;
    private final ResourceLocation textureRL = new ResourceLocation("treechop:block/chopped_log");
    private final TextureAtlasSprite sprite;
    private final boolean removeBarkOnInteriorLogs;

    public ChoppedLogBakedModel(IBakedModel staticModel, boolean removeBarkOnInteriorLogs) {
        this.staticModel = staticModel;
        this.removeBarkOnInteriorLogs = removeBarkOnInteriorLogs;
        this.sprite = Minecraft.func_71410_x().func_209506_al().func_229356_a_(AtlasTexture.field_110575_b).func_195424_a(this.textureRL);
    }

    public static void overrideBlockStateModels(ModelBakeEvent event) {
        for (BlockState blockState : ((Block)ModBlocks.CHOPPED_LOG.get()).func_176194_O().func_177619_a()) {
            ModelResourceLocation variantMRL = BlockModelShapes.func_209554_c((BlockState)blockState);
            IBakedModel existingModel = (IBakedModel)event.getModelRegistry().get(variantMRL);
            if (existingModel == null) {
                TreeChopMod.LOGGER.warn("Did not find the expected vanilla baked model(s) for treechop:chopped_log in registry");
                continue;
            }
            if (existingModel instanceof ChoppedLogBakedModel) {
                TreeChopMod.LOGGER.warn("Tried to replace ChoppedLogBakedModel twice");
                continue;
            }
            ChoppedLogBakedModel customModel = new ChoppedLogBakedModel(existingModel, (Boolean)ConfigHandler.CLIENT.removeBarkOnInteriorLogs.get());
            event.getModelRegistry().put(variantMRL, customModel);
        }
    }

    @Nonnull
    public IModelData getModelData(@Nonnull ILightReader world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull IModelData tileData) {
        if (!state.func_196959_b(BlockStateProperties.CHOPPED_LOG_SHAPE) || !state.func_196959_b((IProperty)BlockStateProperties.CHOP_COUNT)) {
            throw new IllegalArgumentException(String.format("Could not bake chopped log model; block state %s is missing \"%s\" or \"%s\"", state.toString(), BlockStateProperties.CHOPPED_LOG_SHAPE.func_177701_a(), BlockStateProperties.CHOP_COUNT.func_177701_a()));
        }
        ChoppedLogShape shape = (ChoppedLogShape)((Object)state.func_177229_b(BlockStateProperties.CHOPPED_LOG_SHAPE));
        Set solidSides = this.removeBarkOnInteriorLogs ? (Set)Arrays.stream(Direction.values()).filter(direction -> direction.func_176740_k().func_176722_c() && !shape.isSideOpen((Direction)direction)).filter(direction -> {
            BlockState blockState = world.func_180495_p(pos.func_177972_a(direction));
            Block block = blockState.func_177230_c();
            return blockState.func_200132_m() && !(block instanceof ChoppedLogBlock);
        }).collect(Collectors.toCollection(() -> EnumSet.noneOf(Direction.class))) : Collections.emptySet();
        ModelDataMap.Builder builder = new ModelDataMap.Builder();
        builder.withInitial(SHAPE, (Object)state.func_177229_b(BlockStateProperties.CHOPPED_LOG_SHAPE));
        builder.withInitial(CHOPS, (Object)state.func_177229_b((IProperty)BlockStateProperties.CHOP_COUNT));
        builder.withInitial(SOLID_SIDES, (Object)solidSides);
        return builder.build();
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        if (extraData.hasProperty(SHAPE) && extraData.hasProperty(CHOPS)) {
            if (side == null) {
                ChoppedLogShape shape = (ChoppedLogShape)((Object)extraData.getData(SHAPE));
                int chops = (Integer)extraData.getData(CHOPS);
                Set solidSides = (Set)extraData.getData(SOLID_SIDES);
                AxisAlignedBB box = shape.getBoundingBox(chops);
                float downY = (float)box.func_197745_a(Direction.Axis.Y);
                float upY = (float)box.func_197742_b(Direction.Axis.Y);
                float northZ = (float)box.func_197745_a(Direction.Axis.Z);
                float southZ = (float)box.func_197742_b(Direction.Axis.Z);
                float westX = (float)box.func_197745_a(Direction.Axis.X);
                float eastX = (float)box.func_197742_b(Direction.Axis.X);
                Vector3 topNorthEast = new Vector3(eastX, upY, northZ);
                Vector3 topNorthWest = new Vector3(westX, upY, northZ);
                Vector3 topSouthEast = new Vector3(eastX, upY, southZ);
                Vector3 topSouthWest = new Vector3(westX, upY, southZ);
                Vector3 bottomNorthEast = new Vector3(eastX, downY, northZ);
                Vector3 bottomNorthWest = new Vector3(westX, downY, northZ);
                Vector3 bottomSouthEast = new Vector3(eastX, downY, southZ);
                Vector3 bottomSouthWest = new Vector3(westX, downY, southZ);
                return Stream.concat(Stream.of(ModelUtil.makeQuad(this.textureRL, this.sprite, bottomSouthEast, bottomNorthWest, Direction.DOWN, null), ModelUtil.makeQuad(this.textureRL, this.sprite, topSouthEast, topNorthWest, Direction.UP, null), ModelUtil.makeQuad(this.textureRL, this.sprite, topNorthEast, bottomNorthWest, Direction.NORTH, null), ModelUtil.makeQuad(this.textureRL, this.sprite, topSouthEast, bottomSouthWest, Direction.SOUTH, null), ModelUtil.makeQuad(this.textureRL, this.sprite, topSouthWest, bottomNorthWest, Direction.WEST, null), ModelUtil.makeQuad(this.textureRL, this.sprite, topSouthEast, bottomNorthEast, Direction.EAST, null)), solidSides.stream().map(direction -> ModelUtil.makeQuad(this.textureRL, this.sprite, FaceShape.get(direction), direction.func_176734_d(), null))).filter(Objects::nonNull).collect(Collectors.toList());
            }
            return Collections.emptyList();
        }
        return Collections.emptyList();
    }

    public boolean func_177555_b() {
        return this.staticModel.func_177555_b();
    }

    public boolean func_177556_c() {
        return this.staticModel.func_177556_c();
    }

    public boolean func_230044_c_() {
        return this.staticModel.func_230044_c_();
    }

    public boolean func_188618_c() {
        return this.staticModel.func_188618_c();
    }

    @Nonnull
    public TextureAtlasSprite func_177554_e() {
        return this.sprite;
    }

    @Nonnull
    public ItemOverrideList func_188617_f() {
        return this.staticModel.func_188617_f();
    }
}

