/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.client.model;

import ht.treechop.common.util.FaceShape;
import ht.treechop.common.util.Vector3;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.BlockFaceUV;
import net.minecraft.client.renderer.model.BlockPartFace;
import net.minecraft.client.renderer.model.FaceBakery;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.SimpleModelTransform;

public class ModelUtil {
    public static BakedQuad makeQuad(ResourceLocation textureRL, TextureAtlasSprite sprite, FaceShape faceShape, Direction orientation, Direction culling) {
        return ModelUtil.makeQuad(textureRL, sprite, faceShape.getCorner1(), faceShape.getCorner3(), orientation, culling);
    }

    public static BakedQuad makeQuad(ResourceLocation textureRL, TextureAtlasSprite sprite, Vector3 posFrom, Vector3 posTo, Direction orientation, Direction culling) {
        return ModelUtil.makeQuad(textureRL, sprite, posFrom, posTo, orientation, culling, ModelUtil.getUVsForQuad(posFrom, posTo, orientation), 0);
    }

    private static float[] getUVsForQuad(Vector3 posFrom, Vector3 posTo, Direction orientation) {
        Vector3f posFrom3f = posFrom.asVector3f();
        Vector3f posTo3f = posTo.asVector3f();
        switch (orientation) {
            case UP: 
            case DOWN: {
                return new float[]{posFrom3f.func_195899_a(), posFrom3f.func_195902_c(), posTo3f.func_195899_a(), posTo3f.func_195902_c()};
            }
            case EAST: 
            case WEST: {
                return new float[]{posFrom3f.func_195902_c(), posFrom3f.func_195900_b(), posTo3f.func_195902_c(), posTo3f.func_195900_b()};
            }
        }
        return new float[]{posFrom3f.func_195899_a(), posFrom3f.func_195900_b(), posTo3f.func_195899_a(), posTo3f.func_195900_b()};
    }

    public static BakedQuad makeQuad(ResourceLocation textureRL, TextureAtlasSprite sprite, Vector3 posFrom, Vector3 posTo, Direction orientation, Direction culling, float[] uvs, int uvRotation) {
        return new FaceBakery().func_228824_a_(posFrom.asVector3f(), posTo.asVector3f(), new BlockPartFace(culling, -1, textureRL.toString(), new BlockFaceUV(uvs, uvRotation)), sprite, orientation, (IModelTransform)SimpleModelTransform.IDENTITY, null, true, null);
    }
}

