/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.common;

import ht.treechop.common.capabilities.ChopSettingsCapability;
import ht.treechop.common.capabilities.ChopSettingsProvider;
import ht.treechop.common.config.ConfigHandler;
import ht.treechop.common.event.ChopEvent;
import ht.treechop.common.network.PacketHandler;
import ht.treechop.common.util.ChopResult;
import ht.treechop.common.util.ChopUtil;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.NetworkTagCollection;
import net.minecraft.tags.TagCollection;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;

public class Common {
    public static void onCommonSetup(FMLCommonSetupEvent event) {
        IEventBus eventBus = MinecraftForge.EVENT_BUS;
        eventBus.addListener(Common::onBreakEvent);
        eventBus.addListener(Common::onTagsUpdated);
        eventBus.addGenericListener(Entity.class, Common::onAttachCapabilities);
        ConfigHandler.onReload();
        ChopSettingsCapability.register();
        PacketHandler.init();
    }

    private static void onTagsUpdated(TagsUpdatedEvent event) {
        NetworkTagCollection blockTags = event.getTagManager().func_199717_a();
        ConfigHandler.updateTags((TagCollection<Block>)blockTags);
    }

    private static void onBreakEvent(BlockEvent.BreakEvent event) {
        PlayerEntity agent = event.getPlayer();
        ItemStack tool = agent.func_184614_ca();
        BlockState blockState = event.getState();
        BlockPos pos = event.getPos();
        if (!(ChopUtil.isBlockALog(blockState) && ((Boolean)ConfigHandler.COMMON.enabled.get()).booleanValue() && ChopUtil.canChopWithTool(tool) && ChopUtil.playerWantsToChop(agent) && !event.isCanceled() && event.getWorld() instanceof World)) {
            return;
        }
        World world = (World)event.getWorld();
        boolean canceled = MinecraftForge.EVENT_BUS.post((Event)new ChopEvent.StartChopEvent(world, agent, pos, blockState));
        if (canceled) {
            return;
        }
        ChopResult chopResult = ChopUtil.getChopResult(world, pos, agent, ChopUtil.getNumChopsByTool(tool), ChopUtil.playerWantsToFell(agent), logPos -> ChopUtil.isBlockALog((IWorld)world, logPos));
        if (chopResult != ChopResult.IGNORED) {
            if (chopResult.apply(pos, agent, tool, (Boolean)ConfigHandler.COMMON.breakLeaves.get())) {
                event.setCanceled(true);
                if (!agent.func_184812_l_()) {
                    ChopUtil.doItemDamage(tool, world, blockState, pos, agent);
                }
            }
            MinecraftForge.EVENT_BUS.post((Event)new ChopEvent.FinishChopEvent(world, agent, pos, blockState));
        }
    }

    private static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        ResourceLocation loc = new ResourceLocation("treechopchop_settings_capability");
        Entity entity = (Entity)event.getObject();
        if (entity instanceof PlayerEntity) {
            event.addCapability(loc, (ICapabilityProvider)new ChopSettingsProvider());
        }
    }
}

