/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.common.capabilities;

import ht.treechop.common.config.SneakBehavior;

public class ChopSettings {
    private boolean choppingEnabled = true;
    private boolean fellingEnabled = true;
    private SneakBehavior sneakBehavior = SneakBehavior.INVERT_CHOPPING;
    private boolean treesMustHaveLeaves = true;
    private boolean chopInCreativeMode = true;

    public boolean getChoppingEnabled() {
        return this.choppingEnabled;
    }

    public boolean getFellingEnabled() {
        return this.fellingEnabled;
    }

    public SneakBehavior getSneakBehavior() {
        return this.sneakBehavior;
    }

    public boolean getTreesMustHaveLeaves() {
        return this.treesMustHaveLeaves;
    }

    public boolean getChopInCreativeMode() {
        return this.chopInCreativeMode;
    }

    public void setChoppingEnabled(boolean enabled) {
        this.choppingEnabled = enabled;
    }

    public void setFellingEnabled(boolean enabled) {
        this.fellingEnabled = enabled;
    }

    public void setSneakBehavior(SneakBehavior behavior) {
        this.sneakBehavior = behavior;
    }

    public void setTreesMustHaveLeaves(boolean enabled) {
        this.treesMustHaveLeaves = enabled;
    }

    public void setChopInCreativeMode(boolean enabled) {
        this.chopInCreativeMode = enabled;
    }

    public void toggleChopping() {
        this.setChoppingEnabled(!this.choppingEnabled);
    }

    public void toggleFelling() {
        this.setFellingEnabled(!this.fellingEnabled);
    }

    public void cycleSneakBehavior() {
        SneakBehavior nextSneakBehavior = SneakBehavior.values()[Math.floorMod(this.sneakBehavior.ordinal() + 1, SneakBehavior.values().length)];
        this.setSneakBehavior(nextSneakBehavior);
    }

    public void copyFrom(ChopSettings oldSettings) {
        this.choppingEnabled = oldSettings.choppingEnabled;
        this.fellingEnabled = oldSettings.fellingEnabled;
        this.sneakBehavior = oldSettings.sneakBehavior;
        this.treesMustHaveLeaves = oldSettings.treesMustHaveLeaves;
        this.chopInCreativeMode = oldSettings.chopInCreativeMode;
    }
}

