/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.common.config;

import ht.treechop.common.capabilities.ChopSettings;
import ht.treechop.common.config.ChopCountingAlgorithm;
import ht.treechop.common.config.SneakBehavior;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.tags.TagCollection;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class ConfigHandler {
    public static Tag<Block> blockTagForDetectingLogs;
    public static Tag<Block> blockTagForDetectingLeaves;
    public static Set<ResourceLocation> choppingToolItemsBlacklist;
    public static Set<ResourceLocation> choppingToolTagsBlacklist;
    public static int maxBreakLeavesDistance;
    public static boolean breakPersistentLeaves;
    public static final Common COMMON;
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final Client CLIENT;
    public static final ForgeConfigSpec CLIENT_SPEC;

    public static void onReload() {
        choppingToolItemsBlacklist = ((List)ConfigHandler.COMMON.choppingToolsBlacklist.get()).stream().filter(tag -> !tag.startsWith("#")).map(ResourceLocation::func_208304_a).filter(Objects::nonNull).collect(Collectors.toSet());
        choppingToolTagsBlacklist = ((List)ConfigHandler.COMMON.choppingToolsBlacklist.get()).stream().filter(tag -> tag.startsWith("#")).map(tag -> ResourceLocation.func_208304_a((String)tag.substring(1))).filter(Objects::nonNull).collect(Collectors.toSet());
        maxBreakLeavesDistance = (Integer)ConfigHandler.COMMON.maxBreakLeavesDistance.get();
        breakPersistentLeaves = (Boolean)ConfigHandler.COMMON.breakPersistentLeaves.get();
        ConfigHandler.updateTags((TagCollection<Block>)BlockTags.func_199896_a());
    }

    public static void updateTags(TagCollection<Block> blockTags) {
        blockTagForDetectingLogs = blockTags.func_199910_a(new ResourceLocation((String)ConfigHandler.COMMON.blockTagForDetectingLogs.get()));
        blockTagForDetectingLeaves = blockTags.func_199910_a(new ResourceLocation((String)ConfigHandler.COMMON.blockTagForDetectingLeaves.get()));
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
        specPair = new ForgeConfigSpec.Builder().configure(Client::new);
        CLIENT_SPEC = (ForgeConfigSpec)specPair.getRight();
        CLIENT = (Client)specPair.getLeft();
    }

    public static class Client {
        public final ForgeConfigSpec.BooleanValue choppingEnabled;
        public final ForgeConfigSpec.BooleanValue fellingEnabled;
        public final ForgeConfigSpec.EnumValue<SneakBehavior> sneakBehavior;
        public final ForgeConfigSpec.BooleanValue treesMustHaveLeaves;
        public final ForgeConfigSpec.BooleanValue chopInCreativeMode;
        public final ForgeConfigSpec.BooleanValue useProceduralChoppedModels;
        public final ForgeConfigSpec.BooleanValue removeBarkOnInteriorLogs;

        public Client(ForgeConfigSpec.Builder builder) {
            builder.push("chopping");
            this.choppingEnabled = builder.comment("Default setting for whether or not the user wishes to chop (can be toggled in-game)").define("choppingEnabled", true);
            this.fellingEnabled = builder.comment("Default setting for whether or not the user wishes to fell tree when chopping (can be toggled in-game)").define("fellingEnabled", true);
            this.sneakBehavior = builder.comment("Default setting for the effect that sneaking has on chopping (can be cycled in-game)").defineEnum("sneakBehavior", (Enum)SneakBehavior.INVERT_CHOPPING);
            this.treesMustHaveLeaves = builder.comment("Whether to ignore trees without connected leaves").define("onlyBreakTreesWithLeaves", false);
            this.chopInCreativeMode = builder.comment("Whether to enable chopping when in creative mode (even when false, sneaking can still enable chopping)").define("chopInCreativeMode", false);
            builder.pop();
            builder.push("visuals");
            this.useProceduralChoppedModels = builder.comment("Whether to use procedural chopped log models; disable to use models added by a resource pack").define("useProceduralChoppedModels", true);
            this.removeBarkOnInteriorLogs = builder.comment("Whether to replace the interior sides of logs with a chopped texture instead of bark").define("removeBarkOnInteriorLogs", true);
            builder.pop();
        }

        public ChopSettings getChopSettings() {
            ChopSettings chopSettings = new ChopSettings();
            chopSettings.setChoppingEnabled((Boolean)ConfigHandler.CLIENT.choppingEnabled.get());
            chopSettings.setFellingEnabled((Boolean)ConfigHandler.CLIENT.fellingEnabled.get());
            chopSettings.setSneakBehavior((SneakBehavior)((Object)ConfigHandler.CLIENT.sneakBehavior.get()));
            chopSettings.setTreesMustHaveLeaves((Boolean)ConfigHandler.CLIENT.treesMustHaveLeaves.get());
            chopSettings.setChopInCreativeMode((Boolean)ConfigHandler.CLIENT.chopInCreativeMode.get());
            return chopSettings;
        }
    }

    public static class Common {
        public final ForgeConfigSpec.BooleanValue enabled;
        public final ForgeConfigSpec.BooleanValue canChooseNotToChop;
        public final ForgeConfigSpec.IntValue maxNumTreeBlocks;
        public final ForgeConfigSpec.IntValue maxNumLeavesBlocks;
        public final ForgeConfigSpec.BooleanValue breakLeaves;
        public final ForgeConfigSpec.BooleanValue breakPersistentLeaves;
        protected final ForgeConfigSpec.IntValue maxBreakLeavesDistance;
        protected final ForgeConfigSpec.ConfigValue<String> blockTagForDetectingLogs;
        protected final ForgeConfigSpec.ConfigValue<String> blockTagForDetectingLeaves;
        public final ForgeConfigSpec.EnumValue<ChopCountingAlgorithm> chopCountingAlgorithm;
        public final ForgeConfigSpec.DoubleValue chopCountScale;
        protected final ForgeConfigSpec.ConfigValue<List<? extends String>> choppingToolsBlacklist;
        public final ForgeConfigSpec.BooleanValue preventChoppingOnRightClick;
        public final ForgeConfigSpec.BooleanValue preventChopRecursion;
        public final ForgeConfigSpec.BooleanValue compatForProjectMMO;

        public Common(ForgeConfigSpec.Builder builder) {
            builder.push("permissions");
            this.enabled = builder.comment("Whether this mod is enabled or not").define("enabled", true);
            this.canChooseNotToChop = builder.comment("Whether players can deactivate chopping e.g. by sneaking").define("canChooseNotToChop", true);
            builder.pop();
            builder.push("treeDetection");
            this.maxNumTreeBlocks = builder.comment("Maximum number of log blocks that can be detected to belong to one tree").defineInRange("maxTreeBlocks", 320, 1, 8096);
            this.maxNumLeavesBlocks = builder.comment("Maximum number of leaves blocks that can destroyed when a tree is felled").defineInRange("maxLeavesBlocks", 1024, 1, 8096);
            this.breakLeaves = builder.comment("Whether to destroy leaves when a tree is felled").define("breakLeaves", true);
            this.breakPersistentLeaves = builder.comment("If breakLeaves is true, whether to destroy leaves that are marked as persistent when a tree is felled").define("breakPersistentLeaves", true);
            this.maxBreakLeavesDistance = builder.comment("Maximum distance from log blocks to destroy non-standard leaves blocks (e.g. mushroom caps) when felling").defineInRange("maxBreakLeavesDistance", 7, 0, 16);
            this.blockTagForDetectingLogs = builder.comment("The tag that blocks must have to be considered choppable (default: treechop:choppables)").define("blockTagForDetectingLogs", (Object)"treechop:choppables");
            this.blockTagForDetectingLeaves = builder.comment("The tag that blocks must have to be considered leaves (default: treechop:leaves_like)").define("blockTagForDetectingLeaves", (Object)"treechop:leaves_like");
            builder.pop();
            builder.push("chopCounting");
            this.chopCountingAlgorithm = builder.comment("Method to use for computing the number of chops needed to fell a tree").defineEnum("chopCountingMethod", (Enum)ChopCountingAlgorithm.LOGARITHMIC);
            this.chopCountScale = builder.comment("Scales the number of chops (rounding down) required to fell a tree; with chopCountingMethod=LINEAR, this is exactly the number of chops per block").defineInRange("chopCountScale", 1.0, 0.0, 1024.0);
            builder.pop();
            builder.push("compatibility");
            builder.push("general");
            this.preventChoppingOnRightClick = builder.comment("Whether to prevent chopping during right-click actions; fixes a conflict with Carry On (as of carryon-1.16.3-1.15.1.7)").define("preventChoppingOnRightClick", true);
            this.preventChopRecursion = builder.comment("Whether to prevent infinite loops when chopping; fixes crashes when using modded items that break multiple blocks").define("preventChopRecursion", true);
            this.choppingToolsBlacklist = builder.comment("List of item registry names (mod:item) and tags (#mod:tag) for items that should not chop when used to break a log").defineList("choppingToolsBlacklist", Arrays.asList("#forge:saws", "mekanism:atomic_disassembler"), always -> true);
            builder.pop();
            builder.push("specific");
            this.compatForProjectMMO = builder.comment("Whether to enable compatibility with ProjectMMO; for example, award XP for chopping").define("projectMMO", true);
            builder.pop();
            builder.pop();
        }
    }
}

