/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.common.network;

import ht.treechop.TreeChopMod;
import ht.treechop.common.capabilities.ChopSettingsCapability;
import ht.treechop.common.config.ConfigHandler;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketEnableChopping {
    private final boolean choppingEnabled;

    public PacketEnableChopping(boolean choppingEnabled) {
        this.choppingEnabled = choppingEnabled;
    }

    public static void encode(PacketEnableChopping message, PacketBuffer buffer) {
        buffer.writeBoolean(message.choppingEnabled);
    }

    public static PacketEnableChopping decode(PacketBuffer buffer) {
        return new PacketEnableChopping(buffer.readBoolean());
    }

    public static void handle(PacketEnableChopping message, Supplier<NetworkEvent.Context> context) {
        if (context.get().getDirection().getReceptionSide().isServer()) {
            context.get().enqueueWork(() -> {
                ServerPlayerEntity player = Objects.requireNonNull(((NetworkEvent.Context)context.get()).getSender());
                if (((Boolean)ConfigHandler.COMMON.canChooseNotToChop.get()).booleanValue()) {
                    ChopSettingsCapability chopSettings = ChopSettingsCapability.forPlayer((PlayerEntity)player);
                    chopSettings.setChoppingEnabled(message.choppingEnabled);
                    player.func_145747_a(TreeChopMod.makeText("Chopping " + (chopSettings.getChoppingEnabled() ? "ON" : "OFF")));
                } else {
                    player.func_145747_a(TreeChopMod.makeText("Chopping ON" + TextFormatting.RED + " (you are not permitted to disable chopping)"));
                }
            });
            context.get().setPacketHandled(true);
        }
    }
}

