/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.common.network;

import ht.treechop.TreeChopMod;
import ht.treechop.client.Client;
import ht.treechop.common.capabilities.ChopSettings;
import ht.treechop.common.capabilities.ChopSettingsCapability;
import ht.treechop.common.config.SneakBehavior;
import ht.treechop.common.network.PacketHandler;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import org.apache.commons.lang3.EnumUtils;

public class PacketSyncChopSettings {
    private final ChopSettings chopSettings;

    public PacketSyncChopSettings(ChopSettings chopSettings) {
        this.chopSettings = chopSettings;
    }

    public static void encode(PacketSyncChopSettings message, PacketBuffer buffer) {
        ChopSettings chopSettings = message.chopSettings;
        buffer.writeBoolean(chopSettings.getChoppingEnabled());
        buffer.writeBoolean(chopSettings.getFellingEnabled());
        buffer.func_180714_a(chopSettings.getSneakBehavior().name());
        buffer.writeBoolean(chopSettings.getTreesMustHaveLeaves());
        buffer.writeBoolean(chopSettings.getChopInCreativeMode());
    }

    public static PacketSyncChopSettings decode(PacketBuffer buffer) {
        ChopSettings chopSettings = new ChopSettings();
        chopSettings.setChoppingEnabled(buffer.readBoolean());
        chopSettings.setFellingEnabled(buffer.readBoolean());
        SneakBehavior sneakBehavior = (SneakBehavior)EnumUtils.getEnum(SneakBehavior.class, (String)buffer.func_150789_c(SneakBehavior.maxNameLength));
        chopSettings.setSneakBehavior(sneakBehavior != null ? sneakBehavior : chopSettings.getSneakBehavior());
        chopSettings.setTreesMustHaveLeaves(buffer.readBoolean());
        chopSettings.setChopInCreativeMode(buffer.readBoolean());
        return new PacketSyncChopSettings(chopSettings);
    }

    public static void handle(PacketSyncChopSettings message, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)context.get()).getDirection().getReceptionSide().isServer()) {
                PacketSyncChopSettings.handleOnServer(message, context);
            } else {
                PacketSyncChopSettings.handleOnClient(message);
            }
        });
        context.get().setPacketHandled(true);
    }

    private static void handleOnClient(PacketSyncChopSettings message) {
        TreeChopMod.LOGGER.info("Received chop settings from server");
        ChopSettings chopSettings = Client.getChopSettings();
        chopSettings.copyFrom(message.chopSettings);
    }

    public static void handleOnServer(PacketSyncChopSettings message, Supplier<NetworkEvent.Context> context) {
        ServerPlayerEntity player = context.get().getSender();
        ChopSettingsCapability chopSettings = ChopSettingsCapability.forPlayer((PlayerEntity)player);
        if (!chopSettings.isSynced()) {
            TreeChopMod.LOGGER.info("Received chop settings from player " + player.func_195047_I_());
            chopSettings.copyFrom(message.chopSettings);
            chopSettings.setSynced();
        }
        chopSettings.setTreesMustHaveLeaves(message.chopSettings.getTreesMustHaveLeaves());
        chopSettings.setChopInCreativeMode(message.chopSettings.getChopInCreativeMode());
        TreeChopMod.LOGGER.info("Sending chop settings to player " + player.func_195047_I_());
        PacketHandler.sendTo(player, new PacketSyncChopSettings(chopSettings));
    }
}

