/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.client;

import ht.treechop.client.Client;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;

public class KeyBindings {
    public static final String CATEGORY = "HT's TreeChop";
    public static final List<ActionableKeyBinding> allKeyBindings = new LinkedList<ActionableKeyBinding>();

    public static void init() {
        MinecraftForge.EVENT_BUS.addListener(KeyBindings::buttonPressed);
        KeyBindings.registerKeyBinding("toggle_chopping", KeyBindings.getKey(78), Client::toggleChopping);
        KeyBindings.registerKeyBinding("toggle_felling", KeyBindings.getKey(-1), Client::toggleFelling);
        KeyBindings.registerKeyBinding("cycle_sneak_behavior", KeyBindings.getKey(-1), Client::cycleSneakBehavior);
    }

    private static ActionableKeyBinding registerKeyBinding(String name, InputMappings.Input defaultKey, Runnable callback) {
        ActionableKeyBinding keyBinding = new ActionableKeyBinding(String.format("key.%s.%s", "treechop", name), defaultKey, callback);
        ClientRegistry.registerKeyBinding((KeyBinding)keyBinding);
        allKeyBindings.add(keyBinding);
        return keyBinding;
    }

    static InputMappings.Input getKey(int key) {
        return InputMappings.Type.KEYSYM.func_197944_a(key);
    }

    public static void buttonPressed(InputEvent.KeyInputEvent event) {
        if (event.isCanceled() || Minecraft.func_71410_x().field_71462_r != null || event.getKey() == -1) {
            return;
        }
        for (ActionableKeyBinding keyBinding : allKeyBindings) {
            if (event.getKey() != keyBinding.getKey().func_197937_c() || event.getAction() != 1) continue;
            keyBinding.onPress();
            return;
        }
    }

    protected static class ActionableKeyBinding
    extends KeyBinding {
        private final Runnable callback;

        public ActionableKeyBinding(String resourceName, InputMappings.Input inputByCode, Runnable callback) {
            super(resourceName, (IKeyConflictContext)KeyConflictContext.GUI, inputByCode, KeyBindings.CATEGORY);
            this.callback = callback;
        }

        public void onPress() {
            this.callback.run();
        }
    }
}

