/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.common.capabilities;

import ht.treechop.TreeChopMod;
import ht.treechop.common.capabilities.ChopSettings;
import ht.treechop.common.config.SneakBehavior;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;

public class ChopSettingsCapability
extends ChopSettings {
    @CapabilityInject(value=ChopSettingsCapability.class)
    public static final Capability<ChopSettingsCapability> CAPABILITY = null;
    private boolean isSynced = false;

    public boolean isSynced() {
        return this.isSynced;
    }

    public void setSynced() {
        this.isSynced = true;
    }

    public static void register() {
        CapabilityManager.INSTANCE.register(ChopSettingsCapability.class, (Capability.IStorage)new Storage(), ChopSettingsCapability::new);
    }

    public static ChopSettingsCapability forPlayer(PlayerEntity player) {
        return (ChopSettingsCapability)player.getCapability(CAPABILITY).orElseThrow(() -> new IllegalArgumentException(String.format("Missing chop settings for player \"%s\"", player.func_195047_I_())));
    }

    public static class Storage
    implements Capability.IStorage<ChopSettingsCapability> {
        private static final String CHOPPING_ENABLED_KEY = "choppingEnabled";
        private static final String FELLING_ENABLED_KEY = "fellingEnabled";
        private static final String SNEAK_BEHAVIOR_KEY = "sneakBehavior";
        private static final String TREES_MUST_HAVE_LEAVES_KEY = "treesMustHaveLeaves";
        private static final String CHOP_IN_CREATIVE_MODE_KEY = "chopInCreativeMode";
        private static final String IS_SYNCED_KEY = "isSynced";

        @Nullable
        public INBT writeNBT(Capability<ChopSettingsCapability> capability, ChopSettingsCapability instance, Direction side) {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74757_a(CHOPPING_ENABLED_KEY, instance.getChoppingEnabled());
            nbt.func_74757_a(FELLING_ENABLED_KEY, instance.getFellingEnabled());
            nbt.func_74778_a(SNEAK_BEHAVIOR_KEY, instance.getSneakBehavior().name());
            nbt.func_74757_a(TREES_MUST_HAVE_LEAVES_KEY, instance.getTreesMustHaveLeaves());
            nbt.func_74757_a(CHOP_IN_CREATIVE_MODE_KEY, instance.getChopInCreativeMode());
            nbt.func_74757_a(IS_SYNCED_KEY, instance.isSynced());
            return nbt;
        }

        public void readNBT(Capability<ChopSettingsCapability> capability, ChopSettingsCapability instance, Direction side, INBT nbt) {
            if (nbt instanceof CompoundNBT) {
                SneakBehavior sneakBehavior;
                CompoundNBT compoundNbt = (CompoundNBT)nbt;
                Optional<Boolean> choppingEnabled = this.getBoolean(compoundNbt, CHOPPING_ENABLED_KEY);
                Optional<Boolean> fellingEnabled = this.getBoolean(compoundNbt, FELLING_ENABLED_KEY);
                try {
                    sneakBehavior = SneakBehavior.valueOf(compoundNbt.func_74779_i(SNEAK_BEHAVIOR_KEY));
                }
                catch (IllegalArgumentException e) {
                    TreeChopMod.LOGGER.warn(String.format("NBT contains bad sneak behavior value \"%s\"; using default value instead", compoundNbt.func_74779_i(SNEAK_BEHAVIOR_KEY)));
                    sneakBehavior = SneakBehavior.INVERT_CHOPPING;
                }
                Optional<Boolean> onlyChopTreesWithLeaves = this.getBoolean(compoundNbt, TREES_MUST_HAVE_LEAVES_KEY);
                Optional<Boolean> chopInCreativeMode = this.getBoolean(compoundNbt, CHOP_IN_CREATIVE_MODE_KEY);
                Optional<Boolean> isSynced = this.getBoolean(compoundNbt, IS_SYNCED_KEY);
                instance.setChoppingEnabled(choppingEnabled.orElse(instance.getChoppingEnabled()));
                instance.setFellingEnabled(fellingEnabled.orElse(instance.getFellingEnabled()));
                instance.setSneakBehavior(sneakBehavior);
                instance.setTreesMustHaveLeaves(onlyChopTreesWithLeaves.orElse(instance.getTreesMustHaveLeaves()));
                instance.setChopInCreativeMode(chopInCreativeMode.orElse(instance.getChopInCreativeMode()));
                if (isSynced.orElse(false).booleanValue()) {
                    instance.setSynced();
                }
            } else {
                TreeChopMod.LOGGER.warn("Failed to read ChopSettingsCapability NBT");
            }
        }

        private Optional<Boolean> getBoolean(CompoundNBT compoundNbt, String key) {
            return compoundNbt.func_74764_b(key) ? Optional.of(compoundNbt.func_74767_n(key)) : Optional.empty();
        }
    }
}

