/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.common.capabilities;

import ht.treechop.TreeChopMod;
import ht.treechop.common.capabilities.ChopSettingsCapability;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class ChopSettingsProvider
implements ICapabilitySerializable<INBT> {
    private static final String CHOP_SETTINGS_NBT = "chopSettings";
    private static final byte COMPOUND_NBT_ID = new CompoundNBT().func_74732_a();
    private final LazyOptional<ChopSettingsCapability> chopSettings = LazyOptional.of(() -> ChopSettingsCapability.CAPABILITY.getDefaultInstance());

    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
        return ChopSettingsCapability.CAPABILITY == capability ? this.chopSettings.cast() : LazyOptional.empty();
    }

    private ChopSettingsCapability getChopSettings() {
        return (ChopSettingsCapability)this.chopSettings.orElseThrow(() -> new IllegalArgumentException("LazyOptional must not be empty"));
    }

    public INBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        INBT chopSettingsNbt = ChopSettingsCapability.CAPABILITY.writeNBT((Object)this.getChopSettings(), null);
        nbt.func_218657_a(CHOP_SETTINGS_NBT, chopSettingsNbt);
        return nbt;
    }

    public void deserializeNBT(INBT nbt) {
        if (nbt.func_74732_a() != COMPOUND_NBT_ID) {
            TreeChopMod.LOGGER.warn("Unexpected NBT type: " + nbt);
            return;
        }
        CompoundNBT compoundNbt = (CompoundNBT)nbt;
        INBT chopSettingsNbt = compoundNbt.func_74781_a(CHOP_SETTINGS_NBT);
        ChopSettingsCapability.CAPABILITY.readNBT((Object)this.getChopSettings(), null, chopSettingsNbt);
    }
}

