/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.common.config;

import java.util.function.Function;
import net.minecraft.util.IStringSerializable;

public enum ChopCountingAlgorithm implements IStringSerializable
{
    LINEAR("linear", numBlocks -> numBlocks),
    LOGARITHMIC("log", numBlocks -> (int)Math.floor(1.0 + 6.0 * ChopCountingAlgorithm.log2(1.0 + ((double)numBlocks.intValue() - 1.0) / 8.0)));

    private final String name;
    private final Function<Integer, Integer> calculation;

    private ChopCountingAlgorithm(String name, Function<Integer, Integer> calculation) {
        this.name = name;
        this.calculation = calculation;
    }

    public String toString() {
        return this.name;
    }

    public String func_176610_l() {
        return this.name;
    }

    public int calculate(int numBlocks) {
        return this.calculation.apply(numBlocks);
    }

    private static double log2(double x) {
        double invBase = 1.0 / Math.log(2.0);
        return Math.log(x) * invBase;
    }
}

