/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.common.network;

import ht.treechop.TreeChopMod;
import ht.treechop.common.capabilities.ChopSettingsCapability;
import ht.treechop.common.config.ConfigHandler;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Util;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketEnableFelling {
    private final boolean fellingEnabled;

    public PacketEnableFelling(boolean fellingEnabled) {
        this.fellingEnabled = fellingEnabled;
    }

    public static void encode(PacketEnableFelling message, PacketBuffer buffer) {
        buffer.writeBoolean(message.fellingEnabled);
    }

    public static PacketEnableFelling decode(PacketBuffer buffer) {
        return new PacketEnableFelling(buffer.readBoolean());
    }

    public static void handle(PacketEnableFelling message, Supplier<NetworkEvent.Context> context) {
        if (context.get().getDirection().getReceptionSide().isServer()) {
            context.get().enqueueWork(() -> {
                ServerPlayerEntity player = ((NetworkEvent.Context)context.get()).getSender();
                if (((Boolean)ConfigHandler.COMMON.canChooseNotToChop.get()).booleanValue()) {
                    ChopSettingsCapability chopSettings = ChopSettingsCapability.forPlayer((PlayerEntity)player);
                    chopSettings.setFellingEnabled(message.fellingEnabled);
                    player.func_145747_a(TreeChopMod.makeText("Felling " + (message.fellingEnabled ? "ON" : "OFF")), Util.field_240973_b_);
                } else {
                    player.func_145747_a(TreeChopMod.makeText("Felling ON" + TextFormatting.RED + " (you are not permitted to disable felling)"), Util.field_240973_b_);
                }
            });
            context.get().setPacketHandled(true);
        }
    }
}

