/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.common.network;

import ht.treechop.TreeChopMod;
import ht.treechop.common.capabilities.ChopSettings;
import ht.treechop.common.capabilities.ChopSettingsCapability;
import ht.treechop.common.config.ConfigHandler;
import ht.treechop.common.config.SneakBehavior;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Util;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.network.NetworkEvent;
import org.apache.commons.lang3.EnumUtils;

public class PacketSetSneakBehavior {
    private final SneakBehavior sneakBehavior;

    public PacketSetSneakBehavior(SneakBehavior sneakBehavior) {
        this.sneakBehavior = sneakBehavior;
    }

    public static void encode(PacketSetSneakBehavior message, PacketBuffer buffer) {
        buffer.func_180714_a(message.sneakBehavior.name());
    }

    public static PacketSetSneakBehavior decode(PacketBuffer buffer) {
        SneakBehavior defaultBehavior = new ChopSettings().getSneakBehavior();
        SneakBehavior sneakBehavior = (SneakBehavior)EnumUtils.getEnum(SneakBehavior.class, (String)buffer.func_150789_c(SneakBehavior.maxNameLength));
        return new PacketSetSneakBehavior(sneakBehavior != null ? sneakBehavior : defaultBehavior);
    }

    public static void handle(PacketSetSneakBehavior message, Supplier<NetworkEvent.Context> context) {
        if (context.get().getDirection().getReceptionSide().isServer()) {
            context.get().enqueueWork(() -> {
                ServerPlayerEntity player = ((NetworkEvent.Context)context.get()).getSender();
                if (((Boolean)ConfigHandler.COMMON.canChooseNotToChop.get()).booleanValue()) {
                    ChopSettingsCapability chopSettings = ChopSettingsCapability.forPlayer((PlayerEntity)player);
                    chopSettings.setSneakBehavior(message.sneakBehavior);
                    player.func_145747_a(TreeChopMod.makeText("Sneak behavior " + chopSettings.getSneakBehavior().func_176610_l()), Util.field_240973_b_);
                } else {
                    player.func_145747_a(TreeChopMod.makeText("Sneak behavior " + SneakBehavior.NONE.func_176610_l() + TextFormatting.RED + " (you are not permitted to disable chopping or felling)"), Util.field_240973_b_);
                }
            });
            context.get().setPacketHandled(true);
        }
    }
}

