/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.common.util;

import ht.treechop.TreeChopMod;
import ht.treechop.client.Client;
import ht.treechop.common.block.ChoppedLogBlock;
import ht.treechop.common.block.IChoppable;
import ht.treechop.common.capabilities.ChopSettings;
import ht.treechop.common.capabilities.ChopSettingsCapability;
import ht.treechop.common.config.ChopCountingAlgorithm;
import ht.treechop.common.config.ConfigHandler;
import ht.treechop.common.init.ModBlocks;
import ht.treechop.common.properties.BlockStateProperties;
import ht.treechop.common.properties.ChoppedLogShape;
import ht.treechop.common.util.BlockNeighbors;
import ht.treechop.common.util.ChopResult;
import ht.treechop.common.util.TreeBlock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LeavesBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;

public class ChopUtil {
    public static boolean isBlockChoppable(IWorld world, BlockPos pos, BlockState blockState) {
        return blockState.func_177230_c() instanceof IChoppable || ChopUtil.isBlockALog(blockState) && (!ChopUtil.isBlockALog(world, pos.func_177976_e()) || !ChopUtil.isBlockALog(world, pos.func_177978_c()) || !ChopUtil.isBlockALog(world, pos.func_177974_f()) || !ChopUtil.isBlockALog(world, pos.func_177968_d()));
    }

    public static boolean isBlockChoppable(IWorld world, BlockPos pos) {
        return ChopUtil.isBlockChoppable(world, pos, world.func_180495_p(pos));
    }

    public static boolean isBlockALog(BlockState blockState) {
        return blockState.func_235714_a_(ConfigHandler.blockTagForDetectingLogs);
    }

    public static boolean isBlockALog(IWorld world, BlockPos pos) {
        return ChopUtil.isBlockALog(world.func_180495_p(pos));
    }

    public static boolean isBlockLeaves(IWorld world, BlockPos pos) {
        return ChopUtil.isBlockLeaves(world.func_180495_p(pos));
    }

    public static boolean isBlockLeaves(BlockState blockState) {
        if (blockState.func_235901_b_((Property)LeavesBlock.field_208495_b) && !ConfigHandler.breakPersistentLeaves && ((Boolean)blockState.func_177229_b((Property)LeavesBlock.field_208495_b)).booleanValue()) {
            return false;
        }
        return blockState.func_177230_c().func_203417_a(ConfigHandler.blockTagForDetectingLeaves);
    }

    public static Set<BlockPos> getConnectedBlocks(Collection<BlockPos> startingPoints, Function<BlockPos, Stream<BlockPos>> searchOffsetsSupplier, int maxNumBlocks, AtomicInteger iterationCounter) {
        HashSet<BlockPos> connectedBlocks = new HashSet<BlockPos>();
        List<Object> newConnectedBlocks = new LinkedList<BlockPos>(startingPoints);
        iterationCounter.set(0);
        do {
            connectedBlocks.addAll(newConnectedBlocks);
            if (connectedBlocks.size() >= maxNumBlocks) break;
            newConnectedBlocks = newConnectedBlocks.stream().flatMap(blockPos -> ((Stream)searchOffsetsSupplier.apply((BlockPos)blockPos)).filter(pos1 -> !connectedBlocks.contains(pos1))).limit(maxNumBlocks - connectedBlocks.size()).collect(Collectors.toList());
            iterationCounter.incrementAndGet();
        } while (!newConnectedBlocks.isEmpty());
        return connectedBlocks;
    }

    public static Set<BlockPos> getConnectedBlocks(Collection<BlockPos> startingPoints, Function<BlockPos, Stream<BlockPos>> searchOffsetsSupplier, int maxNumBlocks) {
        return ChopUtil.getConnectedBlocks(startingPoints, searchOffsetsSupplier, maxNumBlocks, new AtomicInteger());
    }

    public static boolean canChangeBlock(World world, BlockPos blockPos, PlayerEntity agent) {
        return !agent.func_223729_a(world, blockPos, agent.func_184102_h().func_71265_f());
    }

    public static boolean canChangeBlock(World world, BlockPos blockPos, PlayerEntity agent, ItemStack tool) {
        return !agent.func_223729_a(world, blockPos, agent.func_184102_h().func_71265_f()) && (tool.func_190926_b() || !tool.func_77973_b().onBlockStartBreak(tool, blockPos, agent));
    }

    public static List<BlockPos> getTreeLeaves(World world, Collection<BlockPos> treeBlocks) {
        AtomicInteger iterationCounter = new AtomicInteger();
        HashSet leaves = new HashSet();
        int maxNumLeavesBlocks = (Integer)ConfigHandler.COMMON.maxNumLeavesBlocks.get();
        ChopUtil.getConnectedBlocks(treeBlocks, pos1 -> {
            BlockState blockState = world.func_180495_p(pos1);
            return (ChopUtil.isBlockLeaves(blockState) && !(blockState.func_177230_c() instanceof LeavesBlock) ? BlockNeighbors.ADJACENTS_AND_BELOW_ADJACENTS : BlockNeighbors.ADJACENTS).asStream((BlockPos)pos1).filter(pos2 -> ChopUtil.markLeavesToDestroyAndKeepLooking((IWorld)world, pos2, iterationCounter, leaves));
        }, maxNumLeavesBlocks, iterationCounter);
        if (leaves.size() >= maxNumLeavesBlocks) {
            TreeChopMod.LOGGER.warn(String.format("Max number of leaves reached: %d >= %d blocks", leaves.size(), maxNumLeavesBlocks));
        }
        return new ArrayList<BlockPos>(leaves);
    }

    private static boolean markLeavesToDestroyAndKeepLooking(IWorld world, BlockPos pos, AtomicInteger iterationCounter, Set<BlockPos> leavesToDestroy) {
        BlockState blockState = world.func_180495_p(pos);
        if (ChopUtil.isBlockLeaves(blockState)) {
            if (blockState.func_177230_c() instanceof LeavesBlock ? iterationCounter.get() + 1 > (Integer)blockState.func_177229_b((Property)LeavesBlock.field_208494_a) : iterationCounter.get() >= ConfigHandler.maxBreakLeavesDistance) {
                return false;
            }
            leavesToDestroy.add(pos);
            return true;
        }
        return false;
    }

    public static int numChopsToFell(int numBlocks) {
        return (int)((double)((ChopCountingAlgorithm)((Object)ConfigHandler.COMMON.chopCountingAlgorithm.get())).calculate(numBlocks) * (Double)ConfigHandler.COMMON.chopCountScale.get());
    }

    public static ChopResult getChopResult(World world, BlockPos blockPos, PlayerEntity agent, int numChops, boolean fellIfPossible, Predicate<BlockPos> logCondition) {
        return fellIfPossible ? ChopUtil.getChopResult(world, blockPos, agent, numChops, logCondition) : ChopUtil.tryToChopWithoutFelling(world, blockPos, numChops);
    }

    private static ChopResult getChopResult(World world, BlockPos blockPos, PlayerEntity agent, int numChops, Predicate<BlockPos> logCondition) {
        int maxNumTreeBlocks = (Integer)ConfigHandler.COMMON.maxNumTreeBlocks.get();
        AtomicBoolean hasLeaves = new AtomicBoolean(!ChopUtil.getPlayerChopSettings(agent).getTreesMustHaveLeaves());
        Set<BlockPos> supportedBlocks = ChopUtil.getConnectedBlocks(Collections.singletonList(blockPos), somePos -> BlockNeighbors.HORIZONTAL_AND_ABOVE.asStream((BlockPos)somePos).peek(pos -> hasLeaves.compareAndSet(false, ChopUtil.isBlockLeaves((IWorld)world, pos))).filter(logCondition), maxNumTreeBlocks);
        if (!hasLeaves.get()) {
            return ChopResult.IGNORED;
        }
        if (supportedBlocks.size() >= maxNumTreeBlocks) {
            TreeChopMod.LOGGER.warn(String.format("Max tree size reached: %d >= %d blocks (not including leaves)", supportedBlocks.size(), maxNumTreeBlocks));
        }
        return ChopUtil.chopTree(world, blockPos, supportedBlocks, numChops);
    }

    private static ChopResult chopTree(World world, BlockPos target, Set<BlockPos> supportedBlocks, int numChops) {
        int numChopsToFell;
        BlockState blockState = world.func_180495_p(target);
        int currentNumChops = ChopUtil.getNumChops(blockState);
        if (currentNumChops + numChops < (numChopsToFell = ChopUtil.numChopsToFell(supportedBlocks.size()))) {
            Set<BlockPos> nearbyChoppableBlocks = ChopUtil.getConnectedBlocks(Collections.singletonList(target), pos -> BlockNeighbors.ADJACENTS_AND_DIAGONALS.asStream((BlockPos)pos).filter(checkPos -> Math.abs(checkPos.func_177956_o() - target.func_177956_o()) < 4 && ChopUtil.isBlockChoppable((IWorld)world, checkPos)), 64);
            int totalNumChops = ChopUtil.getNumChops(world, nearbyChoppableBlocks) + numChops;
            if (totalNumChops >= numChopsToFell) {
                List choppedLogsSortedByY = nearbyChoppableBlocks.stream().filter(pos1 -> world.func_180495_p(pos1).func_177230_c() instanceof IChoppable).sorted(Comparator.comparingInt(Vector3i::func_177956_o)).collect(Collectors.toList());
                for (BlockPos pos2 : choppedLogsSortedByY) {
                    int chops = ChopUtil.getNumChops(world, pos2);
                    supportedBlocks.add(pos2);
                    if (chops <= numChopsToFell) continue;
                    break;
                }
            } else {
                return ChopUtil.gatherChops(world, target, numChops, nearbyChoppableBlocks);
            }
        }
        supportedBlocks.remove(target);
        return new ChopResult(world, Collections.singletonList(target), supportedBlocks);
    }

    private static ChopResult gatherChops(World world, BlockPos target, int numChops, Set<BlockPos> nearbyChoppableBlocks) {
        List sortedChoppableBlocks;
        LinkedList<TreeBlock> choppedBlocks = new LinkedList<TreeBlock>();
        int numChopsLeft = ChopUtil.gatherChopAndGetNumChopsRemaining(world, target, numChops, choppedBlocks);
        if (numChopsLeft > 0 && (sortedChoppableBlocks = nearbyChoppableBlocks.stream().filter(blockPos1 -> {
            BlockState blockState1 = world.func_180495_p(blockPos1);
            Block block1 = blockState1.func_177230_c();
            if (block1 instanceof IChoppable) {
                return ChopUtil.getNumChops(blockState1) < ChopUtil.getMaxNumChops(world, blockPos1, blockState1);
            }
            return blockPos1.func_177956_o() >= target.func_177956_o();
        }).sorted(Comparator.comparingInt(a -> ChopUtil.chopDistance(target, a))).collect(Collectors.toList())).size() > 0) {
            int nextChoiceDistance = ChopUtil.chopDistance(target, (BlockPos)sortedChoppableBlocks.get(0));
            int candidateStartIndex = 0;
            int n = sortedChoppableBlocks.size();
            for (int i = 0; i <= n; ++i) {
                BlockPos nextTarget;
                if (i != n && ChopUtil.chopDistance(target, (BlockPos)sortedChoppableBlocks.get(i)) <= nextChoiceDistance) continue;
                List candidates = sortedChoppableBlocks.subList(candidateStartIndex, i);
                Collections.shuffle(candidates);
                Iterator iterator = candidates.iterator();
                while (iterator.hasNext() && (numChopsLeft = ChopUtil.gatherChopAndGetNumChopsRemaining(world, nextTarget = (BlockPos)iterator.next(), numChopsLeft, choppedBlocks)) > 0) {
                }
                if (numChopsLeft <= 0) break;
                candidateStartIndex = i;
            }
        }
        return new ChopResult(choppedBlocks);
    }

    private static int gatherChopAndGetNumChopsRemaining(World world, BlockPos target, int numChops, List<TreeBlock> choppedBlocks) {
        BlockState blockStateAfterChopping;
        BlockState blockStateBeforeChopping = world.func_180495_p(target);
        if (blockStateBeforeChopping != (blockStateAfterChopping = ChopUtil.getBlockStateAfterChops(world, target, numChops, false))) {
            choppedBlocks.add(new TreeBlock(world, target, blockStateAfterChopping, true));
        }
        return numChops - (ChopUtil.getNumChops(blockStateAfterChopping) - ChopUtil.getNumChops(blockStateBeforeChopping));
    }

    public static BlockState getBlockStateAfterChops(World world, BlockPos blockPos, int numChops, boolean destructive) {
        BlockState blockState = world.func_180495_p(blockPos);
        Block block = blockState.func_177230_c();
        if (block instanceof IChoppable) {
            return ChopUtil.getBlockStateAfterChops((IChoppable)block, blockState, numChops, destructive);
        }
        if (ChopUtil.isBlockChoppable((IWorld)world, blockPos, blockState)) {
            IChoppable choppedBlock = ChopUtil.getChoppedBlock(blockState);
            if (choppedBlock instanceof Block) {
                ChoppedLogShape shape = ChoppedLogBlock.getPlacementShape((IWorld)world, blockPos);
                BlockState defaultChoppedState = (BlockState)((Block)choppedBlock).func_176223_P().func_206870_a(BlockStateProperties.CHOPPED_LOG_SHAPE, (Comparable)((Object)shape));
                return ChopUtil.getBlockStateAfterChops(choppedBlock, defaultChoppedState, numChops - ChopUtil.getNumChops(defaultChoppedState), destructive);
            }
            throw new IllegalArgumentException(String.format("Block \"%s\" is not choppable", block.getRegistryName()));
        }
        return blockState;
    }

    public static BlockState getBlockStateAfterChops(IChoppable choppableBlock, BlockState blockState, int numChops, boolean destructive) {
        int maxNumChops;
        int currentNumChops = ChopUtil.getNumChops(blockState);
        int newNumChops = currentNumChops + numChops;
        if (newNumChops <= (maxNumChops = choppableBlock.getMaxNumChops())) {
            return choppableBlock.withChops(blockState, newNumChops);
        }
        return destructive ? Blocks.field_150350_a.func_176223_P() : choppableBlock.withChops(blockState, maxNumChops);
    }

    public static int getMaxNumChops(World world, BlockPos blockPos, BlockState blockState) {
        Block block = blockState.func_177230_c();
        if (block instanceof IChoppable) {
            return ((IChoppable)block).getMaxNumChops();
        }
        if (ChopUtil.isBlockChoppable((IWorld)world, blockPos, world.func_180495_p(blockPos))) {
            IChoppable choppedBlock = ChopUtil.getChoppedBlock(blockState);
            return choppedBlock != null ? choppedBlock.getMaxNumChops() : 0;
        }
        return 0;
    }

    public static IChoppable getChoppedBlock(BlockState blockState) {
        if (ChopUtil.isBlockALog(blockState)) {
            return (IChoppable)(blockState.func_177230_c() instanceof IChoppable ? blockState.func_177230_c() : (Block)ModBlocks.CHOPPED_LOG.get());
        }
        return null;
    }

    public static int getNumChops(World world, BlockPos pos) {
        return ChopUtil.getNumChops(world.func_180495_p(pos));
    }

    public static int getNumChops(BlockState blockState) {
        Block block = blockState.func_177230_c();
        return block instanceof IChoppable ? ((IChoppable)block).getNumChops(blockState) : 0;
    }

    public static int getNumChops(World world, Set<BlockPos> positions) {
        return positions.stream().map(arg_0 -> ((World)world).func_180495_p(arg_0)).map(blockState1 -> blockState1.func_177230_c() instanceof IChoppable ? ((IChoppable)blockState1.func_177230_c()).getNumChops((BlockState)blockState1) : 0).reduce(Integer::sum).orElse(0);
    }

    private static ChopResult tryToChopWithoutFelling(World world, BlockPos blockPos, int numChops) {
        return ChopUtil.isBlockChoppable((IWorld)world, blockPos) ? new ChopResult(Collections.singletonList(new TreeBlock(world, blockPos, ChopUtil.getBlockStateAfterChops(world, blockPos, numChops, true), true)), false) : ChopResult.IGNORED;
    }

    public static int chopDistance(BlockPos a, BlockPos b) {
        return a.func_218139_n((Vector3i)b);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean canChopWithTool(ItemStack tool) {
        if (ConfigHandler.choppingToolItemsBlacklist.contains(tool.func_77973_b().getRegistryName())) return false;
        if (tool.func_77973_b().getTags().stream().anyMatch(ConfigHandler.choppingToolTagsBlacklist::contains)) return false;
        return true;
    }

    public static int getNumChopsByTool(ItemStack tool) {
        return 1;
    }

    public static boolean playerWantsToChop(PlayerEntity player) {
        if (((Boolean)ConfigHandler.COMMON.canChooseNotToChop.get()).booleanValue()) {
            ChopSettings chopSettings = ChopUtil.getPlayerChopSettings(player);
            if (!player.func_184812_l_() || chopSettings.getChopInCreativeMode()) {
                return chopSettings.getChoppingEnabled() ^ chopSettings.getSneakBehavior().shouldChangeChopBehavior((Entity)player);
            }
            return chopSettings.getSneakBehavior().shouldChangeChopBehavior((Entity)player);
        }
        return true;
    }

    public static boolean playerWantsToFell(PlayerEntity player) {
        ChopSettings chopSettings = ChopUtil.getPlayerChopSettings(player);
        if (((Boolean)ConfigHandler.COMMON.canChooseNotToChop.get()).booleanValue()) {
            return chopSettings.getFellingEnabled() ^ chopSettings.getSneakBehavior().shouldChangeFellBehavior((Entity)player);
        }
        return true;
    }

    private static boolean isLocalPlayer(PlayerEntity player) {
        return !player.func_70613_aW() && Minecraft.func_71410_x().field_71439_g == player;
    }

    public static ChopSettings getPlayerChopSettings(PlayerEntity player) {
        return ChopUtil.isLocalPlayer(player) ? Client.getChopSettings() : (ChopSettings)player.getCapability(ChopSettingsCapability.CAPABILITY).orElseThrow(() -> new IllegalArgumentException("LazyOptional must not be empty"));
    }

    public static void doItemDamage(ItemStack itemStack, World world, BlockState blockState, BlockPos blockPos, PlayerEntity agent) {
        ItemStack mockItemStack = itemStack.func_77946_l();
        itemStack.func_179548_a(world, blockState, blockPos, agent);
        if (itemStack.func_190926_b() && !mockItemStack.func_190926_b()) {
            ForgeEventFactory.onPlayerDestroyItem((PlayerEntity)agent, (ItemStack)mockItemStack, (Hand)Hand.MAIN_HAND);
        }
    }

    public static void dropExperience(World world, BlockPos blockPos, int amount) {
        if (world instanceof ServerWorld) {
            Blocks.field_150350_a.func_180637_b((ServerWorld)world, blockPos, amount);
        }
    }
}

