/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.api;

import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;

public class ChopEvent
extends Event {
    private final Level level;
    private final Player player;
    private final BlockPos choppedBlockPos;
    private final BlockState choppedBlockState;

    public ChopEvent(Level level, Player player, BlockPos choppedBlockPos, BlockState choppedBlockState) {
        this.level = level;
        this.player = player;
        this.choppedBlockPos = choppedBlockPos;
        this.choppedBlockState = choppedBlockState;
    }

    public Level getWorld() {
        return this.level;
    }

    public Player getPlayer() {
        return this.player;
    }

    public BlockPos getChoppedBlockPos() {
        return this.choppedBlockPos;
    }

    public BlockState getChoppedBlockState() {
        return this.choppedBlockState;
    }

    public static class FinishChopEvent
    extends ChopEvent {
        public FinishChopEvent(Level level, Player player, BlockPos choppedBlockPos, BlockState choppedBlockState) {
            super(level, player, choppedBlockPos, choppedBlockState);
        }
    }

    @Cancelable
    public static class StartChopEvent
    extends ChopEvent {
        private BlockEvent.BreakEvent breakEvent;
        private int numChops;
        private boolean felling;

        public StartChopEvent(BlockEvent.BreakEvent breakEvent, Level level, ServerPlayer player, BlockPos choppedBlockPos, BlockState choppedBlockState, int numChops, boolean felling) {
            super(level, (Player)player, choppedBlockPos, choppedBlockState);
            this.breakEvent = breakEvent;
            this.numChops = numChops;
            this.felling = felling;
        }

        public BlockEvent.BreakEvent getBreakEvent() {
            return this.breakEvent;
        }

        public int getNumChops() {
            return this.numChops;
        }

        public boolean getFelling() {
            return this.felling;
        }

        public void setNumChops(int numChops) {
            this.numChops = numChops;
        }

        public void setFelling(boolean felling) {
            this.felling = felling;
        }
    }

    @Cancelable
    public static class DetectTreeEvent
    extends ChopEvent {
        private final AtomicBoolean hasLeaves;
        private final AtomicBoolean overrideHasLeaves;

        public DetectTreeEvent(Level level, Player player, BlockPos choppedBlockPos, BlockState choppedBlockState, AtomicBoolean hasLeaves, AtomicBoolean overrideHasLeaves) {
            super(level, player, choppedBlockPos, choppedBlockState);
            this.overrideHasLeaves = overrideHasLeaves;
            this.hasLeaves = hasLeaves;
        }

        public void overrideTreeHasLeaves(boolean hasLeaves) {
            this.hasLeaves.set(hasLeaves);
            this.overrideHasLeaves.set(true);
        }
    }
}

