/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.client;

import com.mojang.blaze3d.platform.InputConstants;
import ht.treechop.client.Client;
import ht.treechop.client.gui.screen.ClientSettingsScreen;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.fmlclient.registry.ClientRegistry;

public class KeyBindings {
    public static final String CATEGORY = "HT's TreeChop";
    public static final List<ActionableKeyBinding> allKeyBindings = new LinkedList<ActionableKeyBinding>();

    public static void init() {
        KeyBindings.registerKeyBinding("toggle_chopping", KeyBindings.getKey(-1), Client::toggleChopping);
        KeyBindings.registerKeyBinding("toggle_felling", KeyBindings.getKey(-1), Client::toggleFelling);
        KeyBindings.registerKeyBinding("cycle_sneak_behavior", KeyBindings.getKey(-1), Client::cycleSneakBehavior);
        KeyBindings.registerKeyBinding("open_settings_overlay", KeyBindings.getKey(78), Client::toggleSettingsOverlay);
    }

    private static ActionableKeyBinding registerKeyBinding(String name, InputConstants.Key defaultKey, Runnable callback) {
        ActionableKeyBinding keyBinding = new ActionableKeyBinding(String.format("%s.key.%s", "treechop", name), defaultKey, callback);
        ClientRegistry.registerKeyBinding((KeyMapping)keyBinding);
        allKeyBindings.add(keyBinding);
        return keyBinding;
    }

    static InputConstants.Key getKey(int key) {
        return InputConstants.m_84827_((int)key, (int)0);
    }

    public static void buttonPressed(int keyCode, int keyState) {
        for (ActionableKeyBinding keyBinding : allKeyBindings) {
            if (keyCode != keyBinding.getKey().m_84873_() || keyState != 1) continue;
            keyBinding.onPress();
            return;
        }
    }

    protected static class ActionableKeyBinding
    extends KeyMapping {
        private final Runnable callback = () -> {
            Screen screen = Minecraft.m_91087_().f_91080_;
            if (screen == null || screen instanceof ClientSettingsScreen) {
                callback.run();
            }
        };

        public ActionableKeyBinding(String resourceName, InputConstants.Key inputByCode, Runnable callback) {
            super(resourceName, (IKeyConflictContext)KeyConflictContext.GUI, inputByCode, KeyBindings.CATEGORY);
        }

        public void onPress() {
            this.callback.run();
        }
    }
}

