/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.client.gui.element;

import com.mojang.blaze3d.vertex.PoseStack;
import ht.treechop.client.gui.element.NestedGui;
import ht.treechop.client.gui.util.GUIUtil;
import ht.treechop.client.gui.widget.StickyWidget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;

public class ExclusiveButtonsGui
extends NestedGui {
    private final List<AbstractWidget> widgets;
    private final Supplier<Component> tooltipSupplier;

    protected ExclusiveButtonsGui(Collection<AbstractWidget> widgets, Supplier<Component> tooltipSupplier) {
        super(0, 0, 0, 0, TextComponent.f_131282_);
        this.widgets = new ArrayList<AbstractWidget>(widgets);
        this.tooltipSupplier = tooltipSupplier;
    }

    @Override
    public void expand(int width) {
        if (this.getMinimumWidth() < width) {
            int targetWidth = width / this.widgets.size();
            List smallerWidgets = this.widgets.stream().filter(widget -> widget.m_5711_() <= targetWidth).collect(Collectors.toList());
            List biggerWidgets = this.widgets.stream().filter(widget -> widget.m_5711_() > targetWidth).collect(Collectors.toList());
            int totalWidthForSmallers = width - biggerWidgets.stream().map(AbstractWidget::m_5711_).reduce(Integer::sum).orElse(0);
            int i = 0;
            for (AbstractWidget widget2 : smallerWidgets) {
                double lower = (double)i / (double)smallerWidgets.size();
                double upper = (double)(i + 1) / (double)smallerWidgets.size();
                int widgetWidth = (int)((double)totalWidthForSmallers * (upper - lower));
                widget2.m_93674_(widgetWidth);
                ++i;
            }
        }
    }

    public List<? extends GuiEventListener> m_6702_() {
        return this.widgets;
    }

    @Override
    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        int x = this.getBox().getLeft();
        int y = this.getBox().getTop();
        int maxX = x;
        int maxY = y;
        for (AbstractWidget widget : this.widgets) {
            widget.f_93620_ = maxX;
            widget.f_93621_ = y;
            widget.m_6305_(poseStack, mouseX, mouseY, partialTicks);
            maxX = Math.max(maxX, maxX + widget.m_5711_());
            maxY = Math.max(maxY, y + widget.m_93694_());
        }
        boolean bl = this.f_93622_ = mouseX >= x && mouseY >= y && mouseX < maxX && mouseY < maxY;
        if (this.m_5702_()) {
            GUIUtil.showTooltip(mouseX, mouseY, this.tooltipSupplier.get());
        }
    }

    @Override
    public int getMinimumWidth() {
        return this.widgets.stream().map(AbstractWidget::m_5711_).reduce(Integer::sum).orElse(0);
    }

    @Override
    public int getMinimumHeight() {
        return this.widgets.stream().map(AbstractWidget::m_93694_).reduce(Integer::max).orElse(0);
    }

    public void m_142291_(NarrationElementOutput out) {
    }

    public static class Builder {
        private final List<Option> options = new LinkedList<Option>();

        public Builder add(Component name, Runnable onPress, Supplier<StickyWidget.State> stateSupplier) {
            this.options.add(new Option(name, onPress, stateSupplier));
            return this;
        }

        public ExclusiveButtonsGui build(Supplier<Component> tooltipSupplier) {
            List<AbstractWidget> widgets = this.options.stream().map(option -> new StickyWidget(0, 0, 0, 0, option.name, option.onPress, option.stateSupplier)).collect(Collectors.toList());
            return new ExclusiveButtonsGui(widgets, tooltipSupplier);
        }

        private static class Option {
            private final Component name;
            private final Runnable onPress;
            private final Supplier<StickyWidget.State> stateSupplier;

            public Option(Component name, Runnable onPress, Supplier<StickyWidget.State> stateSupplier) {
                this.name = name;
                this.onPress = onPress;
                this.stateSupplier = stateSupplier;
            }
        }
    }
}

