/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.client.model;

import ht.treechop.TreeChopMod;
import ht.treechop.client.model.ModelUtil;
import ht.treechop.common.block.ChoppedLogBlock;
import ht.treechop.common.config.ConfigHandler;
import ht.treechop.common.init.ModBlocks;
import ht.treechop.common.properties.ChoppedLogShape;
import ht.treechop.common.properties.ModBlockStateProperties;
import ht.treechop.common.util.FaceShape;
import ht.treechop.common.util.Vector3;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;
import org.apache.commons.lang3.tuple.Triple;

public class ChoppedLogBakedModel
implements IDynamicBakedModel {
    public static ModelProperty<Set<Direction>> SOLID_SIDES = new ModelProperty();
    public static ModelProperty<BlockState> STRIPPED_BLOCK_STATE = new ModelProperty();
    private final BakedModel staticModel;
    private final ResourceLocation defaultTextureRL = new ResourceLocation("treechop:block/chopped_log");
    private final TextureAtlasSprite defaultSprite;
    private final boolean removeBarkOnInteriorLogs;

    public ChoppedLogBakedModel(BakedModel staticModel, boolean removeBarkOnInteriorLogs) {
        this.staticModel = staticModel;
        this.removeBarkOnInteriorLogs = removeBarkOnInteriorLogs;
        this.defaultSprite = Minecraft.m_91087_().m_91304_().m_119428_(TextureAtlas.f_118259_).m_118316_(this.defaultTextureRL);
    }

    public static void overrideBlockStateModels(ModelBakeEvent event) {
        for (BlockState blockState : ((Block)ModBlocks.CHOPPED_LOG.get()).m_49965_().m_61056_()) {
            ModelResourceLocation variantMRL = BlockModelShaper.m_110895_((BlockState)blockState);
            BakedModel existingModel = (BakedModel)event.getModelRegistry().get(variantMRL);
            if (existingModel == null) {
                TreeChopMod.LOGGER.warn("Did not find the expected vanilla baked model(s) for treechop:chopped_log in registry");
                continue;
            }
            if (existingModel instanceof ChoppedLogBakedModel) {
                TreeChopMod.LOGGER.warn("Tried to replace ChoppedLogBakedModel twice");
                continue;
            }
            ChoppedLogBakedModel customModel = new ChoppedLogBakedModel(existingModel, (Boolean)ConfigHandler.CLIENT.removeBarkOnInteriorLogs.get());
            event.getModelRegistry().put(variantMRL, customModel);
        }
    }

    @Nonnull
    public IModelData getModelData(@Nonnull BlockAndTintGetter level, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull IModelData tileData) {
        BlockState strippedState;
        if (!state.m_61138_(ModBlockStateProperties.CHOPPED_LOG_SHAPE) || !state.m_61138_((Property)ModBlockStateProperties.CHOP_COUNT)) {
            throw new IllegalArgumentException(String.format("Could not bake chopped log model; block state %s is missing \"%s\" or \"%s\"", state, ModBlockStateProperties.CHOPPED_LOG_SHAPE.m_61708_(), ModBlockStateProperties.CHOP_COUNT.m_61708_()));
        }
        ChoppedLogShape shape = (ChoppedLogShape)((Object)state.m_61143_(ModBlockStateProperties.CHOPPED_LOG_SHAPE));
        Set solidSides = this.removeBarkOnInteriorLogs ? (Set)Arrays.stream(Direction.values()).filter(direction -> direction.m_122434_().m_122479_() && !shape.isSideOpen((Direction)direction)).filter(direction -> {
            BlockState blockState = level.m_8055_(pos.m_142300_(direction));
            Block block = blockState.m_60734_();
            return blockState.m_60804_((BlockGetter)level, pos) && !(block instanceof ChoppedLogBlock);
        }).collect(Collectors.toCollection(() -> EnumSet.noneOf(Direction.class))) : Collections.emptySet();
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof ChoppedLogBlock.Entity) {
            ChoppedLogBlock.Entity entity = (ChoppedLogBlock.Entity)blockEntity;
            strippedState = entity.getStrippedOriginalState();
        } else {
            strippedState = Blocks.f_49999_.m_49966_();
        }
        ModelDataMap.Builder builder = new ModelDataMap.Builder();
        builder.withInitial(SOLID_SIDES, (Object)solidSides);
        builder.withInitial(STRIPPED_BLOCK_STATE, (Object)strippedState);
        return builder.build();
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        if (side == null) {
            AABB box;
            Set solidSides;
            BlockState strippedState = extraData.hasProperty(STRIPPED_BLOCK_STATE) ? (BlockState)extraData.getData(STRIPPED_BLOCK_STATE) : Blocks.f_50010_.m_49966_();
            Set set = solidSides = extraData.hasProperty(SOLID_SIDES) ? (Set)extraData.getData(SOLID_SIDES) : Collections.emptySet();
            if (state != null) {
                int chops = (Integer)state.m_61143_((Property)ModBlockStateProperties.CHOP_COUNT);
                ChoppedLogShape shape = (ChoppedLogShape)((Object)state.m_61143_(ModBlockStateProperties.CHOPPED_LOG_SHAPE));
                box = shape.getBoundingBox(chops);
            } else {
                box = Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0).m_83215_();
            }
            float downY = (float)box.f_82289_;
            float upY = (float)box.f_82292_;
            float northZ = (float)box.f_82290_;
            float southZ = (float)box.f_82293_;
            float westX = (float)box.f_82288_;
            float eastX = (float)box.f_82291_;
            Vector3 topNorthEast = new Vector3(eastX, upY, northZ);
            Vector3 topNorthWest = new Vector3(westX, upY, northZ);
            Vector3 topSouthEast = new Vector3(eastX, upY, southZ);
            Vector3 topSouthWest = new Vector3(westX, upY, southZ);
            Vector3 bottomNorthEast = new Vector3(eastX, downY, northZ);
            Vector3 bottomNorthWest = new Vector3(westX, downY, northZ);
            Vector3 bottomSouthEast = new Vector3(eastX, downY, southZ);
            Vector3 bottomSouthWest = new Vector3(westX, downY, southZ);
            return Stream.concat(Stream.of(Triple.of((Object)bottomSouthEast, (Object)bottomNorthWest, (Object)Direction.DOWN), Triple.of((Object)topSouthEast, (Object)topNorthWest, (Object)Direction.UP), Triple.of((Object)topNorthEast, (Object)bottomNorthWest, (Object)Direction.NORTH), Triple.of((Object)topSouthEast, (Object)bottomSouthWest, (Object)Direction.SOUTH), Triple.of((Object)topSouthWest, (Object)bottomNorthWest, (Object)Direction.WEST), Triple.of((Object)topSouthEast, (Object)bottomNorthEast, (Object)Direction.EAST)).map(triple -> ModelUtil.makeQuad(this.getSpriteForBlockSide(strippedState, (Direction)triple.getRight(), rand, extraData), (Vector3)triple.getLeft(), (Vector3)triple.getMiddle(), (Direction)triple.getRight(), null)), solidSides.stream().map(direction -> ModelUtil.makeQuad(this.getSpriteForBlockSide(strippedState, direction.m_122424_(), rand, extraData), FaceShape.get(direction), direction.m_122424_(), null))).filter(Objects::nonNull).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private TextureAtlasSprite getSpriteForBlockSide(BlockState blockState, Direction side, Random rand, IModelData extraData) {
        ModelResourceLocation modelLocation = BlockModelShaper.m_110895_((BlockState)blockState);
        return Minecraft.m_91087_().m_91304_().getModel((ResourceLocation)modelLocation).getQuads(blockState, side, rand, (IModelData)EmptyModelData.INSTANCE).stream().filter(Objects::nonNull).findFirst().map(BakedQuad::m_173410_).orElse(this.defaultSprite);
    }

    public boolean m_7541_() {
        return this.staticModel.m_7541_();
    }

    public boolean m_7539_() {
        return this.staticModel.m_7539_();
    }

    public boolean m_7547_() {
        return this.staticModel.m_7547_();
    }

    public boolean m_7521_() {
        return this.staticModel.m_7521_();
    }

    public TextureAtlasSprite m_6160_() {
        return this.staticModel.m_6160_();
    }

    public TextureAtlasSprite getParticleIcon(IModelData data) {
        BlockState strippedState = (BlockState)data.getData(STRIPPED_BLOCK_STATE);
        if (strippedState != null) {
            return Minecraft.m_91087_().m_91304_().m_119422_(BlockModelShaper.m_110895_((BlockState)strippedState)).getParticleIcon(data);
        }
        return this.m_6160_();
    }

    public ItemOverrides m_7343_() {
        return null;
    }
}

