/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.common;

import ht.treechop.api.ChopEvent;
import ht.treechop.common.capabilities.ChopSettingsCapability;
import ht.treechop.common.capabilities.ChopSettingsProvider;
import ht.treechop.common.config.ConfigHandler;
import ht.treechop.common.network.PacketHandler;
import ht.treechop.common.util.ChopResult;
import ht.treechop.common.util.ChopUtil;
import ht.treechop.common.util.FauxPlayerInteractionManager;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;

@Mod.EventBusSubscriber(modid="treechop", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class Common {
    public static void onCommonSetup(FMLCommonSetupEvent event) {
        PacketHandler.init();
    }

    @SubscribeEvent
    public static void onTagsUpdated(TagsUpdatedEvent event) {
        ConfigHandler.updateTags(event.getTagManager());
    }

    @SubscribeEvent
    public static void onBreakEvent(BlockEvent.BreakEvent event) {
        ServerPlayer agent;
        ServerLevel level;
        BlockPos pos;
        BlockState blockState;
        ItemStack tool;
        block10: {
            block9: {
                LevelAccessor levelAccessor;
                tool = event.getPlayer().m_21205_();
                blockState = event.getState();
                pos = event.getPos();
                if (!ChopUtil.isBlockALog(blockState) || !((Boolean)ConfigHandler.COMMON.enabled.get()).booleanValue() || event.isCanceled() || !((levelAccessor = event.getWorld()) instanceof ServerLevel)) break block9;
                level = (ServerLevel)levelAccessor;
                levelAccessor = event.getPlayer();
                if (levelAccessor instanceof ServerPlayer && blockState.canHarvestBlock((BlockGetter)level, pos, (Player)(agent = (ServerPlayer)levelAccessor)) && ChopUtil.canChopWithTool(tool)) break block10;
            }
            return;
        }
        if (!ChopUtil.playerWantsToChop((Player)agent)) {
            if (ConfigHandler.shouldOverrideItemBehavior(tool.m_41720_(), false)) {
                FauxPlayerInteractionManager.harvestBlockSkippingOnBlockStartBreak(agent, level, blockState, pos, event.getExpToDrop());
                event.setCanceled(true);
            }
            return;
        }
        ChopEvent.StartChopEvent startChopEvent = new ChopEvent.StartChopEvent(event, (Level)level, agent, pos, blockState, ChopUtil.getNumChopsByTool(tool, blockState), ChopUtil.playerWantsToFell((Player)agent));
        boolean canceled = MinecraftForge.EVENT_BUS.post((Event)startChopEvent);
        if (canceled) {
            return;
        }
        ChopResult chopResult = ChopUtil.getChopResult((Level)level, pos, (Player)agent, startChopEvent.getNumChops(), startChopEvent.getFelling(), logPos -> ChopUtil.isBlockALog((Level)level, logPos));
        if (chopResult != ChopResult.IGNORED) {
            if (chopResult.apply(pos, agent, tool, (Boolean)ConfigHandler.COMMON.breakLeaves.get())) {
                event.setCanceled(true);
                if (!agent.m_7500_()) {
                    ChopUtil.doItemDamage(tool, (Level)level, blockState, pos, (Player)agent);
                }
            }
            MinecraftForge.EVENT_BUS.post((Event)new ChopEvent.FinishChopEvent((Level)level, (Player)agent, pos, blockState));
        }
    }

    @SubscribeEvent
    public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        ResourceLocation loc = new ResourceLocation("treechopchop_settings_capability");
        Entity entity = (Entity)event.getObject();
        if (entity instanceof FakePlayer) {
            event.addCapability(loc, (ICapabilityProvider)new ChopSettingsProvider(ConfigHandler.fakePlayerChopSettings));
        } else {
            event.addCapability(loc, (ICapabilityProvider)new ChopSettingsProvider());
        }
    }

    @SubscribeEvent
    public void registerCaps(RegisterCapabilitiesEvent event) {
        event.register(ChopSettingsCapability.class);
    }
}

