/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.common.block;

import ht.treechop.api.IChoppableBlock;
import ht.treechop.common.block.BlockImitator;
import ht.treechop.common.config.ConfigHandler;
import ht.treechop.common.init.ModBlocks;
import ht.treechop.common.properties.ChoppedLogShape;
import ht.treechop.common.properties.ModBlockStateProperties;
import ht.treechop.common.util.ChopUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.common.util.FakePlayerFactory;

public class ChoppedLogBlock
extends BlockImitator
implements IChoppableBlock,
EntityBlock,
SimpleWaterloggedBlock {
    public static final IntegerProperty CHOPS = ModBlockStateProperties.CHOP_COUNT;
    public static final EnumProperty<ChoppedLogShape> SHAPE = ModBlockStateProperties.CHOPPED_LOG_SHAPE;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;

    public ChoppedLogBlock(BlockBehaviour.Properties properties) {
        super(properties.m_60988_().m_60971_((blockState, level, pos) -> false));
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)CHOPS, (Comparable)Integer.valueOf(1))).m_61124_(SHAPE, (Comparable)((Object)ChoppedLogShape.PILLAR_Y))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    @Override
    public BlockState getImitatedBlockState(BlockGetter level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof Entity) {
            Entity entity = (Entity)blockEntity;
            return entity.getOriginalState();
        }
        return Blocks.f_49999_.m_49966_();
    }

    public static ChoppedLogShape getPlacementShape(Level level, BlockPos blockPos) {
        boolean DOWN = true;
        int UP = 2;
        int NORTH = 4;
        int SOUTH = 8;
        int WEST = 16;
        int EAST = 32;
        byte openSides = (byte)((ChoppedLogBlock.isBlockOpen(level, blockPos.m_7495_()) ? 1 : 0) | (!ChopUtil.isBlockALog(level, blockPos.m_7494_()) ? 2 : 0) | (!ChopUtil.isBlockALog(level, blockPos.m_142127_()) ? 4 : 0) | (!ChopUtil.isBlockALog(level, blockPos.m_142128_()) ? 8 : 0) | (!ChopUtil.isBlockALog(level, blockPos.m_142125_()) ? 16 : 0) | (!ChopUtil.isBlockALog(level, blockPos.m_142126_()) ? 32 : 0));
        return ChoppedLogShape.forOpenSides(openSides);
    }

    private static boolean isBlockOpen(Level level, BlockPos pos) {
        return level.m_46859_(pos) || ChopUtil.isBlockLeaves(level, pos);
    }

    public boolean m_49967_() {
        return true;
    }

    @Nonnull
    public VoxelShape m_5940_(BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        double scale = 0.0625;
        int chops = (Integer)state.m_61143_((Property)CHOPS);
        AABB box = ((ChoppedLogShape)((Object)state.m_61143_(SHAPE))).getBoundingBox(chops);
        return Shapes.m_83048_((double)(box.f_82288_ * scale), (double)(box.f_82289_ * scale), (double)(box.f_82290_ * scale), (double)(box.f_82291_ * scale), (double)(box.f_82292_ * scale), (double)(box.f_82293_ * scale));
    }

    @Nonnull
    public VoxelShape m_7952_(BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos) {
        return ((ChoppedLogShape)((Object)state.m_61143_(SHAPE))).getOcclusionShape();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{CHOPS, SHAPE, WATERLOGGED});
    }

    @Override
    public int getNumChops(Level level, BlockPos pos, BlockState blockState) {
        return blockState.m_60713_((Block)this) ? (Integer)blockState.m_61143_((Property)CHOPS) : 0;
    }

    @Override
    public int getMaxNumChops(Level level, BlockPos blockPos, BlockState blockState) {
        return 7;
    }

    public BlockEntity m_142194_(@Nonnull BlockPos pos, @Nonnull BlockState blockState) {
        return new Entity(pos, blockState);
    }

    @Override
    public void chop(Player player, ItemStack tool, Level level, BlockPos pos, BlockState blockState, int numChops, boolean felling) {
        int currentNumChops = blockState.m_60713_((Block)this) ? this.getNumChops(level, pos, blockState) : 0;
        int newNumChops = Math.min(currentNumChops + numChops, ChopUtil.getMaxNumChops(level, pos, blockState));
        int numAddedChops = newNumChops - currentNumChops;
        Level level2 = level;
        if (level2 instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level2;
            for (int i = 0; i < numAddedChops; ++i) {
                ChoppedLogBlock.m_49874_((BlockState)this.m_49966_(), (ServerLevel)serverLevel, (BlockPos)pos, null, (net.minecraft.world.entity.Entity)player, (ItemStack)tool).forEach(stack -> ChoppedLogBlock.m_49840_((Level)serverLevel, (BlockPos)pos, (ItemStack)stack));
            }
        }
        if (!felling) {
            if (numAddedChops > 0) {
                BlockEntity blockEntity;
                BlockState newBlockState = (BlockState)(blockState.m_60713_((Block)this) ? blockState : this.getPlacementState(level, pos)).m_61124_((Property)CHOPS, (Comparable)Integer.valueOf(newNumChops));
                if (level.m_7731_(pos, newBlockState, 3) && !blockState.m_60713_((Block)this) && (blockEntity = level.m_7702_(pos)) instanceof Entity) {
                    Entity entity = (Entity)blockEntity;
                    blockEntity = level;
                    if (blockEntity instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)blockEntity;
                        BlockState strippedBlockState = blockState.getToolModifiedState(level, pos, (Player)FakePlayerFactory.getMinecraft((ServerLevel)serverLevel), Items.f_42391_.m_7968_(), ToolActions.AXE_STRIP);
                        if (strippedBlockState == null) {
                            strippedBlockState = AxeAccessor.isStrippedLog(blockState.m_60734_()) ? blockState : Blocks.f_50010_.m_49966_();
                        }
                        entity.setOriginalState(blockState, strippedBlockState);
                        List drops = Block.m_49874_((BlockState)blockState, (ServerLevel)serverLevel, (BlockPos)pos, (BlockEntity)entity, (net.minecraft.world.entity.Entity)player, (ItemStack)tool);
                        entity.setDrops(drops);
                        entity.m_6596_();
                    }
                }
            } else {
                level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
            }
        }
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return this.getPlacementState(context.m_43725_(), context.m_8083_());
    }

    private BlockState getPlacementState(Level level, BlockPos pos) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_(SHAPE, (Comparable)((Object)ChoppedLogBlock.getPlacementShape(level, pos)))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(this.shouldPlaceAsWaterlogged(level, pos)));
    }

    private boolean shouldPlaceAsWaterlogged(Level level, BlockPos pos) {
        Direction[] waterSourceDirections = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST, Direction.UP};
        return Arrays.stream(waterSourceDirections).filter(direction -> level.m_6425_(pos.m_141952_(direction.m_122436_())).m_76170_()).limit(2L).count() == 2L;
    }

    public FluidState m_5888_(BlockState blockState) {
        return (Boolean)blockState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(blockState);
    }

    public BlockState m_7417_(BlockState blockState, Direction side, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)blockState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_6217_().m_5945_(pos, (Object)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(blockState, side, neighborState, level, pos, neighborPos);
    }

    public boolean m_7420_(BlockState blockState, BlockGetter level, BlockPos pos) {
        return (Boolean)blockState.m_61143_((Property)WATERLOGGED) == false;
    }

    @Nonnull
    public List<ItemStack> m_7381_(@Nonnull BlockState blockState, LootContext.Builder context) {
        Object object;
        if (((Boolean)ConfigHandler.COMMON.dropLootForChoppedBlocks.get()).booleanValue() && (object = context.m_78982_(LootContextParams.f_81462_)) instanceof Entity) {
            Entity entity = (Entity)((Object)object);
            return entity.drops;
        }
        return Collections.emptyList();
    }

    @Override
    public float m_5880_(BlockState blockState, Player player, BlockGetter level, BlockPos pos) {
        return (float)Math.min(0.35, (double)this.getImitatedBlockState(level, pos).m_60625_(player, level, pos));
    }

    public static class Entity
    extends BlockEntity {
        private BlockState originalState = Blocks.f_49999_.m_49966_();
        private BlockState strippedOriginalState = Blocks.f_50010_.m_49966_();
        private List<ItemStack> drops = Collections.emptyList();

        public Entity(BlockPos pos, BlockState blockState) {
            super((BlockEntityType)ModBlocks.CHOPPED_LOG_ENTITY.get(), pos, blockState);
        }

        public void setOriginalState(BlockState originalState, BlockState strippedOriginalState) {
            this.originalState = originalState;
            this.strippedOriginalState = strippedOriginalState;
        }

        public void setDrops(List<ItemStack> drops) {
            this.drops = drops;
        }

        public BlockState getOriginalState() {
            return this.originalState;
        }

        public BlockState getStrippedOriginalState() {
            return this.strippedOriginalState;
        }

        @Nonnull
        public CompoundTag m_6945_(@Nonnull CompoundTag tag) {
            super.m_6945_(tag);
            tag.m_128405_("OriginalState", Block.m_49956_((BlockState)this.getOriginalState()));
            tag.m_128405_("StrippedOriginalState", Block.m_49956_((BlockState)this.getStrippedOriginalState()));
            ListTag list = new ListTag();
            this.drops.stream().map(stack -> stack.m_41739_(new CompoundTag())).forEach(arg_0 -> list.add(arg_0));
            tag.m_128365_("Drops", (Tag)list);
            return tag;
        }

        public void m_142466_(@Nonnull CompoundTag tag) {
            super.m_142466_(tag);
            int stateId = tag.m_128451_("OriginalState");
            int strippedStateId = tag.m_128451_("StrippedOriginalState");
            this.setOriginalState(stateId > 0 ? Block.m_49803_((int)stateId) : Blocks.f_49999_.m_49966_(), strippedStateId > 0 ? Block.m_49803_((int)strippedStateId) : Blocks.f_50010_.m_49966_());
            ListTag list = tag.m_128437_("Drops", 10);
            this.drops = new LinkedList<ItemStack>();
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag item = list.m_128728_(i);
                this.drops.add(ItemStack.m_41712_((CompoundTag)item));
            }
        }

        @Nonnull
        public CompoundTag m_5995_() {
            CompoundTag tag = new CompoundTag();
            this.m_6945_(tag);
            return tag;
        }

        public void onDataPacket(Connection connection, ClientboundBlockEntityDataPacket packet) {
            this.m_142466_(packet.m_131708_());
        }

        public ClientboundBlockEntityDataPacket m_7033_() {
            return new ClientboundBlockEntityDataPacket(this.m_58899_(), 0, this.m_5995_());
        }
    }

    private static abstract class AxeAccessor
    extends AxeItem {
        public AxeAccessor(Tier p_40521_, float p_40522_, float p_40523_, Item.Properties p_40524_) {
            super(p_40521_, p_40522_, p_40523_, p_40524_);
        }

        public static boolean isStrippedLog(Block block) {
            return f_150683_.containsValue(block);
        }
    }
}

