/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.common.util;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class WorldBlock {
    private final Level level;
    private final BlockPos pos;
    private final BlockState state;
    private final BlockEntity tileEntity;

    public WorldBlock(Level level, BlockPos pos, BlockState state, BlockEntity tileEntity) {
        this.level = level;
        this.pos = pos;
        this.state = state;
        this.tileEntity = tileEntity;
    }

    public WorldBlock(Level level, BlockPos pos, BlockState state) {
        this(level, pos, state, null);
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public BlockState getState() {
        return this.state;
    }

    public BlockEntity getTileEntity() {
        return this.tileEntity;
    }

    public Level getWorld() {
        return this.level;
    }

    public static WorldBlock fromWorld(Level level, BlockPos pos) {
        return new WorldBlock(level, pos, level.m_8055_(pos), level.m_7702_(pos));
    }

    public static List<WorldBlock> fromWorld(Level level, Collection<BlockPos> positions) {
        return positions.stream().map(pos -> WorldBlock.fromWorld(level, pos)).collect(Collectors.toList());
    }
}

