/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.common.capabilities;

import ht.treechop.TreeChopMod;
import ht.treechop.common.settings.ChopSettings;
import ht.treechop.common.settings.SneakBehavior;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;

public class ChopSettingsCapability
extends ChopSettings
implements INBTSerializable<CompoundTag> {
    public static final Capability<ChopSettingsCapability> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<ChopSettingsCapability>(){});
    public static final ChopSettings INSTANCE = new ChopSettingsCapability();
    private boolean isSynced = false;
    private static final String CHOPPING_ENABLED_KEY = "choppingEnabled";
    private static final String FELLING_ENABLED_KEY = "fellingEnabled";
    private static final String SNEAK_BEHAVIOR_KEY = "sneakBehavior";
    private static final String TREES_MUST_HAVE_LEAVES_KEY = "treesMustHaveLeaves";
    private static final String CHOP_IN_CREATIVE_MODE_KEY = "chopInCreativeMode";
    private static final String IS_SYNCED_KEY = "isSynced";

    public boolean isSynced() {
        return this.isSynced;
    }

    public void setSynced() {
        this.isSynced = true;
    }

    public static LazyOptional<ChopSettingsCapability> forPlayer(Player player) {
        LazyOptional lazyCapability = player.getCapability(CAPABILITY);
        if (!lazyCapability.isPresent() && !(player instanceof FakePlayer)) {
            TreeChopMod.LOGGER.warn("Player " + player + " is missing chop settings");
        }
        return player.getCapability(CAPABILITY);
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128379_(CHOPPING_ENABLED_KEY, this.getChoppingEnabled());
        nbt.m_128379_(FELLING_ENABLED_KEY, this.getFellingEnabled());
        nbt.m_128359_(SNEAK_BEHAVIOR_KEY, this.getSneakBehavior().name());
        nbt.m_128379_(TREES_MUST_HAVE_LEAVES_KEY, this.getTreesMustHaveLeaves());
        nbt.m_128379_(CHOP_IN_CREATIVE_MODE_KEY, this.getChopInCreativeMode());
        nbt.m_128379_(IS_SYNCED_KEY, this.isSynced());
        return nbt;
    }

    public void deserializeNBT(CompoundTag tag) {
        if (tag != null) {
            SneakBehavior sneakBehavior;
            Optional<Boolean> choppingEnabled = this.getBoolean(tag, CHOPPING_ENABLED_KEY);
            Optional<Boolean> fellingEnabled = this.getBoolean(tag, FELLING_ENABLED_KEY);
            try {
                sneakBehavior = SneakBehavior.valueOf(tag.m_128461_(SNEAK_BEHAVIOR_KEY));
            }
            catch (IllegalArgumentException e) {
                TreeChopMod.LOGGER.warn(String.format("NBT contains bad sneak behavior value \"%s\"; using default value instead", tag.m_128461_(SNEAK_BEHAVIOR_KEY)));
                sneakBehavior = SneakBehavior.INVERT_CHOPPING;
            }
            Optional<Boolean> onlyChopTreesWithLeaves = this.getBoolean(tag, TREES_MUST_HAVE_LEAVES_KEY);
            Optional<Boolean> chopInCreativeMode = this.getBoolean(tag, CHOP_IN_CREATIVE_MODE_KEY);
            Optional<Boolean> isSynced = this.getBoolean(tag, IS_SYNCED_KEY);
            this.setChoppingEnabled(choppingEnabled.orElse(this.getChoppingEnabled()));
            this.setFellingEnabled(fellingEnabled.orElse(this.getFellingEnabled()));
            this.setSneakBehavior(sneakBehavior);
            this.setTreesMustHaveLeaves(onlyChopTreesWithLeaves.orElse(this.getTreesMustHaveLeaves()));
            this.setChopInCreativeMode(chopInCreativeMode.orElse(this.getChopInCreativeMode()));
            if (isSynced.orElse(false).booleanValue()) {
                this.setSynced();
            }
        } else {
            TreeChopMod.LOGGER.warn("Failed to read ChopSettingsCapability NBT");
        }
    }

    private Optional<Boolean> getBoolean(CompoundTag CompoundTag2, String key) {
        return CompoundTag2.m_128441_(key) ? Optional.of(CompoundTag2.m_128471_(key)) : Optional.empty();
    }
}

