/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.common.compat;

import ht.treechop.api.ChopEvent;
import ht.treechop.common.config.ConfigHandler;
import ht.treechop.common.util.TickUtil;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;

@Mod.EventBusSubscriber(modid="treechop", bus=Mod.EventBusSubscriber.Bus.MOD)
public class NoChopRecursion {
    private static Map<Player, Long> lastChopTickByPlayers = new HashMap<Player, Long>();

    @SubscribeEvent
    public static void commonSetup(FMLCommonSetupEvent event) {
        if (((Boolean)ConfigHandler.COMMON.preventChopRecursion.get()).booleanValue()) {
            MinecraftForge.EVENT_BUS.register(EventHandler.class);
        }
    }

    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void onChop(ChopEvent.StartChopEvent event) {
            Player agent = event.getPlayer();
            long time = event.getWorld().m_46467_();
            if (lastChopTickByPlayers.getOrDefault(agent, TickUtil.NEVER) == time) {
                event.setCanceled(true);
            } else {
                lastChopTickByPlayers.put(agent, time);
            }
        }
    }
}

