/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.common.util;

import ht.treechop.TreeChopMod;
import ht.treechop.api.ChopEvent;
import ht.treechop.api.IChoppableBlock;
import ht.treechop.api.IChoppingItem;
import ht.treechop.common.capabilities.ChopSettingsCapability;
import ht.treechop.common.config.ChopCountingAlgorithm;
import ht.treechop.common.config.ConfigHandler;
import ht.treechop.common.init.ModBlocks;
import ht.treechop.common.settings.ChopSettings;
import ht.treechop.common.util.BlockNeighbors;
import ht.treechop.common.util.Chop;
import ht.treechop.common.util.ChopResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.eventbus.api.Event;
import org.apache.commons.lang3.tuple.Pair;

public class ChopUtil {
    public static boolean isBlockChoppable(Level level, BlockPos pos, BlockState blockState) {
        return blockState.m_60734_() instanceof IChoppableBlock || ChopUtil.isBlockALog(blockState);
    }

    public static boolean isBlockChoppable(Level level, BlockPos pos) {
        return ChopUtil.isBlockChoppable(level, pos, level.m_8055_(pos));
    }

    public static boolean isBlockALog(BlockState blockState) {
        return ConfigHandler.blockTagForDetectingLogs.m_8110_((Object)blockState.m_60734_());
    }

    public static boolean isBlockALog(Level level, BlockPos pos) {
        return ChopUtil.isBlockALog(level.m_8055_(pos));
    }

    public static boolean isBlockLeaves(Level level, BlockPos pos) {
        return ChopUtil.isBlockLeaves(level.m_8055_(pos));
    }

    public static boolean isBlockLeaves(BlockState blockState) {
        if (ConfigHandler.blockTagForDetectingLeaves.m_8110_((Object)blockState.m_60734_())) {
            return !ConfigHandler.ignorePersistentLeaves || !blockState.m_61138_((Property)LeavesBlock.f_54419_) || (Boolean)blockState.m_61143_((Property)LeavesBlock.f_54419_) == false;
        }
        return false;
    }

    public static Set<BlockPos> getConnectedBlocks(Collection<BlockPos> startingPoints, Function<BlockPos, Stream<BlockPos>> searchOffsetsSupplier, int maxNumBlocks, AtomicInteger iterationCounter) {
        HashSet<BlockPos> connectedBlocks = new HashSet<BlockPos>();
        List<Object> newConnectedBlocks = new LinkedList<BlockPos>(startingPoints);
        iterationCounter.set(0);
        do {
            connectedBlocks.addAll(newConnectedBlocks);
            if (connectedBlocks.size() >= maxNumBlocks) break;
            newConnectedBlocks = newConnectedBlocks.stream().flatMap(blockPos -> ((Stream)searchOffsetsSupplier.apply((BlockPos)blockPos)).filter(pos1 -> !connectedBlocks.contains(pos1))).limit(maxNumBlocks - connectedBlocks.size()).collect(Collectors.toList());
            iterationCounter.incrementAndGet();
        } while (!newConnectedBlocks.isEmpty());
        return connectedBlocks;
    }

    public static Set<BlockPos> getConnectedBlocks(Collection<BlockPos> startingPoints, Function<BlockPos, Stream<BlockPos>> searchOffsetsSupplier, int maxNumBlocks) {
        return ChopUtil.getConnectedBlocks(startingPoints, searchOffsetsSupplier, maxNumBlocks, new AtomicInteger());
    }

    public static boolean canChangeBlock(Level level, BlockPos blockPos, Player agent, GameType gameType) {
        return ChopUtil.canChangeBlock(level, blockPos, agent, gameType, ItemStack.f_41583_);
    }

    public static boolean canChangeBlock(Level level, BlockPos blockPos, Player agent, GameType gameType, ItemStack tool) {
        if (!agent.m_36187_(level, blockPos, gameType)) {
            if (tool.m_41619_()) {
                return true;
            }
            return ConfigHandler.shouldOverrideItemBehavior(tool.m_41720_(), true) || !tool.m_41720_().onBlockStartBreak(tool, blockPos, agent);
        }
        return false;
    }

    public static List<BlockPos> getTreeLeaves(Level level, Collection<BlockPos> treeBlocks) {
        AtomicInteger iterationCounter = new AtomicInteger();
        HashSet leaves = new HashSet();
        int maxNumLeavesBlocks = (Integer)ConfigHandler.COMMON.maxNumLeavesBlocks.get();
        ChopUtil.getConnectedBlocks(treeBlocks, pos1 -> {
            BlockState blockState = level.m_8055_(pos1);
            return (ChopUtil.isBlockLeaves(blockState) && !(blockState.m_60734_() instanceof LeavesBlock) ? BlockNeighbors.ADJACENTS_AND_BELOW_ADJACENTS : BlockNeighbors.ADJACENTS).asStream((BlockPos)pos1).filter(pos2 -> ChopUtil.markLeavesToDestroyAndKeepLooking(level, pos2, iterationCounter, leaves));
        }, maxNumLeavesBlocks, iterationCounter);
        if (leaves.size() >= maxNumLeavesBlocks) {
            TreeChopMod.LOGGER.warn(String.format("Max number of leaves reached: %d >= %d blocks", leaves.size(), maxNumLeavesBlocks));
        }
        return new ArrayList<BlockPos>(leaves);
    }

    private static boolean markLeavesToDestroyAndKeepLooking(Level level, BlockPos pos, AtomicInteger iterationCounter, Set<BlockPos> leavesToDestroy) {
        BlockState blockState = level.m_8055_(pos);
        if (ChopUtil.isBlockLeaves(blockState)) {
            if (blockState.m_60734_() instanceof LeavesBlock ? iterationCounter.get() + 1 > (Integer)blockState.m_61143_((Property)LeavesBlock.f_54418_) : iterationCounter.get() >= ConfigHandler.maxBreakLeavesDistance) {
                return false;
            }
            leavesToDestroy.add(pos);
            return true;
        }
        return false;
    }

    public static int numChopsToFell(int numBlocks) {
        return ((ChopCountingAlgorithm)((Object)ConfigHandler.COMMON.chopCountingAlgorithm.get())).calculate(numBlocks);
    }

    public static ChopResult getChopResult(Level level, BlockPos blockPos, Player agent, int numChops, boolean fellIfPossible, Predicate<BlockPos> logCondition) {
        return fellIfPossible ? ChopUtil.getChopResult(level, blockPos, agent, numChops, logCondition) : ChopUtil.tryToChopWithoutFelling(level, blockPos, numChops);
    }

    private static ChopResult getChopResult(Level level, BlockPos blockPos, Player agent, int numChops, Predicate<BlockPos> logCondition) {
        Set<BlockPos> supportedBlocks = ChopUtil.getTreeBlocks(level, blockPos, logCondition, ChopUtil.getPlayerChopSettings(agent).getTreesMustHaveLeaves());
        return ChopUtil.chopTree(level, blockPos, supportedBlocks, numChops);
    }

    private static Set<BlockPos> getTreeBlocks(Level level, BlockPos blockPos, Predicate<BlockPos> logCondition, boolean mustHaveLeaves) {
        AtomicBoolean hasLeaves = new AtomicBoolean(!mustHaveLeaves);
        Set<BlockPos> treeBlocks = ChopUtil.getTreeBlocks(level, blockPos, logCondition, hasLeaves);
        return hasLeaves.get() ? treeBlocks : Collections.emptySet();
    }

    private static Set<BlockPos> getTreeBlocks(Level level, BlockPos blockPos, Predicate<BlockPos> logCondition, AtomicBoolean inHasLeaves) {
        if (!logCondition.test(blockPos)) {
            return Collections.emptySet();
        }
        AtomicBoolean overrideHasLeaves = new AtomicBoolean(inHasLeaves.get());
        ChopEvent.DetectTreeEvent detectEvent = new ChopEvent.DetectTreeEvent(level, null, blockPos, level.m_8055_(blockPos), inHasLeaves, overrideHasLeaves);
        boolean valueToOverrideHasLeaves = inHasLeaves.get();
        boolean canceled = MinecraftForge.EVENT_BUS.post((Event)detectEvent);
        if (canceled) {
            return Collections.emptySet();
        }
        int maxNumTreeBlocks = (Integer)ConfigHandler.COMMON.maxNumTreeBlocks.get();
        AtomicBoolean trueHasLeaves = new AtomicBoolean(false);
        Set<BlockPos> supportedBlocks = ChopUtil.getConnectedBlocks(Collections.singletonList(blockPos), somePos -> BlockNeighbors.HORIZONTAL_AND_ABOVE.asStream((BlockPos)somePos).peek(pos -> trueHasLeaves.compareAndSet(false, ChopUtil.isBlockLeaves(level, pos))).filter(logCondition), maxNumTreeBlocks);
        if (supportedBlocks.size() >= maxNumTreeBlocks) {
            TreeChopMod.LOGGER.warn(String.format("Max tree size reached: %d >= %d blocks (not including leaves)", supportedBlocks.size(), maxNumTreeBlocks));
        }
        inHasLeaves.set(overrideHasLeaves.get() ? valueToOverrideHasLeaves : trueHasLeaves.get());
        return supportedBlocks;
    }

    private static ChopResult chopTree(Level level, BlockPos target, Set<BlockPos> supportedBlocks, int numChops) {
        int numChopsToFell;
        if (supportedBlocks.isEmpty()) {
            return ChopResult.IGNORED;
        }
        BlockState blockState = level.m_8055_(target);
        int currentNumChops = ChopUtil.getNumChops(level, target, blockState);
        if (currentNumChops + numChops < (numChopsToFell = ChopUtil.numChopsToFell(supportedBlocks.size()))) {
            Set<BlockPos> nearbyChoppableBlocks = ChopUtil.getConnectedBlocks(Collections.singletonList(target), pos -> BlockNeighbors.ADJACENTS_AND_DIAGONALS.asStream((BlockPos)pos).filter(checkPos -> Math.abs(checkPos.m_123342_() - target.m_123342_()) < 4 && ChopUtil.isBlockChoppable(level, checkPos)), 64);
            int totalNumChops = ChopUtil.getNumChops(level, nearbyChoppableBlocks) + numChops;
            if (totalNumChops >= numChopsToFell) {
                List choppedLogsSortedByY = nearbyChoppableBlocks.stream().filter(pos1 -> level.m_8055_(pos1).m_60734_() instanceof IChoppableBlock).sorted(Comparator.comparingInt(Vec3i::m_123342_)).collect(Collectors.toList());
                for (BlockPos pos2 : choppedLogsSortedByY) {
                    int chops = ChopUtil.getNumChops(level, pos2);
                    supportedBlocks.add(pos2);
                    if (chops <= numChopsToFell) continue;
                    break;
                }
            } else {
                nearbyChoppableBlocks.remove(target);
                return ChopUtil.gatherChops(level, target, numChops, nearbyChoppableBlocks);
            }
        }
        Chop chop = new Chop(target, numChops);
        return new ChopResult(level, Collections.singletonList(chop), supportedBlocks);
    }

    private static ChopResult gatherChops(Level level, BlockPos target, int numChops, Set<BlockPos> nearbyChoppableBlocks) {
        List sortedChoppableBlocks;
        Stack<Chop> chops = new Stack<Chop>();
        int numChopsLeft = ChopUtil.gatherChopAndGetNumChopsRemaining(level, target, numChops, chops);
        if (numChopsLeft > 0 && (sortedChoppableBlocks = nearbyChoppableBlocks.stream().filter(pos -> {
            BlockState blockState = level.m_8055_(pos);
            if (blockState.m_60734_() instanceof IChoppableBlock) {
                return ChopUtil.getNumChops(level, pos, blockState) < ChopUtil.getMaxNumChops(level, pos, blockState);
            }
            return pos.m_123342_() >= target.m_123342_();
        }).sorted(Comparator.comparingInt(a -> ChopUtil.chopDistance(target, a))).collect(Collectors.toList())).size() > 0) {
            int nextChoiceDistance = ChopUtil.chopDistance(target, (BlockPos)sortedChoppableBlocks.get(0));
            int candidateStartIndex = 0;
            int n = sortedChoppableBlocks.size();
            for (int i = 0; i <= n; ++i) {
                BlockPos nextTarget;
                if (i != n && ChopUtil.chopDistance(target, (BlockPos)sortedChoppableBlocks.get(i)) <= nextChoiceDistance) continue;
                List candidates = sortedChoppableBlocks.subList(candidateStartIndex, i);
                Collections.shuffle(candidates);
                Iterator iterator = candidates.iterator();
                while (iterator.hasNext() && (numChopsLeft = ChopUtil.gatherChopAndGetNumChopsRemaining(level, nextTarget = (BlockPos)iterator.next(), numChopsLeft, chops)) > 0) {
                }
                if (numChopsLeft <= 0) break;
                candidateStartIndex = i;
            }
        }
        return new ChopResult(level, chops, Collections.emptyList());
    }

    private static int gatherChopAndGetNumChopsRemaining(Level level, BlockPos targetPos, int numChops, List<Chop> choppedBlocks) {
        BlockState blockStateBeforeChopping = level.m_8055_(targetPos);
        if (!(blockStateBeforeChopping.m_60734_() instanceof IChoppableBlock) && ChopUtil.isBlockSurrounded(level, targetPos)) {
            return numChops;
        }
        int adjustedNumChops = ChopUtil.adjustNumChops(level, targetPos, blockStateBeforeChopping, numChops, false);
        if (adjustedNumChops > 0) {
            choppedBlocks.add(new Chop(targetPos, adjustedNumChops));
        }
        return numChops - adjustedNumChops;
    }

    private static boolean isBlockSurrounded(Level level, BlockPos pos) {
        return Stream.of(pos.m_142125_(), pos.m_142127_(), pos.m_142126_(), pos.m_142128_()).allMatch(neighborPos -> ChopUtil.isBlockALog(level, neighborPos));
    }

    public static int adjustNumChops(Level level, BlockPos blockPos, BlockState blockState, int numChops, boolean destructive) {
        Block choppedBlock = ChopUtil.getChoppedBlock(blockState);
        if (choppedBlock instanceof IChoppableBlock) {
            IChoppableBlock choppableBlock = (IChoppableBlock)choppedBlock;
            if (destructive) {
                return numChops;
            }
            int currentNumChops = blockState.m_60713_(choppedBlock) ? choppableBlock.getNumChops(level, blockPos, blockState) : 0;
            int maxNondestructiveChops = choppableBlock.getMaxNumChops(level, blockPos, blockState) - currentNumChops;
            return Math.min(maxNondestructiveChops, numChops);
        }
        return 0;
    }

    public static int getMaxNumChops(Level level, BlockPos blockPos, BlockState blockState) {
        Block block = blockState.m_60734_();
        if (block instanceof IChoppableBlock) {
            return ((IChoppableBlock)block).getMaxNumChops(level, blockPos, blockState);
        }
        if (ChopUtil.isBlockChoppable(level, blockPos, level.m_8055_(blockPos))) {
            int n;
            Block choppedBlock = ChopUtil.getChoppedBlock(blockState);
            if (choppedBlock instanceof IChoppableBlock) {
                IChoppableBlock choppableBlock = (IChoppableBlock)choppedBlock;
                n = choppableBlock.getMaxNumChops(level, blockPos, blockState);
            } else {
                n = 0;
            }
            return n;
        }
        return 0;
    }

    public static Block getChoppedBlock(BlockState blockState) {
        if (ChopUtil.isBlockALog(blockState)) {
            return blockState.m_60734_() instanceof IChoppableBlock ? blockState.m_60734_() : (Block)ModBlocks.CHOPPED_LOG.get();
        }
        return null;
    }

    public static int getNumChops(Level level, BlockPos pos) {
        return ChopUtil.getNumChops(level, pos, level.m_8055_(pos));
    }

    public static int getNumChops(Level level, BlockPos pos, BlockState blockState) {
        int n;
        Block block = blockState.m_60734_();
        if (block instanceof IChoppableBlock) {
            IChoppableBlock choppableBlock = (IChoppableBlock)block;
            n = choppableBlock.getNumChops(level, pos, blockState);
        } else {
            n = 0;
        }
        return n;
    }

    public static int getNumChops(Level level, Set<BlockPos> positions) {
        return positions.stream().map(pos -> Pair.of((Object)pos, (Object)level.m_8055_(pos))).map(posAndblockState -> {
            Integer n;
            Block patt17299$temp = ((BlockState)posAndblockState.getRight()).m_60734_();
            if (patt17299$temp instanceof IChoppableBlock) {
                IChoppableBlock choppableBlock = (IChoppableBlock)patt17299$temp;
                n = choppableBlock.getNumChops(level, (BlockPos)posAndblockState.getLeft(), (BlockState)posAndblockState.getRight());
            } else {
                n = 0;
            }
            return n;
        }).reduce(Integer::sum).orElse(0);
    }

    private static ChopResult tryToChopWithoutFelling(Level level, BlockPos blockPos, int numChops) {
        return ChopUtil.isBlockChoppable(level, blockPos) ? new ChopResult(level, Collections.singletonList(new Chop(blockPos, numChops)), Collections.emptyList()) : ChopResult.IGNORED;
    }

    public static int chopDistance(BlockPos a, BlockPos b) {
        return a.m_123333_((Vec3i)b);
    }

    public static boolean canChopWithTool(ItemStack tool) {
        return ConfigHandler.canChopWithItem(tool.m_41720_());
    }

    public static int getNumChopsByTool(ItemStack tool, BlockState blockState) {
        Item toolItem = tool.m_41720_();
        Integer overrideChops = ConfigHandler.getNumChopsOverride(tool.m_41720_());
        if (overrideChops != null) {
            return overrideChops;
        }
        if (toolItem instanceof IChoppingItem) {
            return ((IChoppingItem)toolItem).getNumChops(tool, blockState);
        }
        return 1;
    }

    public static boolean playerWantsToChop(Player player) {
        ChopSettings chopSettings = ChopUtil.getPlayerChopSettings(player);
        return ChopUtil.playerWantsToChop(player, chopSettings);
    }

    public static boolean playerWantsToChop(Player player, ChopSettings chopSettings) {
        if (!player.m_7500_() || chopSettings.getChopInCreativeMode()) {
            return chopSettings.getChoppingEnabled() ^ chopSettings.getSneakBehavior().shouldChangeChopBehavior((Entity)player);
        }
        return false;
    }

    public static boolean playerWantsToFell(Player player) {
        ChopSettings chopSettings = ChopUtil.getPlayerChopSettings(player);
        return ChopUtil.playerWantsToFell(player, chopSettings);
    }

    public static boolean playerWantsToFell(Player player, ChopSettings chopSettings) {
        return chopSettings.getFellingEnabled() ^ chopSettings.getSneakBehavior().shouldChangeFellBehavior((Entity)player);
    }

    public static ChopSettings getPlayerChopSettings(Player player) {
        LazyOptional playerSettings = ChopSettingsCapability.forPlayer(player).cast();
        return (ChopSettings)playerSettings.orElse((Object)ConfigHandler.fakePlayerChopSettings);
    }

    public static void doItemDamage(ItemStack itemStack, Level level, BlockState blockState, BlockPos blockPos, Player agent) {
        ItemStack mockItemStack = itemStack.m_41777_();
        itemStack.m_41686_(level, blockState, blockPos, agent);
        if (itemStack.m_41619_() && !mockItemStack.m_41619_()) {
            ForgeEventFactory.onPlayerDestroyItem((Player)agent, (ItemStack)mockItemStack, (InteractionHand)InteractionHand.MAIN_HAND);
        }
    }

    public static void dropExperience(Level level, BlockPos blockPos, int amount) {
        if (level instanceof ServerLevel) {
            Blocks.f_50016_.m_49805_((ServerLevel)level, blockPos, amount);
        }
    }

    public static boolean isPartOfATree(Level level, BlockPos pos, boolean mustHaveLeaves) {
        AtomicBoolean hasLeaves = new AtomicBoolean(false);
        Set<BlockPos> treeBlocks = ChopUtil.getTreeBlocks(level, pos, (BlockPos blockPos) -> ChopUtil.isBlockALog(level, blockPos), hasLeaves);
        if (treeBlocks.isEmpty()) {
            return false;
        }
        if (mustHaveLeaves) {
            return hasLeaves.get();
        }
        return treeBlocks.size() >= (hasLeaves.get() ? 1 : 2);
    }
}

