/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.client;

import ht.treechop.TreeChop;
import ht.treechop.client.Client;
import ht.treechop.client.KeyBindings;
import ht.treechop.client.model.ChoppedLogBakedModel;
import ht.treechop.client.model.ChoppedLogModelProvider;
import ht.treechop.client.model.FabricChoppedLogBakedModel;
import ht.treechop.client.model.FabricChoppedLogEntityRenderer;
import ht.treechop.client.model.HiddenChoppedLogBakedModel;
import ht.treechop.common.network.CustomPacket;
import ht.treechop.common.network.ServerConfirmSettingsPacket;
import ht.treechop.common.network.ServerPermissionsPacket;
import ht.treechop.common.network.ServerUpdateChopsPacket;
import ht.treechop.common.registry.FabricModBlocks;
import io.netty.buffer.Unpooled;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.model.ModelLoadingRegistry;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.rendering.v1.BlockEntityRendererRegistry;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

@Environment(value=EnvType.CLIENT)
public class FabricClient
extends Client
implements ClientModInitializer {
    public static ChoppedLogBakedModel choppedLogModel;

    public void onInitializeClient() {
        if (FabricLoader.getInstance().isModLoaded("sodium")) {
            TreeChop.LOGGER.info("Sodium detected! Using alternative block renderer.");
            ModelLoadingRegistry.INSTANCE.registerResourceProvider(resourceManager -> new ChoppedLogModelProvider(new HiddenChoppedLogBakedModel()));
            BlockEntityRendererRegistry.register(FabricModBlocks.CHOPPED_LOG_ENTITY, FabricChoppedLogEntityRenderer::new);
        } else {
            ModelLoadingRegistry.INSTANCE.registerResourceProvider(resourceManager -> new ChoppedLogModelProvider(choppedLogModel));
        }
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> FabricClient.syncOnJoin());
        this.registerPackets();
        this.registerKeybindings();
    }

    private void registerKeybindings() {
        KeyBindings.registerKeyMappings(KeyBindingHelper::registerKeyBinding);
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            for (KeyBindings.ActionableKeyBinding keyBinding : KeyBindings.allKeyBindings) {
                if (!keyBinding.method_1436()) continue;
                keyBinding.onPress();
                return;
            }
        });
    }

    private void registerPackets() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)ServerConfirmSettingsPacket.ID, (client, handler, buffer, sender) -> {
            ServerConfirmSettingsPacket packet = ServerConfirmSettingsPacket.decode(buffer);
            client.execute(() -> ServerConfirmSettingsPacket.handle(packet));
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)ServerPermissionsPacket.ID, (client, handler, buffer, sender) -> {
            ServerPermissionsPacket packet = ServerPermissionsPacket.decode(buffer);
            client.execute(() -> ServerPermissionsPacket.handle(packet));
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)ServerUpdateChopsPacket.ID, (client, handler, buffer, sender) -> {
            ServerUpdateChopsPacket packet = ServerUpdateChopsPacket.decode(buffer);
            client.execute(() -> Client.handleUpdateChopsPacket(packet));
        });
    }

    @Override
    void sendToServer(CustomPacket packet) {
        class_2540 buffer = new class_2540(Unpooled.buffer());
        ClientPlayNetworking.send((class_2960)packet.getId(), (class_2540)packet.encode(buffer));
    }

    static {
        Client.instance = new FabricClient();
        choppedLogModel = new FabricChoppedLogBakedModel();
    }
}

