/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.common.chop;

import ht.treechop.common.chop.Chop;
import ht.treechop.common.chop.ChopUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1934;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3610;

public class ChopResult {
    public static final ChopResult IGNORED = new ChopResult(null, Collections.emptyList(), Collections.emptyList());
    public static final int MAX_NUM_FELLING_EFFECTS = 32;
    private final class_1937 level;
    private final Collection<Chop> chops;
    private final Collection<class_2338> fells;

    public ChopResult(class_1937 level, Collection<Chop> chops, Collection<class_2338> fells) {
        this.level = level;
        this.chops = chops;
        this.fells = fells;
    }

    private static void chopBlocks(class_1937 level, class_1657 player, class_1799 tool, Stream<Chop> chops, boolean felling) {
        chops.forEach(chop -> chop.apply(level, player, tool, felling));
    }

    private static void fellBlocks(class_1937 level, class_2338 targetPos, class_1297 agent, Stream<class_2338> blocks) {
        Consumer<class_2338> blockBreaker;
        class_3222 player;
        AtomicInteger xpAccumulator = new AtomicInteger(0);
        if (level.method_8608() || agent instanceof class_3222 && (player = (class_3222)agent).method_7337()) {
            class_2680 air = class_2246.field_10124.method_9564();
            blockBreaker = pos -> level.method_8501(pos, air);
        } else {
            blockBreaker = pos -> ChopResult.harvestWorldBlock(null, level, pos, class_1799.field_8037);
        }
        blocks.forEach(blockBreaker);
        ChopUtil.dropExperience(level, targetPos, xpAccumulator.get());
    }

    private static void playBlockBreakEffects(class_1937 level, List<class_2338> logs, List<class_2338> leaves) {
        int numLogsAndLeaves = logs.size() + leaves.size();
        int numEffects = Math.min((int)Math.ceil(Math.sqrt(numLogsAndLeaves)), 32) - 1;
        int numLeavesEffects = Math.max(1, (int)Math.ceil((double)numEffects * ((double)leaves.size() / (double)numLogsAndLeaves)));
        int numLogsEffects = Math.max(1, numEffects - numLeavesEffects);
        Collections.shuffle(logs);
        Collections.shuffle(leaves);
        Stream.concat(logs.stream().limit(numLogsEffects), leaves.stream().limit(numLeavesEffects)).forEach(pos -> level.method_20290(2001, pos, class_2248.method_9507((class_2680)level.method_8320(pos))));
    }

    private static void harvestWorldBlock(class_1297 agent, class_1937 level, class_2338 pos, class_1799 tool) {
        class_2680 blockState = level.method_8320(pos);
        if (level instanceof class_3218) {
            class_3610 fluidStateOrAir = level.method_8316(pos);
            blockState.method_26204().method_9585((class_1936)level, pos, blockState);
            class_2248.method_9511((class_2680)blockState, (class_1937)level, (class_2338)pos, (class_2586)level.method_8321(pos), (class_1297)agent, (class_1799)tool);
            level.method_8501(pos, fluidStateOrAir.method_15759());
        }
    }

    public boolean apply(class_2338 targetPos, class_3222 agent, class_1799 tool, boolean breakLeaves) {
        class_1934 gameType = agent.field_13974.method_14257();
        AtomicBoolean somethingChanged = new AtomicBoolean(false);
        List<class_2338> logs = Stream.concat(this.chops.stream().map(Chop::getBlockPos), this.fells.stream()).filter(pos -> !somethingChanged.get() && !agent.method_21701(this.level, pos, gameType)).peek(pos -> {
            class_2680 blockState = this.level.method_8320(pos);
            somethingChanged.compareAndSet(false, blockState.method_26215());
        }).collect(Collectors.toList());
        if (somethingChanged.get()) {
            return false;
        }
        ChopResult.chopBlocks(this.level, (class_1657)agent, tool, this.chops.stream(), this.isFelling());
        if (this.isFelling()) {
            List<class_2338> leaves = breakLeaves ? ChopUtil.getTreeLeaves(this.level, logs).stream().filter(pos -> !agent.method_21701(this.level, pos, agent.field_13974.method_14257())).collect(Collectors.toList()) : Collections.emptyList();
            logs.remove(targetPos);
            ChopResult.playBlockBreakEffects(this.level, logs, leaves);
            this.fells.remove(targetPos);
            ChopResult.fellBlocks(this.level, targetPos, (class_1297)agent, Stream.of(this.fells, leaves).flatMap(Collection::stream));
            return false;
        }
        return true;
    }

    public boolean isFelling() {
        return !this.fells.isEmpty();
    }
}

