/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.common.config;

import ht.treechop.common.config.ConfigHandler;
import ht.treechop.common.config.Rounder;
import java.util.function.Function;
import net.minecraft.class_3542;
import org.jetbrains.annotations.NotNull;

public enum ChopCountingAlgorithm implements class_3542
{
    LINEAR(numBlocks -> {
        double x = numBlocks.intValue();
        double m = (Double)ConfigHandler.COMMON.linearM.get();
        double b = (Double)ConfigHandler.COMMON.linearB.get();
        return m * x + b;
    }),
    LOGARITHMIC(numBlocks -> {
        double x = numBlocks.intValue();
        double a = (Double)ConfigHandler.COMMON.logarithmicA.get();
        return 1.0 + a * Math.log(1.0 + (x - 1.0) / a);
    });

    private final Function<Integer, Double> preciseCalculation;

    private ChopCountingAlgorithm(Function<Integer, Double> preciseCalculation) {
        this.preciseCalculation = preciseCalculation;
    }

    public int calculate(int numBlocks) {
        if (numBlocks == 1) {
            return 1;
        }
        Rounder rounder = (Rounder)((Object)ConfigHandler.COMMON.chopCountRounding.get());
        int unboundedCount = Math.max(1, rounder.round(this.preciseCalculation.apply(numBlocks)));
        return (Boolean)ConfigHandler.COMMON.canRequireMoreChopsThanBlocks.get() != false ? unboundedCount : Math.min(numBlocks, unboundedCount);
    }

    @NotNull
    public String method_15434() {
        return this.name();
    }
}

