/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.common.config;

import ht.treechop.TreeChop;
import ht.treechop.api.IChoppingItem;
import ht.treechop.common.config.ChopCountingAlgorithm;
import ht.treechop.common.config.Lazy;
import ht.treechop.common.config.ListType;
import ht.treechop.common.config.Rounder;
import ht.treechop.common.config.Signal;
import ht.treechop.common.config.resource.ResourceIdentifier;
import ht.treechop.common.platform.ModLoader;
import ht.treechop.common.settings.ChopSettings;
import ht.treechop.common.settings.EntityChopSettings;
import ht.treechop.common.settings.Permissions;
import ht.treechop.common.settings.Setting;
import ht.treechop.common.settings.SettingsField;
import ht.treechop.common.settings.SneakBehavior;
import ht.treechop.common.util.AxeAccessor;
import ht.treechop.compat.ProjectMMOChopXp;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.text.WordUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class ConfigHandler {
    public static final Common COMMON;
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final Client CLIENT;
    public static final ForgeConfigSpec CLIENT_SPEC;
    private static final Signal<Lazy<?>> RELOAD;
    public static final Lazy<ChopSettings> defaultChopSettings;
    public static final Lazy<EntityChopSettings> fakePlayerChopSettings;
    private static final Signal<Lazy<?>> UPDATE_TAGS;
    public static Lazy<Boolean> removeBarkOnInteriorLogs;
    public static Lazy<Map<class_2248, class_2680>> inferredStrippedStates;

    public static void onReload() {
        RELOAD.run();
        ConfigHandler.updateTags();
    }

    public static void updateTags() {
        UPDATE_TAGS.run();
    }

    @NotNull
    private static Map<class_2248, class_2680> inferStrippedStates() {
        Set<class_2248> choppableBlocks = ConfigHandler.COMMON.choppableBlocks.get();
        HashMap<class_2248, class_2680> map = new HashMap<class_2248, class_2680>();
        choppableBlocks.forEach(block -> {
            class_2248 unstripped = ConfigHandler.inferUnstripped(block);
            if (unstripped != class_2246.field_10124 && AxeAccessor.getStripped(unstripped) == null) {
                map.put(unstripped, block.method_9564());
            }
        });
        return map;
    }

    private static class_2248 inferUnstripped(class_2248 block) {
        class_2960 resource = class_2378.field_11146.method_10221((Object)block);
        return ConfigHandler.inferUnstripped(resource);
    }

    private static class_2248 inferUnstripped(class_2960 resource) {
        class_2960 unstripped;
        if (resource != null && (unstripped = ConfigHandler.getFilteredResourceLocation(resource, "stripped")) != null) {
            return (class_2248)class_2378.field_11146.method_10223(unstripped);
        }
        return class_2246.field_10124;
    }

    private static class_2960 getFilteredResourceLocation(class_2960 resource, String filterTerm) {
        String unstrippedPath;
        String strippedPath;
        if (resource != null && !(strippedPath = resource.method_12832()).equals(unstrippedPath = Arrays.stream(strippedPath.split("_")).filter(token -> !token.equals(filterTerm)).collect(Collectors.joining("_")))) {
            return new class_2960(resource.method_12836(), unstrippedPath);
        }
        return null;
    }

    private static Stream<class_1792> getIdentifiedItems(String stringId) {
        ResourceIdentifier id = ResourceIdentifier.from(stringId);
        return id.resolve(class_2378.field_11142);
    }

    private static Stream<class_2248> getIdentifiedBlocks(String stringId) {
        ResourceIdentifier id = ResourceIdentifier.from(stringId);
        return id.resolve(class_2378.field_11146);
    }

    public static boolean canChopWithTool(class_1657 player, class_1799 tool, class_1937 level, class_2338 pos, class_2680 blockState) {
        IChoppingItem choppingItem = TreeChop.api.getRegisteredChoppingItemBehavior(tool.method_7909());
        return choppingItem != null ? choppingItem.canChop(player, tool, level, pos, blockState) : ConfigHandler.choppingItemIsBlacklisted(tool.method_7909());
    }

    private static boolean choppingItemIsBlacklisted(class_1792 item) {
        return ((ListType)((Object)ConfigHandler.COMMON.itemsBlacklistOrWhitelist.get())).accepts(ConfigHandler.COMMON.choppingItemsList.get().contains(item));
    }

    public static Permissions getServerPermissions() {
        return new Permissions(ConfigHandler.COMMON.rawPermissions.stream().filter(settingAndConfig -> (Boolean)((ForgeConfigSpec.BooleanValue)settingAndConfig.getValue()).get()).map(Pair::getKey).collect(Collectors.toSet()));
    }

    private static <T> InitializedSupplier<T> defaultValue(T defaultValue) {
        return new InitializedSupplier<Object>(() -> defaultValue);
    }

    public static Stream<class_2248> getMushroomStems() {
        return ConfigHandler.getIdentifiedBlocks(ConfigHandler.getCommonTagId("mushroom_stems"));
    }

    private static String getCommonTagId(String path) {
        return String.format("#%s:%s", TreeChop.platform.uses(ModLoader.FORGE) ? "forge" : "c", path);
    }

    static {
        RELOAD = new Signal<Lazy>(Lazy::reset);
        defaultChopSettings = new Lazy<ChopSettings>(RELOAD, () -> {
            ChopSettings chopSettings = new ChopSettings();
            Permissions permissions = ConfigHandler.getServerPermissions();
            chopSettings.forEach((field, value) -> {
                if (!permissions.isPermitted((SettingsField)((Object)((Object)field)), value)) {
                    chopSettings.set((SettingsField)((Object)((Object)field)), field.getValues().stream().filter(candidate -> permissions.isPermitted(new Setting((SettingsField)((Object)((Object)field)), candidate))).findFirst().orElse(value));
                }
            });
            return chopSettings;
        });
        fakePlayerChopSettings = new Lazy<EntityChopSettings>(RELOAD, () -> {
            EntityChopSettings chopSettings = new EntityChopSettings(){

                @Override
                public boolean isSynced() {
                    return true;
                }
            };
            chopSettings.setChoppingEnabled((Boolean)ConfigHandler.COMMON.fakePlayerChoppingEnabled.get()).setFellingEnabled((Boolean)ConfigHandler.COMMON.fakePlayerFellingEnabled.get()).setTreesMustHaveLeaves((Boolean)ConfigHandler.COMMON.fakePlayerTreesMustHaveLeaves.get());
            return chopSettings;
        });
        UPDATE_TAGS = new Signal<Lazy>(Lazy::reset);
        removeBarkOnInteriorLogs = new Lazy<Boolean>(RELOAD, () -> {
            try {
                return (Boolean)ConfigHandler.CLIENT.removeBarkOnInteriorLogs.get();
            }
            catch (IllegalStateException e) {
                return false;
            }
        });
        inferredStrippedStates = new Lazy<Map>(UPDATE_TAGS, ConfigHandler::inferStrippedStates);
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
        specPair = new ForgeConfigSpec.Builder().configure(Client::new);
        CLIENT_SPEC = (ForgeConfigSpec)specPair.getRight();
        CLIENT = (Client)specPair.getLeft();
    }

    public static class Common {
        public final ForgeConfigSpec.BooleanValue enabled;
        public final ForgeConfigSpec.BooleanValue dropLootForChoppedBlocks;
        public final ForgeConfigSpec.IntValue maxNumTreeBlocks;
        public final ForgeConfigSpec.IntValue maxNumLeavesBlocks;
        public final ForgeConfigSpec.BooleanValue breakLeaves;
        public final ForgeConfigSpec.BooleanValue ignorePersistentLeaves;
        public final ForgeConfigSpec.IntValue maxBreakLeavesDistance;
        public final ForgeConfigSpec.EnumValue<ChopCountingAlgorithm> chopCountingAlgorithm;
        public final ForgeConfigSpec.EnumValue<Rounder> chopCountRounding;
        public final ForgeConfigSpec.BooleanValue canRequireMoreChopsThanBlocks;
        public final ForgeConfigSpec.DoubleValue logarithmicA;
        public final ForgeConfigSpec.DoubleValue linearM;
        public final ForgeConfigSpec.DoubleValue linearB;
        public final ForgeConfigSpec.EnumValue<ListType> itemsBlacklistOrWhitelist;
        public final ForgeConfigSpec.BooleanValue preventChoppingOnRightClick;
        public final ForgeConfigSpec.BooleanValue preventChopRecursion;
        public final ForgeConfigSpec.BooleanValue fakePlayerChoppingEnabled;
        public final ForgeConfigSpec.BooleanValue fakePlayerFellingEnabled;
        public final ForgeConfigSpec.BooleanValue fakePlayerTreesMustHaveLeaves;
        public final InitializedSupplier<Boolean> compatForMushroomStems = ConfigHandler.defaultValue(true);
        public final InitializedSupplier<Boolean> compatForProjectMMO = ConfigHandler.defaultValue(true);
        public final InitializedSupplier<ProjectMMOChopXp> pmmoXpMethod = ConfigHandler.defaultValue(ProjectMMOChopXp.USE_BLOCK_XP);
        public final InitializedSupplier<Double> pmmoScaleXp = ConfigHandler.defaultValue(1.0);
        public final InitializedSupplier<Long> pmmoOverrideXp = ConfigHandler.defaultValue(80L);
        public final InitializedSupplier<Boolean> compatForDynamicTrees = ConfigHandler.defaultValue(true);
        public final ForgeConfigSpec.BooleanValue verboseAPI;
        protected final List<Pair<Setting, ForgeConfigSpec.BooleanValue>> rawPermissions = new LinkedList<Pair<Setting, ForgeConfigSpec.BooleanValue>>();
        protected final ForgeConfigSpec.ConfigValue<List<? extends String>> choppableBlocksList;
        protected final ForgeConfigSpec.ConfigValue<List<? extends String>> choppableBlocksExceptionsList;
        public final Lazy<Set<class_2248>> choppableBlocks = new Lazy<Set>(UPDATE_TAGS, () -> {
            Set exceptions = ((List)ConfigHandler.COMMON.choppableBlocksExceptionsList.get()).stream().flatMap(ConfigHandler::getIdentifiedBlocks).collect(Collectors.toSet());
            Set blocks = ((List)ConfigHandler.COMMON.choppableBlocksList.get()).stream().flatMap(ConfigHandler::getIdentifiedBlocks).filter(block -> !exceptions.contains(block)).collect(Collectors.toSet());
            TreeChop.api.getChoppableBlockOverrides().forEach(blockIsChoppable -> {
                if (((Boolean)blockIsChoppable.getValue()).booleanValue()) {
                    blocks.add((class_2248)blockIsChoppable.getKey());
                } else {
                    blocks.remove(blockIsChoppable.getKey());
                }
            });
            return blocks;
        });
        protected final ForgeConfigSpec.ConfigValue<List<? extends String>> leavesBlocksList;
        protected final ForgeConfigSpec.ConfigValue<List<? extends String>> leavesBlocksExceptionsList;
        public final Lazy<Set<class_2248>> leavesBlocks = new Lazy<Set>(UPDATE_TAGS, () -> {
            Set exceptions = ((List)ConfigHandler.COMMON.leavesBlocksExceptionsList.get()).stream().flatMap(ConfigHandler::getIdentifiedBlocks).collect(Collectors.toSet());
            Set blocks = ((List)ConfigHandler.COMMON.leavesBlocksList.get()).stream().flatMap(ConfigHandler::getIdentifiedBlocks).filter(block -> !exceptions.contains(block)).collect(Collectors.toSet());
            TreeChop.api.getLeavesBlockOverrides().forEach(blockIsLeaves -> {
                if (((Boolean)blockIsLeaves.getValue()).booleanValue()) {
                    blocks.add((class_2248)blockIsLeaves.getKey());
                } else {
                    blocks.remove(blockIsLeaves.getKey());
                }
            });
            return blocks;
        });
        protected final ForgeConfigSpec.ConfigValue<List<? extends String>> choppingItemsToBlacklistOrWhitelist;
        public final Lazy<Set<class_1792>> choppingItemsList = new Lazy<Set>(UPDATE_TAGS, () -> {
            Set items = ((List)ConfigHandler.COMMON.choppingItemsToBlacklistOrWhitelist.get()).stream().flatMap(ConfigHandler::getIdentifiedItems).collect(Collectors.toSet());
            ListType blackListOrWhiteList = (ListType)((Object)((Object)ConfigHandler.COMMON.itemsBlacklistOrWhitelist.get()));
            TreeChop.api.getChoppingItemOverrides().forEach(itemCanChop -> {
                if (blackListOrWhiteList.accepts((Boolean)itemCanChop.getValue())) {
                    items.add((class_1792)itemCanChop.getKey());
                } else {
                    items.remove(itemCanChop.getKey());
                }
            });
            return items;
        });

        public Common(ForgeConfigSpec.Builder builder) {
            builder.push("permissions");
            this.enabled = builder.comment("Set to false to disable TreeChop without having to uninstall the mod").define("enabled", true);
            for (SettingsField field : SettingsField.values()) {
                String fieldName = field.getConfigKey();
                for (Object value : field.getValues()) {
                    String valueName = this.getPrettyValueName(value);
                    ForgeConfigSpec.BooleanValue configHandle = builder.define(fieldName + ".canBe" + valueName, true);
                    this.rawPermissions.add((Pair<Setting, ForgeConfigSpec.BooleanValue>)Pair.of((Object)new Setting(field, value), (Object)configHandle));
                }
            }
            builder.pop();
            builder.push("general");
            this.dropLootForChoppedBlocks = builder.comment("If false, log items will be destroyed when chopping").define("dropLootForChoppedBlocks", true);
            builder.pop();
            builder.push("treeDetection");
            this.maxNumTreeBlocks = builder.comment("Maximum number of log blocks that can be detected to belong to one tree").defineInRange("maxTreeBlocks", 320, 1, 8096);
            this.maxNumLeavesBlocks = builder.comment("Maximum number of leaves blocks that can destroyed when a tree is felled").defineInRange("maxLeavesBlocks", 1024, 1, 8096);
            this.breakLeaves = builder.comment("Destroy leaves when a tree is felled").define("breakLeaves", true);
            this.ignorePersistentLeaves = builder.comment("Non-decayable leaves are ignored when detecting leaves").define("ignorePersistentLeaves", true);
            this.maxBreakLeavesDistance = builder.comment("Maximum distance from log blocks to destroy non-standard leaves blocks (e.g. mushroom caps) when felling").defineInRange("maxBreakLeavesDistance", 7, 0, 16);
            builder.push("logs");
            this.choppableBlocksList = builder.comment(String.join((CharSequence)"\n", "Blocks that should be considered choppable", "Specify using registry names (mod:block), tags (#mod:tag), and namespaces (@mod)")).defineList("blocks", List.of("#treechop:choppables", "#minecraft:logs", ConfigHandler.getCommonTagId("mushroom_stems")), always -> true);
            this.choppableBlocksExceptionsList = builder.comment(String.join((CharSequence)"\n", "Blocks that should never be chopped, even if included in the list above", "Specify using registry names (mod:block), tags (#mod:tag), and namespaces (@mod)")).defineList("exceptions", List.of("minecraft:bamboo"), always -> true);
            builder.pop();
            builder.push("leaves");
            this.leavesBlocksList = builder.comment(String.join((CharSequence)"\n", "Blocks that should be considered leaves", "Specify using registry names (mod:block), tags (#mod:tag), and namespaces (@mod)")).defineList("blocks", List.of("#treechop:leaves_like", "#minecraft:leaves", "#minecraft:wart_blocks", ConfigHandler.getCommonTagId("mushroom_caps"), "minecraft:shroomlight"), always -> true);
            this.leavesBlocksExceptionsList = builder.comment(String.join((CharSequence)"\n", "Blocks that should never be considered leaves, even if included in the list above", "Specify using registry names (mod:block), tags (#mod:tag), and namespaces (@mod)")).defineList("exceptions", List.of(), always -> true);
            builder.pop();
            builder.pop();
            builder.push("chopCounting");
            this.chopCountingAlgorithm = builder.comment("Method to use for computing the number of chops needed to fell a tree").defineEnum("algorithm", (Enum)ChopCountingAlgorithm.LOGARITHMIC);
            this.chopCountRounding = builder.comment("How to round the number of chops needed to fell a tree; this is more meaningful for smaller trees").defineEnum("rounding", (Enum)Rounder.NEAREST);
            this.canRequireMoreChopsThanBlocks = builder.comment("Felling a tree can require more chops than the number of blocks in the tree").define("canRequireMoreChopsThanBlocks", false);
            builder.comment("See https://github.com/hammertater/treechop/#logarithmic").push("logarithmic");
            this.logarithmicA = builder.comment("Determines the number of chops required to fell a tree; higher values require more chops for bigger trees").defineInRange("a", 10.0, 0.0, 10000.0);
            builder.pop();
            builder.comment("See https://github.com/hammertater/treechop/#linear").push("linear");
            this.linearM = builder.comment("The number of chops per block required to fell a tree; if chopsPerBlock = 0.5, it will take 50 chops to fell a 100 block tree").defineInRange("chopsPerBlock", 1.0, 0.0, 7.0);
            this.linearB = builder.comment("The base number of chops required to fell a tree regardless of its size").defineInRange("baseNumChops", 0.0, -10000.0, 10000.0);
            builder.pop();
            builder.pop();
            builder.push("compatibility");
            builder.push("general");
            this.preventChoppingOnRightClick = builder.comment("Prevent chopping when right-clicking blocks").define("preventChoppingOnRightClick", false);
            this.preventChopRecursion = builder.comment("Prevent infinite loops when chopping; fixes crashes when using modded items that break multiple blocks").define("preventChopRecursion", true);
            builder.push("blacklist");
            this.itemsBlacklistOrWhitelist = builder.comment("Whether the listed items should be blacklisted or whitelisted").defineEnum("blacklistOrWhitelist", (Enum)ListType.BLACKLIST);
            this.choppingItemsToBlacklistOrWhitelist = builder.comment(String.join((CharSequence)"\n", "List of item registry names (mod:item), tags (#mod:tag), and namespaces (@mod) for items that should not chop when used to break a log", "- Items in this list that have special support for TreeChop will not be blacklisted; see https://github.com/hammertater/treechop/blob/main/docs/compatibility.md#blacklist")).defineList("items", Arrays.asList("#tconstruct:modifiable/harvest", "botania:terra_axe", "mekanism:atomic_disassembler", "@lumberjack", "practicaltools:iron_greataxe", "practicaltools:golden_greataxe", "practicaltools:diamond_greataxe", "practicaltools:netherite_greataxe"), always -> true);
            builder.pop();
            builder.comment("The chop settings used by non-player entities, such as robots and machine blocks");
            builder.push("fakePlayerChopSettings");
            this.fakePlayerChoppingEnabled = builder.comment("Use with caution! May cause conflicts with some mods, e.g. https://github.com/hammertater/treechop/issues/71").define("choppingEnabled", false);
            this.fakePlayerFellingEnabled = builder.comment("Felling only matters if chopping is enabled; probably best to leave this on").define("fellingEnabled", true);
            this.fakePlayerTreesMustHaveLeaves = builder.define("treesMustHaveLeaves", true);
            builder.pop();
            builder.pop();
            this.compatForMushroomStems.set((Supplier<Boolean>)builder.comment(String.format("Better chopping behavior for block with the %s tag", ConfigHandler.getCommonTagId("mushroom_stems"))).define("mushroomStems", true));
            if (TreeChop.platform.uses(ModLoader.FORGE)) {
                this.compatForDynamicTrees.set((Supplier<Boolean>)builder.comment(String.join((CharSequence)"\n", "Prevent conflicts with DynamicTrees", "See https://www.curseforge.com/minecraft/mc-mods/dynamictrees")).define("dynamicTrees", true));
                builder.push("projectMMO");
                this.compatForProjectMMO.set((Supplier<Boolean>)builder.comment(String.join((CharSequence)"\n", "Fix ProjectMMO XP awards for chopping", "See https://www.curseforge.com/minecraft/mc-mods/project-mmo")).define("projectMMO", true));
                this.pmmoXpMethod.set((Supplier<ProjectMMOChopXp>)builder.comment("When chopping, award the default XP for the chopped block or use a custom value").defineEnum("useBlockXpOrOverride", (Enum)ProjectMMOChopXp.USE_BLOCK_XP));
                this.pmmoScaleXp.set((Supplier<Double>)builder.comment(String.format("Multiplier for the amount of XP awarded if useBlockXpOrOverride = %s", ProjectMMOChopXp.USE_BLOCK_XP.name())).defineInRange("xpMultiplier", 1.0, 0.0, 100000.0));
                this.pmmoOverrideXp.set((Supplier<Long>)builder.comment(String.format("How much XP to award if useBlockXpOrOverride = %s", ProjectMMOChopXp.OVERRIDE.name())).defineInRange("xpOverride", 80L, 0L, 100000L));
                builder.pop();
            }
            builder.push("API");
            this.verboseAPI = builder.comment("Log information about TreeChop API usage. May be useful for debugging mod compatibility issues.").define("verbose", false);
            builder.pop();
            builder.pop();
        }

        private String getPrettyValueName(Object value) {
            return Arrays.stream(value.toString().toLowerCase().split("_")).map(WordUtils::capitalize).collect(Collectors.joining());
        }
    }

    public static class InitializedSupplier<T>
    implements Supplier<T> {
        private Supplier<T> supplier;

        public InitializedSupplier(Supplier<T> defaultSupplier) {
            this.supplier = defaultSupplier;
        }

        @Override
        public T get() {
            return this.supplier.get();
        }

        private void set(Supplier<T> newSupplier) {
            this.supplier = newSupplier;
        }
    }

    public static class Client {
        public final ForgeConfigSpec.BooleanValue choppingEnabled;
        public final ForgeConfigSpec.BooleanValue fellingEnabled;
        public final ForgeConfigSpec.EnumValue<SneakBehavior> sneakBehavior;
        public final ForgeConfigSpec.BooleanValue treesMustHaveLeaves;
        public final ForgeConfigSpec.BooleanValue chopInCreativeMode;
        public final ForgeConfigSpec.BooleanValue showChoppingIndicators;
        public final ForgeConfigSpec.BooleanValue removeBarkOnInteriorLogs;
        public final ForgeConfigSpec.IntValue indicatorXOffset;
        public final ForgeConfigSpec.IntValue indicatorYOffset;
        public final ForgeConfigSpec.BooleanValue showFellingOptions;
        public final ForgeConfigSpec.BooleanValue showFeedbackMessages;
        public final ForgeConfigSpec.BooleanValue showTooltips;

        public Client(ForgeConfigSpec.Builder builder) {
            builder.push("chopping");
            this.choppingEnabled = builder.comment("Default setting for whether or not the user wishes to chop (can be toggled in-game)").define("choppingEnabled", true);
            this.fellingEnabled = builder.comment("Default setting for whether or not the user wishes to fell tree when chopping (can be toggled in-game)").define("fellingEnabled", true);
            this.sneakBehavior = builder.comment("Default setting for the effect that sneaking has on chopping (can be cycled in-game)").defineEnum("sneakBehavior", (Enum)SneakBehavior.INVERT_CHOPPING);
            this.treesMustHaveLeaves = builder.comment("Ignore trees without connected leaves (can be toggled in-game)").define("treesMustHaveLeaves", true);
            this.chopInCreativeMode = builder.comment("Enable chopping in creative mode (even when false, sneaking can still enable chopping) (can be toggled in-game)").define("chopInCreativeMode", false);
            builder.pop();
            builder.push("visuals");
            this.removeBarkOnInteriorLogs = builder.comment("Visually replace the interior sides of logs with a chopped texture instead of bark").define("removeBarkOnInteriorLogs", true);
            builder.push("choppingIndicator");
            this.showChoppingIndicators = builder.comment("Show an on-screen indicator when a block will be chopped instead of broken (can be toggled in-game)").define("enabled", true);
            this.indicatorXOffset = builder.comment("Horizontal location of the indicator relative to the player's crosshairs; positive values move the indicator to the right").defineInRange("xOffset", 16, -256, 256);
            this.indicatorYOffset = builder.comment("Vertical location of the indicator relative to the player's crosshairs; positive values move the indicator down").defineInRange("yOffset", 0, -256, 256);
            builder.pop();
            builder.pop();
            builder.push("settingsScreen");
            this.showFellingOptions = builder.comment("Show in-game options for enabling and disable felling (can be toggled in-game)").define("showFellingOptions", false);
            this.showFeedbackMessages = builder.comment("Show chat confirmations when using hotkeys to change chop settings (can be toggled in-game)").define("showFeedbackMessages", true);
            this.showTooltips = builder.comment("Show tooltips in the settings screen (can be toggled in-game)").define("showTooltips", true);
            builder.pop();
        }

        public ChopSettings getChopSettings() {
            ChopSettings chopSettings = new ChopSettings();
            chopSettings.setChoppingEnabled((Boolean)ConfigHandler.CLIENT.choppingEnabled.get());
            chopSettings.setFellingEnabled((Boolean)ConfigHandler.CLIENT.fellingEnabled.get());
            chopSettings.setSneakBehavior((SneakBehavior)((Object)ConfigHandler.CLIENT.sneakBehavior.get()));
            chopSettings.setTreesMustHaveLeaves((Boolean)ConfigHandler.CLIENT.treesMustHaveLeaves.get());
            chopSettings.setChopInCreativeMode((Boolean)ConfigHandler.CLIENT.chopInCreativeMode.get());
            return chopSettings;
        }
    }
}

