/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.common.settings;

import ht.treechop.TreeChop;
import ht.treechop.common.config.ConfigHandler;
import ht.treechop.common.settings.ChopSettings;
import ht.treechop.common.settings.SneakBehavior;
import java.util.Optional;
import net.minecraft.class_2487;

public class EntityChopSettings
extends ChopSettings {
    private boolean isSynced = false;

    public EntityChopSettings() {
    }

    public EntityChopSettings(ChopSettings template) {
        super(template);
    }

    public boolean isSynced() {
        return this.isSynced;
    }

    public void setSynced() {
        this.isSynced = true;
    }

    public class_2487 makeSaveData() {
        class_2487 nbt = new class_2487();
        nbt.method_10556("choppingEnabled", this.getChoppingEnabled());
        nbt.method_10556("fellingEnabled", this.getFellingEnabled());
        nbt.method_10582("sneakBehavior", this.getSneakBehavior().name());
        nbt.method_10556("treesMustHaveLeaves", this.getTreesMustHaveLeaves());
        nbt.method_10556("chopInCreativeMode", this.getChopInCreativeMode());
        nbt.method_10556("isSynced", this.isSynced());
        return nbt;
    }

    public EntityChopSettings readSaveData(class_2487 tag) {
        if (tag.method_10545("isSynced")) {
            String sneakBehaviorId;
            Optional<Boolean> choppingEnabled = this.getBoolean(tag, "choppingEnabled");
            Optional<Boolean> fellingEnabled = this.getBoolean(tag, "fellingEnabled");
            Optional<Boolean> onlyChopTreesWithLeaves = this.getBoolean(tag, "treesMustHaveLeaves");
            Optional<Boolean> chopInCreativeMode = this.getBoolean(tag, "chopInCreativeMode");
            Optional<Boolean> isSynced = this.getBoolean(tag, "isSynced");
            SneakBehavior defaultSneakBehavior = ConfigHandler.defaultChopSettings.get().getSneakBehavior();
            String string = sneakBehaviorId = tag.method_10545("sneakBehavior") ? tag.method_10558("sneakBehavior") : "";
            if (sneakBehaviorId.isEmpty()) {
                this.setSneakBehavior(defaultSneakBehavior);
            } else {
                SneakBehavior sneakBehavior;
                try {
                    sneakBehavior = SneakBehavior.valueOf(sneakBehaviorId);
                }
                catch (IllegalArgumentException e) {
                    TreeChop.LOGGER.warn(String.format("NBT contains bad sneak behavior value \"%s\"; using default value \"%s\"", tag.method_10558("sneakBehavior"), defaultSneakBehavior.name()));
                    sneakBehavior = defaultSneakBehavior;
                }
                this.setSneakBehavior(sneakBehavior);
            }
            this.setChoppingEnabled(choppingEnabled.orElse(this.getChoppingEnabled()));
            this.setFellingEnabled(fellingEnabled.orElse(this.getFellingEnabled()));
            this.setTreesMustHaveLeaves(onlyChopTreesWithLeaves.orElse(this.getTreesMustHaveLeaves()));
            this.setChopInCreativeMode(chopInCreativeMode.orElse(this.getChopInCreativeMode()));
            if (isSynced.orElse(false).booleanValue()) {
                this.setSynced();
            }
        }
        return this;
    }
}

