/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.common.config.resource;

import ht.treechop.TreeChop;
import ht.treechop.common.config.resource.IdentifierQualifier;
import ht.treechop.common.config.resource.MalformedResourceIdentifier;
import ht.treechop.common.config.resource.ResourceNamespaceIdentifier;
import ht.treechop.common.config.resource.ResourcePatternIdentifier;
import ht.treechop.common.config.resource.ResourceTagIdentifier;
import ht.treechop.common.config.resource.SingleResourceIdentifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_2348;

public abstract class ResourceIdentifier {
    private static final Pattern PATTERN = Pattern.compile("^\\s*([#@])?([a-z0-9_\\-.]*(?=:))?:?([a-z0-9_\\-./]*)?$");
    private static final Pattern QUALIFIERS_PATTERN = Pattern.compile("^\\?(.*)$");
    private static final String DEFAULT_NAMESPACE = "minecraft";
    private final String nameSpace;
    private final String localSpace;
    private final List<IdentifierQualifier> qualifiers;
    private final String string;

    public ResourceIdentifier(String nameSpace, String localSpace, List<IdentifierQualifier> qualifiers, String string) {
        this.nameSpace = nameSpace;
        this.localSpace = localSpace;
        this.qualifiers = qualifiers;
        this.string = string;
    }

    public static ResourceIdentifier from(String string) {
        Matcher matcher = PATTERN.matcher(string);
        if (matcher.find()) {
            String searchSpace = Optional.ofNullable(matcher.group(1)).orElse("");
            String namespace = Optional.ofNullable(matcher.group(2)).orElse("");
            String localSpace = Optional.ofNullable(matcher.group(3)).orElse("");
            List<IdentifierQualifier> qualifiers = List.of();
            if (searchSpace.equals("#")) {
                return new ResourceTagIdentifier(ResourceIdentifier.either(namespace, DEFAULT_NAMESPACE), localSpace, qualifiers, string);
            }
            if (searchSpace.equals("@")) {
                if (namespace.equals("")) {
                    return new ResourceNamespaceIdentifier(localSpace, qualifiers, string);
                }
                return new MalformedResourceIdentifier(string, "unqualified identifier does not match \"@mod\"");
            }
            return new SingleResourceIdentifier(ResourceIdentifier.either(namespace, DEFAULT_NAMESPACE), localSpace, qualifiers, string);
        }
        try {
            Pattern pattern = Pattern.compile("^" + string.strip() + "$");
            return new ResourcePatternIdentifier(pattern, List.of(), string);
        }
        catch (PatternSyntaxException e) {
            return new MalformedResourceIdentifier(string, "unqualified identifier does not match \"@mod\", \"#mod:tag\", or \"mod:id\", and is not a valid regular expression");
        }
    }

    private static List<IdentifierQualifier> parseQualifiers(String qualifiersString) {
        Matcher matcher = QUALIFIERS_PATTERN.matcher(qualifiersString);
        if (matcher.find()) {
            return Arrays.stream(matcher.group(1).split(",")).map(ResourceIdentifier::parseQualifier).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private static IdentifierQualifier parseQualifier(String string) {
        String[] parts = string.split("=", 2);
        if (parts.length <= 1) {
            return new IdentifierQualifier(string, null);
        }
        return new IdentifierQualifier(parts[0], parts[1]);
    }

    private static String either(String string, String fallbackIfEmpty) {
        return string.equals("") ? fallbackIfEmpty : string;
    }

    private static void parsingError(String idString, String message) {
        TreeChop.LOGGER.warn("Configuration issue: failed to parse \"{}\": {} (to silence this warning, find and delete \"{}\" in treechop-common.toml)", (Object)idString, (Object)message, (Object)idString);
    }

    public String getNamespace() {
        return this.nameSpace;
    }

    public String getLocalSpace() {
        return this.localSpace;
    }

    public List<IdentifierQualifier> getQualifiers() {
        return this.qualifiers;
    }

    public String getString() {
        return this.string;
    }

    public String getResourceLocation() {
        return String.format("%s:%s", this.getNamespace(), this.getLocalSpace());
    }

    public abstract <R extends class_2348<T>, T> Stream<T> resolve(R var1);

    public void parsingError(String message) {
        ResourceIdentifier.parsingError(this.getString(), message);
    }

    public Optional<String> getQualifier(String key) {
        return this.qualifiers.stream().filter(qualifier -> qualifier.getKey().equals(key)).map(IdentifierQualifier::getValue).findFirst();
    }

    public boolean hasQualifier(String key) {
        return this.qualifiers.stream().anyMatch(qualifier -> qualifier.getKey().equals(key));
    }
}

