/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop;

import ht.treechop.TreeChop;
import ht.treechop.TreeChopForgeAPI;
import ht.treechop.common.ForgePlatform;
import ht.treechop.common.config.ConfigHandler;
import ht.treechop.common.network.ForgePacketHandler;
import ht.treechop.common.registry.ForgeModBlocks;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="treechop")
public class TreeChopForge
extends TreeChop {
    public TreeChopForge() {
        platform = new ForgePlatform();
        api = new TreeChopForgeAPI("treechop");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ConfigHandler.COMMON_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ConfigHandler.CLIENT_SPEC);
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.addListener(event -> ConfigHandler.onReload());
        modBus.addListener(this::processIMC);
        ForgeModBlocks.BLOCKS.register(modBus);
        ForgeModBlocks.ENTITIES.register(modBus);
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        forgeBus.addListener(event -> ConfigHandler.updateTags());
        ForgePacketHandler.registerPackets();
    }

    private void processIMC(InterModProcessEvent event) {
        event.getIMCStream(message -> message.equalsIgnoreCase("getTreeChopAPI")).forEach(action -> {
            Supplier supplier = action.messageSupplier();
            try {
                Consumer consumer = (Consumer)supplier.get();
                consumer.accept(new TreeChopForgeAPI(action.senderModId()));
            }
            catch (ClassCastException | NullPointerException e) {
                TreeChop.LOGGER.error(String.format("Failed to process getTreeChopAPI request from %s: %s", action.senderModId(), e.getMessage()));
                e.printStackTrace();
            }
        });
    }
}

