/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.client.model;

import ht.treechop.TreeChop;
import ht.treechop.client.model.ChoppedLogBakedModel;
import ht.treechop.common.block.ChoppedLogBlock;
import ht.treechop.common.chop.ChopUtil;
import ht.treechop.common.properties.ChoppedLogShape;
import ht.treechop.common.registry.ForgeModBlocks;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.AtlasSet;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.model.IDynamicBakedModel;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ForgeChoppedLogBakedModel
extends ChoppedLogBakedModel
implements IDynamicBakedModel {
    private static final RandomSource RANDOM = RandomSource.m_216327_();
    public static ModelProperty<Map<Direction, BlockState>> STRIPPED_NEIGHBORS = new ModelProperty();
    public static ModelProperty<BlockState> STRIPPED_BLOCK_STATE = new ModelProperty();
    public static ModelProperty<Integer> CHOP_COUNT = new ModelProperty();
    public static ModelProperty<ChoppedLogShape> CHOPPED_LOG_SHAPE = new ModelProperty();

    public static void overrideBlockStateModels(ModelEvent.BakingCompleted event) {
        for (BlockState blockState : ((Block)ForgeModBlocks.CHOPPED_LOG.get()).m_49965_().m_61056_()) {
            ModelResourceLocation variantMRL = BlockModelShaper.m_110895_((BlockState)blockState);
            BakedModel existingModel = event.getModelManager().m_119422_(variantMRL);
            if (existingModel == event.getModelManager().m_119409_()) {
                TreeChop.LOGGER.warn("Did not find the expected vanilla baked model(s) for treechop:chopped_log in registry");
                continue;
            }
            if (existingModel instanceof ForgeChoppedLogBakedModel) {
                TreeChop.LOGGER.warn("Tried to replace ChoppedLogBakedModel twice");
                continue;
            }
            BakedModel customModel = new ForgeChoppedLogBakedModel().m_7611_(event.getModelBakery(), arg_0 -> ((AtlasSet)event.getModelBakery().getAtlasSet()).m_117971_(arg_0), null, null);
            event.getModels().put(variantMRL, customModel);
        }
    }

    @Nonnull
    public ModelData getModelData(@Nonnull BlockAndTintGetter level, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull ModelData tileData) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof ChoppedLogBlock.MyEntity) {
            ChoppedLogBlock.MyEntity entity = (ChoppedLogBlock.MyEntity)blockEntity;
            BlockState strippedState = ChopUtil.getStrippedState(level, pos, entity.getOriginalState());
            ModelData.Builder builder = ModelData.builder();
            builder.with(STRIPPED_NEIGHBORS, this.getStrippedNeighbors(level, pos, entity, strippedState));
            builder.with(STRIPPED_BLOCK_STATE, (Object)strippedState);
            builder.with(CHOP_COUNT, (Object)(entity.getChops() + (8 - entity.getUnchoppedRadius())));
            builder.with(CHOPPED_LOG_SHAPE, (Object)entity.getShape());
            return builder.build();
        }
        return ModelData.EMPTY;
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData extraData, @Nullable RenderType renderType) {
        if (side == null && state != null) {
            Integer chops;
            ChoppedLogShape shape;
            BlockState strippedState = extraData.has(STRIPPED_BLOCK_STATE) ? (BlockState)extraData.get(STRIPPED_BLOCK_STATE) : Blocks.f_50010_.m_49966_();
            Map<Direction, BlockState> strippedNeighbors = (Map<Direction, BlockState>)extraData.get(STRIPPED_NEIGHBORS);
            if (strippedNeighbors == null) {
                strippedNeighbors = Collections.emptyMap();
            }
            if ((shape = (ChoppedLogShape)((Object)extraData.get(CHOPPED_LOG_SHAPE))) == null) {
                shape = ChoppedLogShape.PILLAR_Y;
            }
            if ((chops = (Integer)extraData.get(CHOP_COUNT)) == null) {
                chops = 1;
            }
            return this.getQuads(strippedState, shape, chops, rand, strippedNeighbors).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

