/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.common.network;

import ht.treechop.TreeChop;
import ht.treechop.common.network.CustomPacket;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class ServerUpdateChopsPacket
implements CustomPacket {
    public static final ResourceLocation ID = TreeChop.resource("server_update_chops");
    private static Level lastLevel = null;
    private final BlockPos pos;
    private final CompoundTag tag;
    private static final LinkedHashMap<BlockPos, CompoundTag> pendingUpdates = new LinkedHashMap<BlockPos, CompoundTag>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<BlockPos, CompoundTag> eldest) {
            return this.size() > 16;
        }
    };

    public ServerUpdateChopsPacket(BlockPos pos, CompoundTag tag) {
        this.pos = pos;
        this.tag = tag;
    }

    @Override
    public FriendlyByteBuf encode(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.pos);
        buffer.m_130079_(this.tag);
        return buffer;
    }

    public static ServerUpdateChopsPacket decode(FriendlyByteBuf buffer) {
        BlockPos pos = buffer.m_130135_();
        CompoundTag tag = buffer.m_130260_();
        return new ServerUpdateChopsPacket(pos, tag);
    }

    public static void handle(ServerUpdateChopsPacket message) {
        pendingUpdates.put(message.pos, message.tag);
    }

    private static void checkLevel(Level level) {
        if (level != lastLevel) {
            pendingUpdates.clear();
            lastLevel = level;
        }
    }

    public static CompoundTag getPendingUpdate(Level level, BlockPos pos) {
        ServerUpdateChopsPacket.checkLevel(level);
        return pendingUpdates.get(pos);
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public CompoundTag getTag() {
        return this.tag;
    }
}

