/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.common.util;

import java.util.Arrays;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;

public class BlockNeighbors {
    protected final BlockPos[] blocks;
    public static final BlockNeighbors HORIZONTAL_ADJACENTS = new BlockNeighbors((BlockPos[])Stream.of(new BlockPos(-1, 0, 0), new BlockPos(0, 0, -1), new BlockPos(1, 0, 0), new BlockPos(0, 0, 1)).toArray(BlockPos[]::new));
    public static final BlockNeighbors VERTICAL_ADJACENTS = new BlockNeighbors((BlockPos[])Stream.of(new BlockPos(0, -1, 0), new BlockPos(0, 1, 0)).toArray(BlockPos[]::new));
    public static final BlockNeighbors ADJACENTS = new BlockNeighbors((BlockPos[])Stream.of(HORIZONTAL_ADJACENTS.asStream(), VERTICAL_ADJACENTS.asStream()).flatMap(a -> a).toArray(BlockPos[]::new));
    public static final BlockNeighbors HORIZONTAL_DIAGONALS = new BlockNeighbors((BlockPos[])Stream.of(new BlockPos(-1, 0, -1), new BlockPos(-1, 0, 1), new BlockPos(1, 0, -1), new BlockPos(1, 0, 1)).toArray(BlockPos[]::new));
    public static final BlockNeighbors HORIZONTAL = new BlockNeighbors((BlockPos[])Stream.of(HORIZONTAL_ADJACENTS.asStream(), HORIZONTAL_DIAGONALS.asStream()).flatMap(a -> a).toArray(BlockPos[]::new));
    public static final BlockNeighbors ABOVE_ADJACENTS = new BlockNeighbors((BlockPos[])Stream.of(new BlockPos(-1, 1, 0), new BlockPos(0, 1, -1), new BlockPos(1, 1, 0), new BlockPos(0, 1, 1)).toArray(BlockPos[]::new));
    public static final BlockNeighbors ABOVE_DIAGONALS = new BlockNeighbors((BlockPos[])Stream.of(new BlockPos(-1, 1, -1), new BlockPos(-1, 1, 1), new BlockPos(1, 1, -1), new BlockPos(1, 1, 1)).toArray(BlockPos[]::new));
    public static final BlockNeighbors ABOVE = new BlockNeighbors((BlockPos[])Stream.of(ABOVE_ADJACENTS.asStream(), ABOVE_DIAGONALS.asStream(), Stream.of(new BlockPos(0, 1, 0))).flatMap(a -> a).toArray(BlockPos[]::new));
    public static final BlockNeighbors HORIZONTAL_AND_ABOVE = new BlockNeighbors((BlockPos[])Stream.of(HORIZONTAL.asStream(), ABOVE.asStream()).flatMap(a -> a).toArray(BlockPos[]::new));
    public static final BlockNeighbors BELOW_ADJACENTS = new BlockNeighbors((BlockPos[])Stream.of(new BlockPos(-1, -1, 0), new BlockPos(0, -1, -1), new BlockPos(1, -1, 0), new BlockPos(0, -1, 1)).toArray(BlockPos[]::new));
    public static final BlockNeighbors BELOW_DIAGONALS = new BlockNeighbors((BlockPos[])Stream.of(new BlockPos(-1, -1, -1), new BlockPos(-1, -1, 1), new BlockPos(1, -1, -1), new BlockPos(1, -1, 1)).toArray(BlockPos[]::new));
    public static final BlockNeighbors BELOW = new BlockNeighbors((BlockPos[])Stream.of(BELOW_ADJACENTS.asStream(), BELOW_DIAGONALS.asStream(), Stream.of(new BlockPos(0, -1, 0))).flatMap(a -> a).toArray(BlockPos[]::new));
    public static final BlockNeighbors ADJACENTS_AND_DIAGONALS = new BlockNeighbors((BlockPos[])Stream.of(ABOVE.asStream(), HORIZONTAL.asStream(), BELOW.asStream()).flatMap(a -> a).toArray(BlockPos[]::new));
    public static final BlockNeighbors ADJACENTS_AND_BELOW_ADJACENTS = new BlockNeighbors((BlockPos[])Stream.of(ADJACENTS.asStream(), BELOW_ADJACENTS.asStream()).flatMap(a -> a).toArray(BlockPos[]::new));

    public BlockNeighbors(BlockPos[] blocks) {
        this.blocks = blocks;
    }

    protected Stream<BlockPos> asStream() {
        return Arrays.stream(this.blocks);
    }

    public Stream<BlockPos> asStream(BlockPos pos) {
        return Arrays.stream(this.blocks).map(arg_0 -> ((BlockPos)pos).m_121955_(arg_0));
    }
}

