/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.compat;

import ht.treechop.TreeChop;
import ht.treechop.api.TreeData;
import ht.treechop.client.Client;
import ht.treechop.common.block.ChoppedLogBlock;
import ht.treechop.common.chop.ChopUtil;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec2;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.IWailaClientRegistration;
import snownee.jade.api.IWailaPlugin;
import snownee.jade.api.WailaPlugin;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.IElement;
import snownee.jade.impl.ui.ItemStackElement;

@WailaPlugin
public class Jade
implements IWailaPlugin,
IBlockComponentProvider {
    private static final Jade INSTANCE = new Jade();
    private static final ResourceLocation SHOW_TREE_BLOCKS = new ResourceLocation("treechop", "show_tree_block_counts");
    private static final ResourceLocation SHOW_NUM_CHOPS_REMAINING = new ResourceLocation("treechop", "show_num_chops_remaining");

    public void registerClient(IWailaClientRegistration registrar) {
        registrar.registerBlockComponent((IBlockComponentProvider)INSTANCE, Block.class);
        registrar.addConfig(SHOW_TREE_BLOCKS, true);
        registrar.addConfig(SHOW_NUM_CHOPS_REMAINING, true);
    }

    @Nullable
    public IElement getIcon(BlockAccessor accessor, IPluginConfig config, IElement currentIcon) {
        BlockState state = this.getLogState(accessor.getLevel(), accessor.getPosition(), accessor.getBlockState());
        return ItemStackElement.of((ItemStack)(state != accessor.getBlockState() ? state.m_60734_().m_5456_().m_7968_() : Items.f_41837_.m_7968_()));
    }

    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        if (ChopUtil.playerWantsToChop(accessor.getPlayer(), Client.getChopSettings()) && ChopUtil.isBlockChoppable(accessor.getLevel(), accessor.getPosition(), accessor.getBlockState()) && (config.get(SHOW_TREE_BLOCKS) || config.get(SHOW_NUM_CHOPS_REMAINING))) {
            Level level = accessor.getLevel();
            AtomicInteger numChops = new AtomicInteger(0);
            TreeData tree = Client.treeCache.getTree(level, accessor.getPosition());
            if (tree.isAProperTree(Client.getChopSettings().getTreesMustHaveLeaves())) {
                tree.getLogBlocks().ifPresent(treeBlocks -> {
                    if (config.get(SHOW_NUM_CHOPS_REMAINING)) {
                        treeBlocks.forEach(pos -> numChops.getAndAdd(ChopUtil.getNumChops(level, pos)));
                        tooltip.add((Component)Component.m_237110_((String)"treechop.waila.x_out_of_y_chops", (Object[])new Object[]{numChops.get(), ChopUtil.numChopsToFell(level, treeBlocks)}));
                    }
                    if (config.get(SHOW_TREE_BLOCKS)) {
                        LinkedList tiles = new LinkedList();
                        treeBlocks.stream().collect(Collectors.groupingBy(pos -> {
                            BlockState state = level.m_8055_(pos);
                            return this.getLogState(level, (BlockPos)pos, state).m_60734_();
                        }, Collectors.counting())).forEach((block, count) -> {
                            IElement icon = tooltip.getElementHelper().item(block.m_5456_().m_7968_(), 1.0f, count.toString());
                            tiles.add(icon.translate(new Vec2(0.0f, -1.5f)));
                        });
                        tooltip.add(tiles);
                    }
                });
            }
        }
    }

    private BlockState getLogState(Level level, BlockPos pos, BlockState state) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof ChoppedLogBlock.MyEntity) {
            ChoppedLogBlock.MyEntity entity = (ChoppedLogBlock.MyEntity)blockEntity;
            return entity.getOriginalState();
        }
        return state;
    }

    public ResourceLocation getUid() {
        return TreeChop.resource("plugin");
    }
}

