/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.compat;

import ht.treechop.api.TreeData;
import ht.treechop.client.Client;
import ht.treechop.common.block.ChoppedLogBlock;
import ht.treechop.common.chop.ChopUtil;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import mcp.mobius.waila.api.IBlockAccessor;
import mcp.mobius.waila.api.IBlockComponentProvider;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IRegistrar;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.ITooltipComponent;
import mcp.mobius.waila.api.ITooltipLine;
import mcp.mobius.waila.api.IWailaPlugin;
import mcp.mobius.waila.api.TooltipPosition;
import mcp.mobius.waila.api.component.ItemComponent;
import mcp.mobius.waila.api.component.WrappedComponent;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class Wthit
implements IWailaPlugin,
IBlockComponentProvider {
    public static final ResourceLocation SHOW_TREE_BLOCKS = new ResourceLocation("treechop", "show_tree_block_counts");
    public static final ResourceLocation SHOW_NUM_CHOPS_REMAINING = new ResourceLocation("treechop", "show_num_chops_remaining");
    private static final Wthit INSTANCE = new Wthit();

    public void register(IRegistrar registrar) {
        registrar.addConfig(SHOW_TREE_BLOCKS, true);
        registrar.addConfig(SHOW_NUM_CHOPS_REMAINING, true);
        registrar.addComponent((IBlockComponentProvider)INSTANCE, TooltipPosition.BODY, Block.class);
        registrar.addOverride((IBlockComponentProvider)INSTANCE, ChoppedLogBlock.class);
    }

    @Nullable
    public BlockState getOverride(IBlockAccessor accessor, IPluginConfig config) {
        return this.getLogState(accessor.getWorld(), accessor.getPosition(), accessor.getBlockState());
    }

    public void appendBody(ITooltip tooltip, IBlockAccessor accessor, IPluginConfig config) {
        if (ChopUtil.playerWantsToChop(accessor.getPlayer()) && ChopUtil.isBlockChoppable(accessor.getWorld(), accessor.getPosition(), accessor.getBlockState()) && (config.getBoolean(SHOW_TREE_BLOCKS) || config.getBoolean(SHOW_NUM_CHOPS_REMAINING))) {
            Level level = accessor.getWorld();
            AtomicInteger numChops = new AtomicInteger(0);
            TreeData tree = Client.treeCache.getTree(level, accessor.getPosition());
            if (tree.isAProperTree(Client.getChopSettings().getTreesMustHaveLeaves())) {
                tree.getLogBlocks().ifPresent(treeBlocks -> {
                    if (config.getBoolean(SHOW_NUM_CHOPS_REMAINING)) {
                        treeBlocks.forEach(pos -> numChops.getAndAdd(ChopUtil.getNumChops(level, pos)));
                        tooltip.addLine((ITooltipComponent)new WrappedComponent((Component)Component.m_237110_((String)"treechop.waila.x_out_of_y_chops", (Object[])new Object[]{numChops.get(), ChopUtil.numChopsToFell(level, treeBlocks)})));
                    }
                    if (config.getBoolean(SHOW_TREE_BLOCKS)) {
                        ITooltipLine line = tooltip.addLine();
                        treeBlocks.stream().collect(Collectors.groupingBy(pos -> {
                            BlockState state = level.m_8055_(pos);
                            return this.getLogState(level, (BlockPos)pos, state).m_60734_();
                        }, Collectors.counting())).forEach((block, count) -> {
                            ItemStack stack = block.m_5456_().m_7968_();
                            stack.m_41764_(count.intValue());
                            line.with((ITooltipComponent)new ItemComponent(stack));
                        });
                    }
                });
            }
        }
    }

    private BlockState getLogState(Level level, BlockPos pos, BlockState state) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof ChoppedLogBlock.MyEntity) {
            ChoppedLogBlock.MyEntity entity = (ChoppedLogBlock.MyEntity)blockEntity;
            return entity.getOriginalState();
        }
        return state;
    }
}

